% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_custom_mark}
\alias{v_specs_custom_mark}
\title{Add custom mark to chart}
\usage{
v_specs_custom_mark(vc, ...)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{...}{Options for the legend, see examples or
\href{https://www.visactor.io/vchart/option/commonChart#customMark}{online documentation}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Add custom mark to chart
}
\examples{

library(vchartr)

world_electricity \%>\% 
  subset(type == "detail") \%>\% 
  vchart() \%>\%
  v_bar(
    aes(source, generation, player = year),
    direction = "h",
    data_id = "mydata"
  ) \%>\%
  v_specs_custom_mark(
    type = "text",
    dataId = "mydata",
    style = list(
      textBaseline = "bottom",
      fontSize = 60,
      textAlign = "right",
      fontWeight = 700,
      text = JS("datum => datum.player"),
      x = JS(
        "(datum, ctx) => {",
        " return ctx.vchart.getChart().getCanvasRect().width - 50;",
        "}"
      ),
      y = JS(
        "(datum, ctx) => {",
        " return ctx.vchart.getChart().getCanvasRect().height - 150;",
        "}"
      ),
      fill = "grey",
      fillOpacity = 0.5
    )
  )
}
