% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmap.R
\name{vmap}
\alias{vmap}
\title{Create a Map}
\usage{
vmap(
  data,
  mapping = NULL,
  ...,
  projection = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{An \code{sf} object.}

\item{mapping}{efault list of aesthetic mappings to use for map.}

\item{...}{Configuration options for the map.}

\item{projection}{Geographical mapping type. See
\href{https://www.visactor.io/vchart/option/mapChart#region.projection.type}{online documentation}
for the various possible choices.}

\item{width}{Fixed width for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{height}{Fixed height for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one). Useful if you have other JavaScript that
needs to explicitly discover and interact with a specific widget instance.}
}
\value{
A \code{\link[=vmap]{vmap()}} \code{htmlwidget} object.
}
\description{
Create a Map
}
\examples{

if (rlang::is_installed(c("sf", "geojsonio"))) {
  
  library(vchartr)
  library(sf)
  
  # Create map from sf object
  vmap(co2_world)
  
  # Draw data on the map
  vmap(co2_world, aes(name = name, fill = co2_per_capita))
  
  # Change projection and colors
  vmap(
    co2_world,
    aes(name = name, fill = co2_per_capita), 
    projection = "equalEarth"
  ) \%>\% 
    v_specs_colors(
      range = c(
        "#FFFFE5", "#FFF7BC", "#FEE391", 
        "#FEC44F", "#FE9929", "#EC7014", 
        "#CC4C02", "#993404", "#662506"
      )
    ) \%>\% 
    v_specs_legend(
      orient = "bottom",
      type = "color",
      field = "fill"
    )
  
  # Map discrete data
  vmap(
    co2_world[!is.na(co2_world$co2_per_capita), ], 
    aes(
      name = name,
      fill = ifelse(co2_per_capita >= 2.3, "Above", "Under")
    )
  ) \%>\% 
    v_specs(
      area = list(
        style = list(
          stroke = "#FFFFFF"
        )
      )
    )
  
}
}
