% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.propratio2}
\alias{meta.lc.propratio2}
\title{Confidence interval for a log-linear contrast of proportion ratios from 2-group studies}
\usage{
meta.lc.propratio2(alpha, f1, f2, n1, n2, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 frequency counts}

\item{f2}{vector of group 2 frequency counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimated log-linear contrast
\item SE - standard error of log-linear contrast
\item exp(Estimate) - exponentiated log-linear contrast
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
exponentiated log-linear contrast of 2-group proportion ratios from
two or more studies.
}
\examples{
n1 <- c(50, 150, 150)
f1 <- c(16, 50, 25)
n2 <- c(50, 150, 150)
f2 <- c(7, 15, 20)
v <- c(1, -1, 0)
meta.lc.propratio2(.05, f1, f2, n1, n2, v)

# Should return:
#            Estimate        SE  exp(Estimate)   exp(LL)  exp(UL)
# Contrast -0.3853396 0.4828218      0.6802196 0.2640405 1.752378


}
\references{
\itemize{
\item \insertRef{Price2008}{vcmeta}
\item \insertRef{Bonett2015}{vcmeta}
}
}
