% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizdraws.R
\name{vizdraws}
\alias{vizdraws}
\title{vizdraws}
\usage{
vizdraws(
  prior = NULL,
  posterior = NULL,
  MME = 0,
  threshold = NULL,
  units = NULL,
  quantity = FALSE,
  tense = c("future", "past"),
  backgroundColor = "#FFFFFF",
  backgroundOpacity = 0.9,
  xlab = NULL,
  breaks = NULL,
  break_names = NULL,
  colors = NULL,
  width = NULL,
  height = NULL,
  xlim = NULL,
  font_scale = 1,
  display_mode_name = FALSE,
  title = "",
  stop_trans = FALSE,
  percentage = FALSE,
  elementId = NULL,
  logoPath = NULL,
  logoSize = 100,
  logoLocation = c("bottom-right", "top-left", "top-right", "bottom-left")
)
}
\arguments{
\item{prior}{(optional) Prior distribution or draws from it. Supported distributions: `Normal`, `uniform`, `beta`, and `gamma`. Provide either this or the posterior.}

\item{posterior}{(optional) Draws from the posterior distribution. Provide either this or the prior.}

\item{MME}{Minimum meaningful effect. If not provided, MME is set to zero.}

\item{threshold}{If the probability is greater than this threshold, a decision is considered comfortable.}

\item{units}{Optional argument to specify the units of x (e.g., dollars or applications).}

\item{quantity}{Defaults to \code{FALSE}. When set to true, the text will reflect predicting a quantity rather than a treatment effect.}

\item{tense}{Either "future" or "past." This is the tense used in the description if quantity is set to TRUE. \code{NULL}.}

\item{backgroundColor}{Defaults to \code{'#FFFFFF'}.}

\item{backgroundOpacity}{Defaults to \code{0.9}.}

\item{xlab}{Defaults to \code{NULL}.}

\item{breaks}{Defaults to \code{NULL}.}

\item{break_names}{Defaults to \code{NULL}.}

\item{colors}{Colors for the left, middle, and right areas. Defaults to c("#e41a1c", "#377eb8", "#4daf4a").}

\item{width}{Width for shiny.}

\item{height}{Height for shiny.}

\item{xlim}{Defaults to \code{NULL}.}

\item{font_scale}{Defaults to \code{1}.}

\item{display_mode_name}{Defaults to \code{FALSE}.}

\item{title}{Defaults to \code{''}.}

\item{stop_trans}{Defaults to \code{FALSE}. When set to true, the initial transition stops at posterior density.}

\item{percentage}{Defaults to \code{FALSE}. When set to true, the x-axis tick format will be set to percentage.}

\item{elementId}{Use an explicit element ID for the widget (rather than an automatically generated one). elementID for shiny.}

\item{logoPath}{Logo path. Defaults to \code{NULL}.}

\item{logoSize}{Logo size. Defaults to \code{FALSE}.}

\item{logoLocation}{Logo location. \code{c('bottom-right', 'top-left', 'top-right', 'bottom-left')}.}
}
\value{
A HTML widget object.
}
\description{
Visualize Draws from Prior or Posterior Distributions
}
\details{
A function to visualize draws from either the prior or posterior distribution, facilitating interpretation and decision-making.
}
\examples{
if(interactive()){
  set.seed(9782)
  library(vizdraws)
  vizdraws(prior = rnorm(100000))
}
}
