% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReport.R
\name{autoReport}
\alias{autoReport}
\title{Generate a Summary Report}
\usage{
autoReport(
  audioData,
  savePath = getwd(),
  includeDimensions = FALSE,
  avoidNormalCheck = c(),
  filename = "voiceR_report.html"
)
}
\arguments{
\item{audioData}{A data.frame generated by autoExtract() function.}

\item{savePath}{Character string indicating the full path to the folder to which we want to save the generated report. By default it is set to the current working directory.}

\item{includeDimensions}{Logical value indicating whether Dimensions should be also included as a factor or not. Default corresponds to FALSE.}

\item{avoidNormalCheck}{Logical vector, indicating if and what variables' distribution were transformed to normal. By default it is set to FALSE for each of the measures. Alternatively, you can set it to TRUE to avoid checking normality for all the measures.}

\item{filename}{Optional character string indicating the file name of the generated report. Default corresponds to "voiceR_report.html".}
}
\value{
html report file, which is saved in the selected path, but returns nothing.
}
\description{
Generates a summary report containing the output of autoExtract(), normalityPlots() and comparisonPlots().
}
\examples{
\donttest{
autoReport(testAudioData = testAudioData)
}

}
