% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsl2odim.R
\name{rsl2odim}
\alias{rsl2odim}
\title{Convert a NEXRAD polar volume file to an ODIM polar volume file}
\usage{
rsl2odim(
  file,
  config,
  pvolfile_out = "",
  verbose = TRUE,
  update_config = FALSE
)
}
\arguments{
\item{file}{Character (vector). Either a path to a single radar polar volume
(\code{pvol}) file containing multiple scans/sweeps, or multiple paths to scan
files containing a single scan/sweep. The file data format should be either 1)
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM}
format, which is the implementation of the OPERA data information model in
the \href{https://www.hdfgroup.org/solutions/hdf5/}{HDF5} format, 2) NEXRAD format
supported by the \href{https://trmm-fc.gsfc.nasa.gov/trmm_gv/software/rsl/}{'RSL' library} or 3) Vaisala
IRIS (IRIS RAW) format. IRIS format is not available on CRAN, see
vol2birdR development version on Github.}

\item{config}{optional configuration object of class \code{Rcpp_Vol2BirdConfig},
typically output from \link{vol2bird_config}}

\item{pvolfile_out}{Character. File name. When provided, writes a polar
volume (\code{pvol}) file in the ODIM HDF5 format to disk. Useful for converting
'RSL' formats to ODIM, and for adding 'MistNet' segmentation output.}

\item{verbose}{logical. When TRUE print profile output to console.}

\item{update_config}{logical. When TRUE processing options that are determined based on
input file characteristics are returned and updated in the object specified by the \code{config}
argument. Do not set to \code{TRUE} when \code{vol2bird()} is used in loops like \code{lapply()} or in parallel processes.}
}
\value{
No value returned, creates a file specified by \code{pvolfile_out} argument.
}
\description{
Convert a NEXRAD polar volume file to an ODIM polar volume file
}
\examples{
\donttest{
# define filenames
nexrad_file <- paste0(tempdir(),"/KBGM20221001_000243_V06")
odim_file <- paste0(tempdir(),"/KBGM20221001_000243_V06.h5")
# download NEXRAD file:
source <- "https://unidata-nexrad-level2.s3.amazonaws.com/2022/10/01/KBGM/KBGM20221001_000243_V06"
download.file(source, destfile = nexrad_file, mode="wb")
# convert NEXRAD file to ODIM hdf5 format:
rsl2odim(nexrad_file, pvolfile_out = odim_file)
# clean up
file.remove(nexrad_file)
file.remove(odim_file)
}
}
\seealso{
\itemize{
\item \code{\link[=vol2bird_config]{vol2bird_config()}}
}
}
