% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dftotable.R
\name{dftoLaTeX}
\alias{dftoLaTeX}
\title{Data Frame to LaTeX Function}
\usage{
dftoLaTeX(
  data,
  file = NA,
  fit.page = NA,
  frag = TRUE,
  title = NA,
  note = NA,
  note.align = "l",
  anchor = NA,
  align = NA,
  row.names = FALSE,
  no.escape = NA
)
}
\arguments{
\item{data}{Data set; accepts any format with column names.}

\item{file}{Saves the completed table to LaTeX with this filepath.}

\item{fit.page}{uses a LaTeX resizebox to force the table to a certain width. Often \code{'\\textwidth'}.}

\item{frag}{Set to TRUE to produce only the LaTeX table itself, or FALSE to produce a fully buildable LaTeX. Defaults to TRUE.}

\item{title}{Character variable with the title of the table. Set to \code{NA} to omit.}

\item{note}{Table note to go after the last row of the table.}

\item{note.align}{Set the alignment for the multi-column table note. Usually "l", but if you have a long note you might want to set it with "p{}"}

\item{anchor}{Character variable to be used to set a label tag for the table.}

\item{align}{Character variable with standard LaTeX formatting for alignment, for example \code{'lccc'}. You can also use this to force column widths with \code{p} in standard LaTeX style. Defaults to the first column being left-aligned and all others centered. Be sure to escape special characters, in particular backslashes (i.e. \code{p{.25\\\\textwidth}} instead of \code{p{.25\\textwidth}}).}

\item{row.names}{Flag determining whether or not the row names should be included in the table. Defaults to \code{FALSE}.}

\item{no.escape}{Vector of column indices for which special characters should not be escaped (perhaps they include markup text of their own).}
}
\description{
This function takes a data frame or matrix with column names and outputs a lightly-formatted LaTeX table version of that data frame.
}
\details{
This function is designed to feed LaTeX versions of variable tables to \code{vtable()}, \code{sumtable()}, and \code{labeltable()}.

Multi-column cells are supported. Wrap the cell's contents in a \code{multicolumn} tag as normal, and then fill in any cells that need to be deleted to make room for the multi-column cell with "DELETECELL". Or use the MULTICOL syntax of \code{dftoHTML}, that works too.

If the first column and row begins with the text "HEADERROW", then the first row will be put above the column names.
}
\examples{
df <- data.frame(var1 = 1:4,var2=5:8,var3=c('A','B','C','D'),
    var4=as.factor(c('A','B','C','C')),var5=c(TRUE,TRUE,FALSE,FALSE))
dftoLaTeX(df, align = 'ccccc')

}
