% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_numeric_or_integer_type.R
\name{check_numeric_or_integer_type}
\alias{check_numeric_or_integer_type}
\title{Check for Numeric or Integer Type}
\usage{
check_numeric_or_integer_type(
  column_name,
  dataframe,
  column_prefix = NULL,
  field_type = "numeric",
  ...
)
}
\arguments{
\item{column_name}{A character vector or string with the column name to be tested.}

\item{dataframe}{The dataframe that contains the column.}

\item{column_prefix}{Default is NULL. If provided, this text is prepended to the variable name in the assertion message.}

\item{field_type}{Default is "numeric". Specify "integer" to check if the column has an integer type. This parameter must be either "integer" or "numeric".}

\item{...}{The remaining parameters are passed to the function assert_numeric or assert_integer.}
}
\description{
This function checks if the specified column in the provided dataframe has a numeric or integer type.
It uses the checkmate::assert_numeric or checkmate::assert_integer function to perform the assertion,
depending on the value of the \code{field_type} parameter.
}
\examples{
# Create a dataframe with a numeric column
dataframe <- data.frame(a = c(1, 2, 3))
# Check the numeric type of the 'a' column
check_numeric_or_integer_type("a", dataframe)
}
\seealso{
Other assertions: 
\code{\link{check_no_duplicates_in_group}()},
\code{\link{check_posixct_type}()}

Other tests: 
\code{\link{check_double_columns}()},
\code{\link{check_no_duplicates_in_group}()},
\code{\link{check_posixct_type}()},
\code{\link{duplicates_in_column}()},
\code{\link{test_all_equal}()}
}
\concept{assertions}
\concept{tests}
