% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paginated.R
\name{paginted}
\alias{paginted}
\title{Looks up product information}
\usage{
paginted(key = auth_cache$KEY, lsPublisherId = NULL, category = NULL,
  brand = NULL, specialOffer = NULL, list_output = FALSE)
}
\arguments{
\item{key}{Your API access key.}

\item{lsPublisherId}{Your LinkShare Publisher Id.}

\item{category}{Category id of the desired category. This should match the
id field from \code{\link{taxonomy}} function.}

\item{brand}{Brand name.}

\item{specialOffer}{Special offers like (rollback, clearance, specialBuy).}

\item{list_output}{Indicator for list output.}
}
\value{
A tibble with 16 columns. First 15 is the items in base response
format, followed by a column containing the URL path for the next page.
}
\description{
\code{\link{lookup}} gives access to item price and availability in
real-time.
}
\details{
An API key will be required to run this function and can be acquired by
creating an account on the following website
\url{https://developer.walmartlabs.com/member}.

For more information refer to the original documentation
\url{https://developer.walmartlabs.com/docs/read/Home}.

Response formats are described at the url
\url{https://developer.walmartlabs.com/docs/read/Item_Field_Description}.
}
\examples{
\dontrun{
key <- "************************"

paginted(key = key, brand = "Apple")

paginted(key = key, category = 3944)

paginted(key = key, category = 3944, specialOffer = "rollback")

paginted(key = key, brand = "Apple", list_output = TRUE)
}
}
