% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_conversions.R
\name{fahrenheit.to.celsius}
\alias{fahrenheit.to.celsius}
\title{Convert from Fahrenheit to Celsius.}
\usage{
fahrenheit.to.celsius(T.fahrenheit, round = 2)
}
\arguments{
\item{T.fahrenheit}{Numeric vector of temperatures in Fahrenheit.}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of temperature values in Celsius.
}
\description{
\code{fahrenheit.to.celsius} creates a numeric vector of temperatures in
   Celsius from a numeric vector of temperatures in Fahrenheit.
}
\note{
Equations are from the source code for the US National Weather
    Service's
    \href{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}{online heat index calculator}.
}
\examples{
# Convert from Fahrenheit to Celsius.
data(norfolk)
norfolk$TempC <- fahrenheit.to.celsius(norfolk$TemperatureF)
norfolk

}
\author{
Brooke Anderson \email{brooke.anderson@colostate.edu},
Roger Peng \email{rdpeng@gmail.com}
}
\seealso{
\code{\link{celsius.to.fahrenheit}}
}

