% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_instances}
\alias{define_instances}
\alias{define_instances.when}
\title{Define instances}
\usage{
define_instances(td, start, end, values)

\method{define_instances}{when}(td, start = NULL, end = NULL, values = NULL)
}
\arguments{
\item{td}{A \code{when} object.}

\item{start}{A string, start of the period to be included in the dimension.}

\item{end}{A string, end of the period to be included in the dimension.}

\item{values}{A vector of string.}
}
\value{
A \code{when} object.
}
\description{
Using this function we can define the instances from which the dimension will
be generated according to the rest of its defined characteristics.
}
\details{
We must indicate dates or date components in ISO 8601 format (yyyy-mm-dd). The
times in hh:mm:ss format.
}
\examples{

td_1 <- when() |>
  define_instances(start = "2020", end = "2030")

td_1 <- when() |>
  define_instances(start = "2020-01-01", end = "2030-01-01")

td_2 <- when(type = 'time') |>
  define_instances(values = 1:5)

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
