% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levels_date.R
\name{select_month_level}
\alias{select_month_level}
\alias{select_month_level.when}
\title{Configure month level}
\usage{
select_month_level(
  td,
  include_all,
  exclude_all,
  month,
  year_month,
  month_name,
  month_num_name,
  month_abbr,
  month_num_abbr
)

\method{select_month_level}{when}(
  td,
  include_all = FALSE,
  exclude_all = FALSE,
  month = NULL,
  year_month = NULL,
  month_name = NULL,
  month_num_name = NULL,
  month_abbr = NULL,
  month_num_abbr = NULL
)
}
\arguments{
\item{td}{A \code{when} object.}

\item{include_all}{A boolean, include all fields of the level.}

\item{exclude_all}{A boolean, exclude all fields of the level.}

\item{month}{A boolean, include the month number.}

\item{year_month}{A boolean, include the year-month combination.}

\item{month_name}{A boolean, include the month name.}

\item{month_num_name}{A boolean, include the month number and name.}

\item{month_abbr}{A boolean, include the month name abbreviated version.}

\item{month_num_abbr}{A boolean, include the month number and name
abbreviated version.}
}
\value{
A \code{when} object.
}
\description{
When the dimension is defined as a date type, using this function we can select
the month level and its attributes to include in it. We can also obtain the
combination of the year with the month number.
}
\details{
For the month we have the month number in the year, its name and the abbreviation
of the name. So that the order of the names corresponds to the alphabetical order,
the combination of month number and name and/or abbreviation is included.

The \code{include_all} and \code{exclude_all} parameters allow us to include or exclude
all attributes, and then specifically exclude or include the ones we need.
}
\examples{

td <- when() |>
  select_month_level(month_abbr = FALSE,
                      month_num_abbr = FALSE)

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
