% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levels_date.R
\name{select_year_level}
\alias{select_year_level}
\alias{select_year_level.when}
\title{Configure year level}
\usage{
select_year_level(td, include_all, exclude_all, year, decade)

\method{select_year_level}{when}(
  td,
  include_all = FALSE,
  exclude_all = FALSE,
  year = NULL,
  decade = NULL
)
}
\arguments{
\item{td}{A \code{when} object.}

\item{include_all}{A boolean, include all fields of the level.}

\item{exclude_all}{A boolean, exclude all fields of the level.}

\item{year}{A boolean, include the year field.}

\item{decade}{A boolean, include the decade field.}
}
\value{
A \code{when} object.
}
\description{
When the dimension is defined as a date type, using this function we can select
the year level and its attributes to include in it: year and decade.
}
\details{
The \code{include_all} and \code{exclude_all} parameters allow us to include or exclude
all attributes, and then specifically exclude or include the ones we need.
}
\examples{

td <- when() |>
  select_year_level(decade = FALSE)

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
