% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lines_x3p.R
\name{x3p_add_hline}
\alias{x3p_add_hline}
\title{Add horizontal line to the mask of an x3p object}
\usage{
x3p_add_hline(x3p, yintercept, size = 5, color = "#e6bf98")
}
\arguments{
\item{x3p}{x3p object}

\item{yintercept}{(vector of) numerical values for the position of the lines.}

\item{size}{width (in pixels) of the line}

\item{color}{(vector of) character values to describe color of lines}
}
\value{
x3p object with added vertical lines in the mask
}
\description{
Add horizontal lines to overlay the surface of an x3p object. Lines are added to a mask. In case no mask exists, one is created.
}
\examples{
\dontrun{
logo <- x3p_read(system.file("csafe-logo.x3p", package = "x3ptools"))
color_logo <- magick::image_read(system.file("csafe-color.png", package = "x3ptools"))
logoplus <- x3p_add_mask(logo, as.raster(color_logo))
# five horizontal lines at equal intervals:
logoplus <- x3p_add_hline(logo, seq(0, 418 * 6.4500e-7, length = 5), size = 3)
x3p_image(logoplus, size = c(741, 419), zoom = 0.5)
}
}
