% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_bin_strips.R
\name{x3p_bin_stripes}
\alias{x3p_bin_stripes}
\title{Add colored stripes of the surface gradient to the mask of an x3p object}
\usage{
x3p_bin_stripes(
  x3p,
  direction = "vertical",
  colors = rev(c("#b12819", "#d7301f", "#e16457", "#ffffff", "#5186a2", "#175d82",
    "#134D6B")),
  freqs = c(0, 0.05, 0.1, 0.3, 0.7, 0.9, 0.95, 1)
)
}
\arguments{
\item{x3p}{object containing a 3d topographic surface}

\item{direction}{in which the stripes are created: \code{vertical} or \code{horizontal}.}

\item{colors}{vector of colors}

\item{freqs}{vector of values corresponding to color frequency (turned into quantiles of the differenced values)}
}
\value{
x3p object with mask colored by discretized surface gradient
}
\description{
Apply gradient-based color shading to the mask of a 3d topographic surface.
Gradients are determined empirically based on sequentical row- (or column-)wise
differences of surface values.
The \code{direction} parameter determines the direction of differencing.
If direction is "vertical", columns in the surface matrix are
differenced to identify whether 'vertical' stripes exist.
}
\examples{
data(wire)
x3p <- wire
if (interactive()) x3p_image(x3p, size = c(400, 400), zoom=0.8)
x3p_with <- x3p_bin_stripes(x3p, direction="vertical")
x3p_with <- x3p_bin_stripes(x3p, direction="vertical", 
colors=c("#b12819","#ffffff","#134D6B"), freqs=c(0, 0.3, 0.7, 1))
if (interactive()) x3p_image(x3p_with, size = c(400, 400), zoom=0.8)

data(lea)
if (interactive()) {
  lea \%>\% x3p_bin_stripes() \%>\% x3p_image() # default stripes
 
# three colors only   
  lea \%>\% x3p_bin_stripes(
     colors=c("#b12819","#ffffff","#134D6B"), 
     freqs=c(0, 0.3, 0.7, 1)) \%>\%  x3p_image()
}
}
