% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_x3p.R
\name{x3p_image}
\alias{x3p_image}
\alias{image_x3p}
\title{Plot x3p object as an image}
\usage{
x3p_image(
  x3p,
  file = NULL,
  col = "#cd7f32",
  size = 750,
  zoom = 0.35,
  multiply = 5,
  update = FALSE,
  ...
)

image_x3p(
  x3p,
  file = NULL,
  col = "#cd7f32",
  size = c(750, 250),
  zoom = 0.35,
  multiply = 5,
  ...
)
}
\arguments{
\item{x3p}{x3p object}

\item{file}{file name for saving, if file is NULL the opengl device stays open.
The file extension determines the type of output. Possible extensions are png, stl (suitable for 3d printing), or svg.}

\item{col}{color specification}

\item{size}{vector of width and height. If only one value is given, height or width will be adjusted proportionally to the dimensions of the surface matrix of the scan to reach an upper bound of size.}

\item{zoom}{numeric value indicating the amount of zoom}

\item{multiply}{exaggerate the relief by factor multiply}

\item{update}{Boolean value indicating whether a scene should be updated (defaults to FALSE). If FALSE, a new rgl device is opened.}

\item{...}{not used}
}
\description{
Plot an interactive surface plot of the x3p matrix. This implementation uses the \code{rgl} package.
In case \code{rgl.useNULL} is set to TRUE (i.e. no separate window will be opened), an rgl widget
can be used to show the surface in the viewer window (see the example).
}
\examples{
save <- getOption("rgl.useNULL")
options(rgl.useNULL=TRUE)

logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
x3p_image(logo, size = c(741, 419), zoom=0.5)
# add crosscut:
logoplus <- x3p_add_hline(logo, yintercept = 50*.645e-6, color = "#e6bf98", size = 5)
x3p_image(logoplus, size = c(741, 419), zoom=0.5)
widget <- rgl::rglwidget()
if (interactive())
  widget

options(rgl.useNULL=save)   
}
