% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{decodeTree}
\alias{decodeTree}
\title{Returns a list of all symbols of a derivation tree  
in depth-first left-to-right order.}
\usage{
decodeTree(tree, ST)
}
\arguments{
\item{tree}{Derivation tree.}

\item{ST}{Symbol table.}
}
\value{
List of all symbols in depth-first left-to-right order.
}
\description{
\code{decodeTree()} returns a
             list of all symbols of a derivation tree 
             in depth-first left-to-right order
             (coded as R Factor with the symbol identifiers as levels).
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
decodeTree(a, g$ST) 

}
\seealso{
Other Decoder: 
\code{\link{decodeAndFixDT}()},
\code{\link{decodeCDT}()},
\code{\link{decodeDT}()},
\code{\link{decodeDTsym}()},
\code{\link{leavesIncompleteDT}()}
}
\concept{Decoder}
