% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeExtract}
\alias{treeExtract}
\title{Extracts the subtree at position \code{pos} in a derivation tree.}
\usage{
treeExtract(tree, node)
}
\arguments{
\item{tree}{Derivation tree.}

\item{node}{Attributed node.}
}
\value{
Derivation tree.
}
\description{
\code{treeExtract()} returns 
             the subtree at position \code{pos} in a derivation tree.
}
\details{
An attributed \code{node} is a list 
             whose element \code{node$Index} contains 
             an access function to the node. 
             The access function is represented as a string 
             with an executable R index expression.
             All what remains to be done, is 
             \itemize{
             \item  to complete 
             the access statement and  
             \item to return 
             the result of parsing and evaluating the string.
             }
}
\examples{
g<-compileBNF(booleanGrammar())
t1<-randomDerivationTree(g$Start, g)
t1anl<-treeANL(t1, g$ST)
n1<-chooseNode(t1anl$ANL)
st1<-treeExtract(t1, n1)
decodeCDT(st1, g$ST)
st2<-treeExtract(t1, chooseNode(t1anl$ANLa))
decodeCDT(st2, g$ST)

}
\seealso{
Other Tree Operations: 
\code{\link{compatibleSubtrees}()},
\code{\link{treeInsert}()}
}
\concept{Tree Operations}
