% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeNodes}
\alias{treeNodes}
\title{Measures the number of inner nodes in a derivation tree.}
\usage{
treeNodes(tree, ST)
}
\arguments{
\item{tree}{Derivation tree.}

\item{ST}{Symbol table.}
}
\value{
Integer. Number of non-terminal symbols in a derivation tree.
}
\description{
\code{treeNodes()} returns 
             the number of non-terminal symbols in a 
             derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
treeNodes(a, g$ST) 

}
\seealso{
Other Measures of Tree Attributes: 
\code{\link{treeLeaves}()},
\code{\link{treeListDepth}()},
\code{\link{treeProbability}()},
\code{\link{treeSize}()}
}
\concept{Measures of Tree Attributes}
