% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfScaleFactor.R
\name{CauchySF}
\alias{CauchySF}
\title{Cauchy distribution based scale factor.}
\usage{
CauchySF(lF)
}
\arguments{
\item{lF}{Local configuration.}
}
\value{
A scale factor.
}
\description{
The scale factors is Cauchy distributed with 
             \enumerate{
             \item location parameter \code{1-0.6*t/T} and
             \item scale parameter \code{0.7-0.4(1-t/T))}.
             }
}
\details{
The parameters are constant functions defined in \code{lF}:
         \enumerate{
         \item t is the current iteration 
               (\code{lF$cGeneration}).
         \item T is the total number of generations 
               (\code{lF$Generations}).
          }
       
         The scale factor is bounded from above by \code{1}.
         For \code{SF<0}, 
         The scale factor is set to \code{abs(rnorm(1, 0, 0.2))}.  

         For details, see section 3 of Sharma et al. (2019), 
         pp. 929-931 or Fan et al. (2017), pp. 6844-6845.
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list()
lF$Generations<-parm(4)
lF$cGeneration<-parm(0)
CauchySF(lF)
lF$cGeneration<-parm(1)
CauchySF(lF)
lF$cGeneration<-parm(2)
CauchySF(lF)
lF$cGeneration<-parm(3)
CauchySF(lF)
lF$cGeneration<-parm(4)
CauchySF(lF)
}
\references{
Sharma, Prashant; Sharma, Harish; Kumar, Sandeep; Bansal, Jagdish Chand
(2019):
A Review on Scale Factor Strategies in Differential Evolution Algorithm.
pp. 925-934. In:
Bansal, Jagdish Chand et al. (2019)
Soft Computing for Problem Solving.
Advances in Intelligent Systems and Computing, Vol. 817.
Springer, Singapore, 2019. (ISBN:978-981-13-1594-7)

Fan, Qinqin; Yan, Xuefeng; Xue, Yu (2017)
Prior knowledge guided differential evolution,
Soft Computing 21(22), 6841 - 6858.
(doi:10.1007/s00500-016-2235-6)
}
\seealso{
Other Scale Factor: 
\code{\link{ConstScaleFactor}()},
\code{\link{DETVSF}()},
\code{\link{FitnessBasedSelfAdaptiveSF}()},
\code{\link{RandomGaussianSF}()},
\code{\link{UniformRandomScaleFactor}()},
\code{\link{UniformRandomScaleFactorDERSF}()}
}
\concept{Scale Factor}
