% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx2dfs.R
\name{xlsx2dfs}
\alias{xlsx2dfs}
\title{Read-in Excel file (workbook) as a list of data frames.}
\usage{
xlsx2dfs(xlsxPath, rowNames = TRUE, colNames = TRUE, ...)
}
\arguments{
\item{xlsxPath}{A path to the Excel file, a character.}

\item{rowNames}{Whether to read-in row names, a boolean.}

\item{colNames}{Whether to read-in column names, a boolean.}

\item{...}{... passed to read.xlsx function in the openxlsx package.}
}
\value{
A list of data frames, each representing a sheet in the Excel file (sheet names are list element names).
}
\description{
Read-in Excel file (workbook) as a list of data frames.
}
\examples{
# create example file
df1 <- data.frame(A=c(1, 2), B=c(3, 4))
df2 <- data.frame(C=c(5, 6), D=c(7, 8))
xlsx_fpath <- file.path(tempdir(), "testout.xlsx")
dfs2xlsx(withNames("sheet1", df1, "sheet2", df2), xlsx_fpath)
# read created file
dfs <- xlsx2dfs(xlsx_fpath)
file.remove(xlsx_fpath)
}
