% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_functions.R
\name{read_xvg}
\alias{read_xvg}
\title{read xvg files}
\usage{
read_xvg(xvg_files, skip_comments = TRUE)
}
\arguments{
\item{xvg_files}{character vector of xvg file paths}

\item{skip_comments}{logical indicating whether to skip comment lines (default: TRUE)}
}
\value{
Named list containing xvg data, using filenames (without extension) as keys
}
\description{
read one or more 'GROMACS'-generated xvg files
}
\examples{
\donttest{
library(xvm)
# Retrieve the path to the example file included in the package:
rmsd_file_path <- system.file("extdata/rmsd.xvg", package = "xvm")
rmsd_data <- read_xvg(rmsd_file_path) # read the xvg file using read_xvg() function
names(rmsd_data)
}
}
