% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.x_imp.R
\name{grnn.x_imp}
\alias{grnn.x_imp}
\title{Derive the importance of a predictor used in the GRNN}
\usage{
grnn.x_imp(net, i, class = FALSE)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{i}{The ith predictor in the GRNN}

\item{class}{TRUE or FALSE, whether it is for the classification or not}
}
\value{
A vector with the variable name and two values of importance measurements, namely "imp1" and "imp2".
        The "imp1" measures the loss of predictability after replacing all values of the predictor with its mean.
        The "imp2" measures the loss of predictability after dropping the predictor from the GRNN.
}
\description{
The function \code{grnn.x_imp} derives the importance of a predictor used in the GRNN
by using the loss of predictability after eliminating the impact of the predictor in interest.
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
grnn.x_imp(net = gnet, 1)
}
\seealso{
\code{\link{grnn.x_pfi}}
}
