% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmisc-utils.R
\name{ddply_helper}
\alias{ddply_helper}
\title{Apply a function to each column of a data.frame}
\usage{
ddply_helper(d, fun)
}
\arguments{
\item{d}{A \code{data.frame} or \code{tibble}.}

\item{fun}{A function to apply to each column of \code{d}.}
}
\value{
A \code{data.frame} or \code{tibble} with the function applied to each column.
}
\description{
Thin wrapper around \code{lapply()} that checks that the input is a table before
applying the function to each column, and converts the result back to a table
afterwards. If the \code{tibble} package is available and the input is a \code{tibble},
the result will be a \code{tibble}; otherwise, it will be a plain \code{data.frame}.
}
\examples{
df <- data.frame(
  col1 = c(1, 2, 3),
  col2 = c(4, 5, 6)
)
sum_fun <- function(x) sum(x)
result <- ddply_helper(df, sum_fun)
print(result)

}
\keyword{internal}
