








use crate::imp_prelude::*;


impl<A, S> ArrayBase<S, Ix2>
where S: RawData<Elem = A>
{









    #[track_caller]
    pub fn row(&self, index: Ix) -> ArrayView1<'_, A>
    where S: Data
    {
        self.index_axis(Axis(0), index)
    }











    #[track_caller]
    pub fn row_mut(&mut self, index: Ix) -> ArrayViewMut1<'_, A>
    where S: DataMut
    {
        self.index_axis_mut(Axis(0), index)
    }


















    pub fn nrows(&self) -> usize
    {
        self.len_of(Axis(0))
    }










    #[track_caller]
    pub fn column(&self, index: Ix) -> ArrayView1<'_, A>
    where S: Data
    {
        self.index_axis(Axis(1), index)
    }











    #[track_caller]
    pub fn column_mut(&mut self, index: Ix) -> ArrayViewMut1<'_, A>
    where S: DataMut
    {
        self.index_axis_mut(Axis(1), index)
    }


















    pub fn ncols(&self) -> usize
    {
        self.len_of(Axis(1))
    }
















    pub fn is_square(&self) -> bool
    {
        let (m, n) = self.dim();
        m == n
    }
}
