% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztils.R
\name{multipdf_cont}
\alias{multipdf_cont}
\title{Multiple Proportional Density Functions for Continuous Variables}
\usage{
multipdf_cont(var, seq_length = 50, distributions = "all")
}
\arguments{
\item{var}{The variable of which to get the PDF.}

\item{seq_length}{The length of sequence to fit the distribution to}

\item{distributions}{The distributions to fit x against}
}
\value{
A dataframe with x, the real density, and the pdf of the desired
distributions with length (nrows) equal to seq_length +1.
}
\description{
This function gets the proportional density functions for selected
distributions against continuous, non-negative numbers.
Possible distributions include "normal",
"lognormal", "gamma", "exponential", and "all".
}
\examples{
multipdf_cont(iris$Petal.Length)

multipdf_cont(iris$Sepal.Length, 100, c("normal", "lognormal"))
}
