---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, 
              dépliant à trois volets, brochure à trois volets
---

# Comment composer un dépliant à trois volets ?

## Avec la classe <ctanpkg:leaflet>

La classe <ctanpkg:leaflet>, de Rolf Niepraschk, Walter Schmidt et
Hubert Gäßlein, permet d'obtenir un dépliant à trois volets. 

Voici un exemple couvrant les réglages les plus simples. L'option `notumble`
utilisée ici affiche le recto et le verso dans le même sens (ce qui rend ici
le document plus lisible pour la FAQ) mais elle peut demander
un réglage de votre imprimante pour l'imprimer correctement. Le plus simple 
est sans doute de ne pas mettre cette option pour avoir une sortie 
recto-verso "naturelle".

``` 
\documentclass[notumble]{leaflet}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}  

  % Réglage de la marque de pliure (visible au dos)
  \renewcommand*\foldmarkrule{0.3mm}
  \renewcommand*\foldmarklength{5mm}

  % Les filets verticaux (positionnés selon les numéros indiqués)
  \CutLine*{1} % "*" empếche l'affichage de ciseaux
  \CutLine*{6} 

  % Titre
  \title{Lorem Ipsum}
  \author{}
  \date{}

\begin{document}
\maketitle
\section{Un peu de contexte}
\lipsum[1-4]
\section{L'enjeu}
\lipsum[5-10]
\section{Et quelques précisions}
\lipsum[11-14]
\section{Pour nous contacter}
\lipsum[15-18]
\end{document}
```

Notez que la [documentation](texdoc:leaflet) de l'extension est assez courte :
de fait, elle est présentée sous forme de dépliant !