/*
    Copyright (C) 2013-2024 Nicola L.C. Talbot
    www.dickimaw-books.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.texparserlib.latex;

import java.io.IOException;
import java.io.EOFException;

import com.dickimawbooks.texparserlib.*;
import com.dickimawbooks.texparserlib.auxfile.LabelInfo;

public class PageRef extends Ref
{
   public PageRef()
   {
      this("pageref");
   }

   public PageRef(String name)
   {
      super(name);
   }

   @Override
   public Object clone()
   {
      return new PageRef(getName());
   }

   @Override
   protected TeXObjectList expandref(TeXParser parser, String label, boolean hyper)
   throws IOException
   {
      LaTeXParserListener listener = (LaTeXParserListener)parser.getListener();

      TeXObjectList list = listener.createStack();

      LabelInfo info = listener.getLabelInfo(label);

      if (info == null)
      {
         TeXObject ref = listener.getPageReference(label);

         if (ref == null)
         {
            list.add(listener.createUnknownReference(label));
         }
         else if (hyper)
         {
            list.add(parser.getListener().createLink(label, ref));
         }
         else
         {
            list.add(ref, true);
         }
      }
      else
      {
         TeXObject ref = (TeXObject)info.getPage().clone();

         if (hyper)
         {
            list.add(parser.getListener().createLink(info, ref));
         }
         else
         {
            list.add(ref, true);
         }
      }

      return list;
   }

}
