---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, flottants, tourner, pivoter, rotation,
              paysage
---

# Comment modifier l'orientation d'un tableau ?

## Avec l'extension <ctanpkg:graphicx>

La commande `\rotatebox` de l'extension <ctanpkg:graphicx> permet de faire 
tourner une boîte et donc, en particulier, un tableau :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}

\begin{document}
\rotatebox{90}{%
\begin{tabular}{|c|c|}
  \hline
  salut & coucou \\
  bonjour & hello \\
  \hline
\end{tabular}}
\end{document}
```


## Avec l'extension <ctanpkg:lscape>

:::{todo} Ajouter un exemple
:::

L'extension <ctanpkg:lscape> permet de passer certaines pages 
en mode "paysage". Elle utilise la commande `\rotatebox` et est compatible 
avec l'extension <ctanpkg:longtable> (voir la question 
"[](/3_composition/tableaux/tableau_sur_plusieurs_pages)").


## Avec l'extension <ctanpkg:rotating>

L'extension <ctanpkg:rotating> permet, grâce à l'environnement `sideways`, 
de changer l'orientation d'un tableau :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{rotating}

\begin{document}
\begin{sideways}
  \begin{tabular}{|c|c|}
    \multicolumn{1}{c}{%
    \begin{turn}{60}Note\end{turn}} &
    \multicolumn{1}{c}{%
    \begin{turn}{60}Quantité\end{turn}} \\
    \hline
    0 & 3 \\
    1 & 4 \\
    2 & 11 \\
    3 & 15 \\
    4 & 23 \\
    5 & 36 \\
    \hline
  \end{tabular}
\end{sideways}
\end{document}
```


## Avec l'extension <ctanpkg:rotfloat>

:::{todo} Ajouter un exemple
:::

Si le tableau est un [flottant](/3_composition/flottants/start), 
l'extension <ctanpkg:rotfloat> permet de faire tourner les flottants 
(légende comprise).