---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, titres
---

# Comment supprimer la date sur une page de titre ?

Il faut ajouter la commande `\date{}` dans le préambule du document, 
sans argument.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Définition du titre
  \title{De grandes révélations}
  \author{François-Alexandre \textsc{Quasi}}
  \date{}

\begin{document}
\maketitle
\textit{La suite du document est hélas perdue.}
\end{document}
```


:::{seealso}
Si le sujet de la date (et de son insertion) vous intéresse, voir 
la question "[](/3_composition/texte/mots/inserer_la_date_dans_un_document)".
:::