/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

char	buf[65536];

int
main(argc, argv)
	int	argc;
	char	**argv;
{
	char	*dst;
	int	s;
	struct	sockaddr_in6	sin;
	int	sinlen, len;
	char	addrbuf[BUFSIZ];

	if (argc != 2) {
		fprintf(stderr, "Usage: %s addr\n", *argv);
		exit(1);
	}
	dst = argv[1];
	bzero(&sin, sizeof(sin));
	sin.sin6_len = sizeof(struct sockaddr_in6);
	sin.sin6_family = AF_INET6;
	sin.sin6_port = htons(10000);
	sin.sin6_flowinfo = 0;
	if ((s = socket(AF_INET6, SOCK_DGRAM, 0)) < 0) {
		perror("socket");
		exit(1);
	}
	if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("bind");
		exit(1);
	}
	sinlen = sizeof(sin);
	if ((len = recvfrom(s, buf, sizeof(buf), 0,
		(struct sockaddr *)&sin, &sinlen)) < 0) {
		perror("recvfrom");
		exit(1);
	}
	inet_ntop(AF_INET6, &(sin.sin6_addr), addrbuf, sizeof(addrbuf));
	printf("Packet (%d bytes) got from %s.%d\n", len, addrbuf,
		ntohs(sin.sin6_port));
	exit(0);
}
