/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

int
main(argc, argv)
	int	argc;
	char	**argv;
{
	char	*dst;
	int	length = 64;
	int	s, i;
	struct	sockaddr_in6	sin;
	char	*p, *q;

	if (argc <= 1) {
		fprintf(stderr, "Usage: %s dst [length]\n", *argv);
		exit(1);
	}
	dst = argv[1];
	if (argc == 3) {
		length = atoi(argv[2]);
	}
	if ((s = socket(AF_INET6, SOCK_DGRAM, 0)) < 0) {
		perror("socket");
		exit(1);
	}
	bzero(&sin, sizeof(sin));
	sin.sin6_len = sizeof(struct sockaddr_in6);
	sin.sin6_family = AF_INET6;
	sin.sin6_port = htons(10000);
	sin.sin6_flowinfo = 0;
	inet_pton(AF_INET6, dst, &sin.sin6_addr);
	if ((p = (char *)malloc(length + 1)) == NULL) {
		perror("malloc");
		exit(1);
	}
	q = p;
	for (i = 0; i < length; i++)
		*q++ = '\0';
	if (sendto(s, p, length, 0,
		(struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("sendto");
		exit(1);
	}
	exit(0);
}
