/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <kvm.h>
#include <nlist.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
#include <sys/socketvar.h>
#endif /* __FreeBSD__ >= 3 */
#include <net/if.h>
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
#include <net/if_var.h>
#endif /* __FreeBSD__ >= 3 */
#include <net/route.h>
#include <netinet/in.h>
#include <netinet6/in6_var.h>
#include <netinet6/ip6.h>
#include <netinet6/ip6_var.h>
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
#include <netinet/in_pcb.h>
#else
#include <netinet6/in6_pcb.h>
#endif /* __FreeBSD__ >= 3 */
#include <netinet6/udp6.h>
#include <netinet6/udp6_var.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#if defined(__FreeBSD__) && __FreeBSD__ >= 3
#include <errno.h>
#define in6p_next inp_list.le_next
#endif /* __FreeBSD__ >= 3 */

kvm_t	*kvmd;

struct	nlist nl[] = {
#define	N_UDB6	0
	{ "_udb6" },
	{ "" },
};

char *ifname __P((struct ifnet *));
char *in6flag __P((int));
void mc __P((struct in6_multi *));
void kread __P((u_long, void *, int));

#define	KREAD(addr, buf, type) \
	kread((u_long)addr, (void *)buf, sizeof(type))

const char *inet6_n2a(p)
	struct in6_addr *p;
{
	static char buf[BUFSIZ];

	if (IN6_IS_ADDR_ANY(p))
		return "*";
	return inet_ntop(AF_INET6, (void *)p, buf, sizeof(buf));
}

int main()
{
	char	buf[BUFSIZ];
	struct	in6pcb	udb6;
	struct	in6pcb	*udb6p;
	struct	ip6_moptions ip6m;
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
	char *sysctl_buf;
	struct xinpgen *xig, *oxig;
	struct xsocket *so;
#endif /* defined(__FreeBSD__) && __FreeBSD__ >= 3 */

	if ((kvmd = kvm_openfiles(NULL, NULL, NULL, O_RDONLY, buf)) == NULL) {
		perror("kvm_openfiles");
		exit(1);
	}
#if !defined(__FreeBSD__) || __FreeBSD__ < 3
	if (kvm_nlist(kvmd, nl) < 0) {
		perror("kvm_nlist");
		exit(1);
	}
	if (nl[N_UDB6].n_value == 0) {
		printf("symbol _udb6 not found\n");
		exit(1);
	}
	KREAD(nl[N_UDB6].n_value, &udb6, struct in6pcb);
#else /* !defined(__FreeBSD__) || __FreeBSD__ < 3 */
	{
		const char *udblist = "net.inet.udp.pcblist";
		int len;

		if (sysctlbyname(udblist, 0, &len, 0, 0) < 0) {
			if (errno != ENOENT)
				printf("sysctl: %s", udblist);
			exit(1);
		}
		if ((sysctl_buf = malloc(len)) == NULL) {
			printf("malloc failed for $d bytes: %s", len);
			exit(1);
		}
		if (sysctlbyname(udblist, sysctl_buf, &len, 0, 0) < 0) {
			printf("sysctl: %s", udblist);
			free(sysctl_buf);
			exit(1);
		}
	}
	oxig = (struct xinpgen *)sysctl_buf;
	xig = (struct xinpgen *)((char *)oxig + oxig->xig_len);
#endif /* !defined(__FreeBSD__) || __FreeBSD__ < 3 */
	while (
#if !defined(__FreeBSD__) || __FreeBSD__ < 3
	       udb6.in6p_next &&
	       udb6.in6p_next != (struct in6pcb *)nl[N_UDB6].n_value
#else /* !defined(__FreeBSD__) || __FreeBSD__ < 3 */
	       xig->xig_len > sizeof(struct xinpgen)
#endif /* !defined(__FreeBSD__) || __FreeBSD__ < 3 */
	       ) {

#if !defined(__FreeBSD__) || __FreeBSD__ < 3
		KREAD(udb6.in6p_next, &udb6, struct in6pcb);
		udb6p = &udb6;
#else /* !defined(__FreeBSD__) || __FreeBSD__ < 3 */
		udb6p = &((struct xinpcb *)xig)->xi_inp;
		so = &((struct xinpcb *)xig)->xi_socket;
#endif /* !defined(__FreeBSD__) || __FreeBSD__ < 3 */

		printf("local"
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
		       "%s%s "
#endif /* defined(__FreeBSD__) && __FreeBSD__ >= 3 */
		       "%s.%d",
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
		       (udb6p->inp_vflag & INP_IPV4) != NULL ? "4" : "",
		       (udb6p->inp_vflag & INP_IPV6) != NULL ? "6" : "",
#endif /* defined(__FreeBSD__) && __FreeBSD__ >= 3 */
		       inet6_n2a(&udb6p->in6p_laddr),
			ntohs(udb6p->in6p_lport) & 0xffff);
		printf(" foreign %s.%d", inet6_n2a(&udb6p->in6p_faddr),
			ntohs(udb6p->in6p_fport) & 0xffff);
		printf(" %s", in6flag(udb6p->in6p_flags));
		printf(" opt(%p)", udb6p->in6p_options);
		printf("\n");
		if (udb6p->in6p_moptions) {
			KREAD(udb6p->in6p_moptions, &ip6m, struct ip6_moptions);
			printf("\t");
			if (ip6m.im6o_multicast_ifp)
				printf("ifname %s ",
					ifname(ip6m.im6o_multicast_ifp));
			printf("mhlim(%d) ", ip6m.im6o_multicast_hlim);
			printf("mloop(%d) ", ip6m.im6o_multicast_loop);
#if 0
			printf("nm(%d)", ip6m.im6o_num_memberships);
			printf("\n");
		    {
			int i;
			for (i = 0; i < ip6m.im6o_num_memberships; i++) {
				mc(ip6m.im6o_membership[i]);
			}
		    }
#endif
		}
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
		xig = (struct xinpgen *)((char *)xig + xig->xig_len);
#endif /* defined(__FreeBSD__) && __FreeBSD__ >= 3 */
	}
#if defined(__FreeBSD__) && __FreeBSD__ >= 3
	free(sysctl_buf);
#endif /* defined(__FreeBSD__) && __FreeBSD__ >= 3 */

	exit(0);
	/*NOTREACHED*/
}

void mc(imp)
	struct in6_multi *imp;
{
	struct in6_multi im;

	KREAD(imp, &im, struct in6_multi);
	printf("\t\t%s", ifname(im.in6m_ifp));
	printf(" %s", inet6_n2a(&im.in6m_addr));
#if !defined(__FreeBSD__) || __FreeBSD__ < 3
	printf(" ref(%d)", im.in6m_refcount);
#endif
	printf(" timer(%d)", im.in6m_timer);
	printf("\n");
}

char *ifname(ifp)
	struct ifnet *ifp;
{
	struct ifnet ifnet;
#ifndef __NetBSD__
	char ifbuf[BUFSIZ];
#endif
	static char buf[BUFSIZ];

	KREAD(ifp, &ifnet, struct ifnet);
#ifndef __NetBSD__
	KREAD(ifnet.if_name, ifbuf, ifbuf);
	sprintf(buf, "%s%d", ifbuf, ifnet.if_unit);
#else
	KREAD(ifnet.if_xname, buf, buf);
#endif
	return buf;
}

void kread(addr, buf, len)
	u_long addr;
	void *buf;
	int len;
{
	if (kvm_read(kvmd, addr, buf, len) != len) {
		perror("kvm_read");
		exit(1);
	}
}

char *in6flag(flags)
	int flags;
{
	static char buf[BUFSIZ];

	strcpy(buf, "");
	if (flags == 0)
		return "";
#define	FLAG(x, y) if (flags & x) strcat(buf, y)
	FLAG(IN6P_RECVOPTS, " Opts");
	FLAG(IN6P_RECVRETOPTS, " Opts");
	FLAG(IN6P_RECVDSTADDR, " DstAddr");
/*
	FLAG(IN6P_HDRINCL, " HdrIncl");
*/
	return buf + 1;
}
