 /*
  * Check if an address belongs to the local system. Adapted from:
  *
  * @(#)pmap_svc.c 1.32 91/03/11 Copyright 1984,1990 Sun Microsystems, Inc.
  * @(#)get_myaddress.c  2.1 88/07/29 4.0 RPCSRC.
  */

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
#if 0
static char sccsid[] = "@(#) from_local.c 1.2 93/11/16 21:50:02";
#endif
static const char rcsid[] =
	"$Id: from_local.c,v 1.2.6.1 1997/10/10 06:16:56 charnier Exp $";
#endif

#ifdef TEST
#undef perror
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <net/if.h>
#include <net/route.h>
#include <net/if_dl.h>
#include <sys/ioctl.h>
#include <sys/sysctl.h>
#include <syslog.h>
#include <unistd.h>
#include <stdlib.h>

#ifndef TRUE
#define	TRUE	1
#define FALSE	0
#endif

/* How many interfaces could there be on a computer? */

#define	MAX_LOCAL_INIT 16
static int num_local = -1;
static int max_local = MAX_LOCAL_INIT;
static struct in_addr addrs_init[MAX_LOCAL_INIT];
static struct in_addr *addrs = addrs_init;

#define ROUNDUP(a, size) \
	(((a) & ((size)-1)) ? (1 + ((a) | ((size)-1))) : (a))

#define NEXT_SA(ap) (ap) = (struct sockaddr *) \
	((caddr_t)(ap) + ((ap)->sa_len ? ROUNDUP((ap)->sa_len,\
						 sizeof(u_long)) :\
			  			 sizeof(u_long)))
static void
get_rtaddrs(int addrs, struct sockaddr *sa, struct sockaddr **rti_info)
{
	int i;
	
	for (i = 0; i < RTAX_MAX; i++) {
		if (addrs & (1 << i)) {
			rti_info[i] = sa;
			NEXT_SA(sa);
		}
		else
			rti_info[i] = NULL;
	}
}

static int
buffer_extend()
{
	struct in_addr *newbuf;

	if ((newbuf = malloc(sizeof(struct in_addr) * max_local * 2)) == NULL) {
		warnx("memory allocation failed");
		return(-1);
	}

	memcpy(newbuf, addrs, max_local * sizeof(struct in_addr));
	if (max_local > MAX_LOCAL_INIT)
		free(addrs);
	addrs = newbuf;
	max_local = max_local * 2;

	return(0);
}

/* find_local - find all IP addresses for this host */
int
find_local()
{
	int mib[6] = {CTL_NET, AF_ROUTE, 0, 0, NET_RT_IFLIST, 0};
	int addrcount;
	char *buf, *next, *lim;
	size_t len;
	struct if_msghdr *ifm;
	struct ifa_msghdr *ifam;
	struct ifreq ifreq;
	struct sockaddr *sa, *rti_info[RTAX_MAX];
	struct sockaddr_in *sin;
	struct sockaddr_dl *sdl;

	num_local = 0;

	if (sysctl(mib, 6, NULL, &len, NULL, 0) < 0)
		return(0);
	if ((buf = malloc(len)) == NULL)
		return(0);
	if (sysctl(mib, 6, buf, &len, NULL, 0) < 0) {
		free(buf);
		return(0);
	}

	lim = buf + len;
	next = buf;
	while (next < lim) {
		ifm = (struct if_msghdr *)next;
		if (ifm->ifm_type != RTM_IFINFO ||
		    (ifm->ifm_flags & IFF_UP) == 0) {
			next += ifm->ifm_msglen;
			continue;
		}

		next += ifm->ifm_msglen;
		ifam = NULL;
		addrcount = 0;

		while (next < lim) {
			ifm = (struct if_msghdr *)next;

			if (ifm->ifm_type != RTM_NEWADDR)
				break;

			if (ifam == NULL)
				ifam = (struct ifa_msghdr *)ifm;

			addrcount++;
			next += ifm->ifm_msglen;
		}

		while (addrcount > 0) {
 			sa = (struct sockaddr *)(ifam + 1);
			get_rtaddrs(ifam->ifam_addrs, sa, rti_info);
			if ((sa = rti_info[RTAX_IFA]) != NULL) {
				if (sa->sa_family == AF_INET) {
					sin = (struct sockaddr_in *)sa;
					addrs[num_local++] = sin->sin_addr;
				}
				if (num_local >= max_local) {
					if (buffer_extend() < 0)
						goto done;
				}
			}

			addrcount--;
			ifam = (struct ifa_msghdr *)((char *)ifam +
						     ifam->ifam_msglen);
		}
	}

  done:
	free(buf);
	return(num_local);
}

/* from_local - determine whether request comes from the local system */

int
from_local(addr)
struct sockaddr_in *addr;
{
    int     i;

    if (num_local == -1 && find_local() == 0)
	syslog(LOG_ERR, "cannot find any active local network interfaces");

    for (i = 0; i < num_local; i++) {
	if (memcmp((char *) &(addr->sin_addr), (char *) &(addrs[i]),
		   sizeof(struct in_addr)) == 0)
	    return (TRUE);
    }
    return (FALSE);
}

#ifdef TEST

main()
{
    char   *inet_ntoa();
    int     i;

    find_local();
    for (i = 0; i < num_local; i++)
	printf("%s\n", inet_ntoa(addrs[i]));
}

#endif
