/*-
 * Copyright (c) 1996-1998,2000 Shunsuke Akiyama <akiyama@FreeBSD.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: odcontrol.h,v 1.3 2000/09/27 14:26:12 akiyama Exp $
 */

#ifndef _ODCONTROL_H_
#define _ODCONTROL_H_

#ifdef USE_SCSI_CAM
#include <camlib.h>
#else
#include <scsi.h>
#include <sys/scsiio.h>
#endif

/*
 * default device
 */

#ifndef DEFAULT_DEVICE
#define DEFAULT_DEVICE	"od0"
#endif

/*
 * default timeout values
 */

#define DEFAULT_TIMEOUT		(10 * 1000)	/* normal timeout value,
						   10000 mS */
#define DEFAULT_TIMEOUT2	(20 * 1000)	/* normal timeout value,
						   20000 mS */
#define DEFAULT_TIMEOUT_LONG	(3600 * 1000)	/* long timeout value,
						   3600 Sec */

/*
 * SCSI commands
 */

#define SCSI_TEST_UNIT_READY	0x00
#define SCSI_FORMAT_UNIT	0x04
#define SCSI_REASSIGN_BLOCKS	0x07
#define SCSI_MODE_SELECT	0x15
#define SCSI_MODE_SENSE		0x1a
#define SCSI_READ_CAPACITY	0x25
#define SCSI_VERIFY		0x2f

#ifndef USE_SCSI_CAM
/*
 * SCSI sense key code
 */

#define SCSI_SENSE_KEY		0x0f

#define SCSI_NO_SENSE		0
#define SCSI_RECOVERD_ERROR	1
#define SCSI_NOT_READY		2
#define SCSI_MEDIUM_ERROR	3
#define SCSI_HARDWARE_ERROR	4
#define SCSI_ILLEGAL_REQUEST	5
#define SCSI_UNIT_ATTENTION	6
#define SCSI_DATA_PROTECT	7
#define SCSI_BLANK_CHECK	8
#define SCSI_VENDOR_UNIQUE	9
#define SCSI_COPY_ABORTED	10
#define SCSI_ABORTED_COMMAND	11
#define SCSI_EQUAL		12
#define SCSI_VOLUME_OVERFLOW	13
#define SCSI_MISCOMPARE		14
#define SCSI_RESERVED		15

/*
 * SCSI sense data
 */

struct scsi_sense_data {
	u_char	err_code;
	u_char	seg_no;
	u_char	sense_key;
	u_char	info[4];
	u_char	add_sense_len;
	u_char	c_info[4];
	u_char	asc;
	u_char	ascq;
	u_char	fru;
	u_char	sk_info[3];
};

/*
 * SCSI TEST UNIT READY command
 */

struct scsi_test_unit_ready {
	u_char	op_code;
	u_char	lun;
	u_char	reserved[3];
	u_char	control;
};
#endif

/*
 * SCSI MODE SELECT/SENSE command and parameter
 */

#define SCSI_MODE_PAGE8_RCD	1	/* read cache disable */
#define SCSI_MODE_PAGE8_WCE	4	/* write cache enable */

#ifndef USE_SCSI_CAM
/* MODE SELECT command */
struct scsi_mode_select {
	u_char	op_code;
	u_char	lun_flag;
	u_char	reserved[2];
	u_char	plist_len;
	u_char	control;
};

/* MODE SENSE command */
struct scsi_mode_sense {
	u_char	op_code;
	u_char	lun_flag;
	u_char	page;
	u_char	reserved;
	u_char	alloc_len;
	u_char	control;
};
#endif

/* mode parameter header */
struct scsi_mode_parm_hdr {
	u_char	mode_parm_len;
	u_char	media_type;
	u_char	dev_parm;
	u_char	blk_desc_len;
};

/* cache control parameter */
struct scsi_cache_ctrl {
	u_char	page;
	u_char	page_len;
	u_char	cache_mode;
	u_char	priority;
	u_char	prefetch_determent[2];
	u_char	min_prefetch[2];
	u_char	max_prefetch[2];
	u_char	prefetch_limit[2];
};

/*
 * SCSI READ CAPACITY command and parameter
 */

#ifndef USE_SCSI_CAM
/* READ CAPACITY command */
struct scsi_read_capacity {
	u_char	op_code;
	u_char	lun_flag;
	u_char	lb_addr[4];
	u_char	reserved[3];
	u_char	control;
};

/* capacity data */
struct scsi_read_capacity_data {
	u_char	addr[4];
	u_char	length[4];
};
#endif

/*
 * SCSI FORMAT UNIT
 */

struct scsi_format_unit {
	u_int8_t	opcode;
	u_int8_t	byte2;
#define SFU_FMTDATA	0x10
#define SFU_CMPLST	0x08
#define SFU_BLKADDR	0
#define SFU_RELATIVE	0x04
#define SFU_PHYSCAL	0x05
#define SFU_VENDOR	0x06
	u_int8_t	dev_specific;
	u_int8_t	interleave[2];
#define SFU_DEF		0x00
#define SFU_UP		0x01
	u_int8_t	control;
};

/*
 * SCSI VERIFY
 */

struct scsi_verify_blocks {
	u_int8_t	opcode;
	u_int8_t	byte2;
#define SVR_DPO		0x10		/* Disable Page Out */
#define SVR_BYTCHK	0x02
#define SVR_RELADR	0x01
	u_int8_t	lb_addr[4];
	u_int8_t	reserved;
	u_int8_t	lb_count[2];
	u_int8_t	control;
};

#define MAX_VERIFY_LENGTH	0x800

/*
 * SCSI REASSIGN BLOCKS command and parameter
 */

/* REASSIGN BLOCKS command */
struct scsi_reassign_blocks {
	u_int8_t	opcode;
	u_int8_t	byte2;
	u_int8_t	reserved[3];
	u_int8_t	control;
};

/* defect list */
struct scsi_defect_list {
	/* defect list header */
	u_char	reserve[2];
	u_char	list_len[2];
	/* defect descriptor */
	u_char	lb_addr[4];
};

/*
 * Error codes
 */

#define ERR_BADBLOCK	-1
#define ERR_NONE	0
#define ERR_COMMAND	1
#define ERR_SYSCALL	2
#define ERR_SCSI	3

/*
 * command table
 */

struct cmd_tab {
	char	*c_name;
	char	*help;
	int	(*func)();
	char	*dev_proto;
};

/*
 * function declarations
 */

#ifdef USE_SCSI_CAM
int	scsi_error(struct ccb_scsiio *);
#else
void	scsi_error(scsireq_t *);
#endif
int	test_unit_ready(void);
int	get_cache_setting(u_char *, int);
int	get_cache_mask(u_char *, int);
int	set_cache_setting(u_char *, int);
int	format_unit(void);
int	read_capacity(u_int *);
int	verify_media(u_int, u_int, u_int *);
int	reassign_block(u_int);
int	eject_media(void);
int	get_device(char *, struct cmd_tab *);
int	open_device(void);
void	close_device(void);

void	xfprintf(FILE *, char *, ...);
void	xprintf(char *, ...);
int	get_timeout(int);

/*
 * external references
 */

extern char	*program;

extern int	timeouts;
extern int	verbose;
extern int	have_message;

extern int	bus_no;
extern int	target_no;
extern int	lun_no;

#endif /* _ODCONTROL_H_ */
