/* Store current floating-point environment.
   Copyright (C) 2001-2026 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include <fenv.h>
#include <math-inline-asm.h>

int
__fegetenv (fenv_t *envp)
{
  asm volatile ("fnstenv %0\n"
		/* fnstenv changes the exception mask, so load back the
		   stored environment.  */
		"fldenv %0"
		: "=m" (*envp));
  stmxcsr_inline_asm (&envp->__mxcsr);

  /* Success.  */
  return 0;
}
libm_hidden_def (__fegetenv)
static_weak_alias (__fegetenv, fegetenv)
libm_hidden_weak (fegetenv)
