/* src/bazaar.p/bz-hook-dialog-option.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS



#define BZ_TYPE_HOOK_DIALOG_OPTION (bz_hook_dialog_option_get_type ())
G_DECLARE_FINAL_TYPE (BzHookDialogOption, bz_hook_dialog_option, BZ, HOOK_DIALOG_OPTION, GObject)

BzHookDialogOption *
bz_hook_dialog_option_new (void);

const char *
bz_hook_dialog_option_get_id (BzHookDialogOption *self);

const char *
bz_hook_dialog_option_get_string (BzHookDialogOption *self);

const char *
bz_hook_dialog_option_get_style (BzHookDialogOption *self);

void
bz_hook_dialog_option_set_id (BzHookDialogOption *self,
    const char *id);

void
bz_hook_dialog_option_set_string (BzHookDialogOption *self,
    const char *string);

void
bz_hook_dialog_option_set_style (BzHookDialogOption *self,
    const char *style);

G_END_DECLS

/* End of src/bazaar.p/bz-hook-dialog-option.h */
