/* src/bazaar.p/bz-curated-category-info.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS



#define BZ_TYPE_CURATED_CATEGORY_INFO (bz_curated_category_info_get_type ())
G_DECLARE_FINAL_TYPE (BzCuratedCategoryInfo, bz_curated_category_info, BZ, CURATED_CATEGORY_INFO, GObject)

BzCuratedCategoryInfo *
bz_curated_category_info_new (void);

const char *
bz_curated_category_info_get_title (BzCuratedCategoryInfo *self);

const char *
bz_curated_category_info_get_subtitle (BzCuratedCategoryInfo *self);

const char *
bz_curated_category_info_get_description (BzCuratedCategoryInfo *self);

const char *
bz_curated_category_info_get_banner (BzCuratedCategoryInfo *self);

const char *
bz_curated_category_info_get_light_banner (BzCuratedCategoryInfo *self);

const char *
bz_curated_category_info_get_dark_banner (BzCuratedCategoryInfo *self);

int
bz_curated_category_info_get_banner_height (BzCuratedCategoryInfo *self);

GtkContentFit
bz_curated_category_info_get_banner_fit (BzCuratedCategoryInfo *self);

GtkAlign
bz_curated_category_info_get_banner_text_halign (BzCuratedCategoryInfo *self);

GtkAlign
bz_curated_category_info_get_banner_text_valign (BzCuratedCategoryInfo *self);

double
bz_curated_category_info_get_banner_text_label_xalign (BzCuratedCategoryInfo *self);

GListModel *
bz_curated_category_info_get_appids (BzCuratedCategoryInfo *self);

void
bz_curated_category_info_set_title (BzCuratedCategoryInfo *self,
    const char *title);

void
bz_curated_category_info_set_subtitle (BzCuratedCategoryInfo *self,
    const char *subtitle);

void
bz_curated_category_info_set_description (BzCuratedCategoryInfo *self,
    const char *description);

void
bz_curated_category_info_set_banner (BzCuratedCategoryInfo *self,
    const char *banner);

void
bz_curated_category_info_set_light_banner (BzCuratedCategoryInfo *self,
    const char *light_banner);

void
bz_curated_category_info_set_dark_banner (BzCuratedCategoryInfo *self,
    const char *dark_banner);

void
bz_curated_category_info_set_banner_height (BzCuratedCategoryInfo *self,
    int banner_height);

void
bz_curated_category_info_set_banner_fit (BzCuratedCategoryInfo *self,
    GtkContentFit banner_fit);

void
bz_curated_category_info_set_banner_text_halign (BzCuratedCategoryInfo *self,
    GtkAlign banner_text_halign);

void
bz_curated_category_info_set_banner_text_valign (BzCuratedCategoryInfo *self,
    GtkAlign banner_text_valign);

void
bz_curated_category_info_set_banner_text_label_xalign (BzCuratedCategoryInfo *self,
    double banner_text_label_xalign);

void
bz_curated_category_info_set_appids (BzCuratedCategoryInfo *self,
    GListModel *appids);

G_END_DECLS

/* End of src/bazaar.p/bz-curated-category-info.h */
