/* ContextualLigature.c generated by valac 0.56.17, the Vala compiler
 * generated from ContextualLigature.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CONTEXTUAL_LIGATURE_0_PROPERTY,
	BIRD_FONT_CONTEXTUAL_LIGATURE_NUM_PROPERTIES
};
static GParamSpec* bird_font_contextual_ligature_properties[BIRD_FONT_CONTEXTUAL_LIGATURE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BirdFontContextualLigaturePrivate {
	BirdFontFont* font;
};

static gint BirdFontContextualLigature_private_offset;
static gpointer bird_font_contextual_ligature_parent_class = NULL;

static BirdFontGlyphSequence* bird_font_contextual_ligature_get_sequence (BirdFontContextualLigature* self,
                                                                   const gchar* context);
static void bird_font_contextual_ligature_finalize (GObject * obj);
static GType bird_font_contextual_ligature_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_contextual_ligature_get_instance_private (BirdFontContextualLigature* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontContextualLigature_private_offset);
}

/** All arguments are list of glyph names separated by space. */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontContextualLigature*
bird_font_contextual_ligature_construct (GType object_type,
                                         BirdFontFont* font,
                                         const gchar* ligatures,
                                         const gchar* backtrack,
                                         const gchar* input,
                                         const gchar* lookahead)
{
	BirdFontContextualLigature * self = NULL;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (font != NULL, NULL);
	g_return_val_if_fail (ligatures != NULL, NULL);
	g_return_val_if_fail (backtrack != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (lookahead != NULL, NULL);
	self = (BirdFontContextualLigature*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (font);
	_g_object_unref0 (self->priv->font);
	self->priv->font = _tmp0_;
	_tmp1_ = g_strdup (backtrack);
	_g_free0 (self->backtrack);
	self->backtrack = _tmp1_;
	_tmp2_ = g_strdup (input);
	_g_free0 (self->input);
	self->input = _tmp2_;
	_tmp3_ = g_strdup (lookahead);
	_g_free0 (self->lookahead);
	self->lookahead = _tmp3_;
	_tmp4_ = g_strdup (ligatures);
	_g_free0 (self->ligatures);
	self->ligatures = _tmp4_;
	return self;
}

BirdFontContextualLigature*
bird_font_contextual_ligature_new (BirdFontFont* font,
                                   const gchar* ligatures,
                                   const gchar* backtrack,
                                   const gchar* input,
                                   const gchar* lookahead)
{
	return bird_font_contextual_ligature_construct (BIRD_FONT_TYPE_CONTEXTUAL_LIGATURE, font, ligatures, backtrack, input, lookahead);
}

GeeArrayList*
bird_font_contextual_ligature_get_ligatures (BirdFontContextualLigature* self)
{
	GeeArrayList* ligature_list = NULL;
	GeeArrayList* _tmp0_;
	gchar** ligatures = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint ligatures_length1;
	gint _ligatures_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LIGATURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ligature_list = _tmp0_;
	_tmp1_ = self->ligatures;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	ligatures = _tmp3_;
	ligatures_length1 = _vala_array_length (_tmp2_);
	_ligatures_size_ = ligatures_length1;
	_tmp4_ = ligatures;
	_tmp4__length1 = ligatures_length1;
	{
		gchar** ligature_name_collection = NULL;
		gint ligature_name_collection_length1 = 0;
		gint _ligature_name_collection_size_ = 0;
		gint ligature_name_it = 0;
		ligature_name_collection = _tmp4_;
		ligature_name_collection_length1 = _tmp4__length1;
		for (ligature_name_it = 0; ligature_name_it < ligature_name_collection_length1; ligature_name_it = ligature_name_it + 1) {
			gchar* _tmp5_;
			gchar* ligature_name = NULL;
			_tmp5_ = g_strdup (ligature_name_collection[ligature_name_it]);
			ligature_name = _tmp5_;
			{
				GeeArrayList* _tmp6_;
				const gchar* _tmp7_;
				BirdFontLigature* _tmp8_;
				BirdFontLigature* _tmp9_;
				_tmp6_ = ligature_list;
				_tmp7_ = ligature_name;
				_tmp8_ = bird_font_ligature_new (_tmp7_, "");
				_tmp9_ = _tmp8_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp9_);
				_g_object_unref0 (_tmp9_);
				_g_free0 (ligature_name);
			}
		}
	}
	result = ligature_list;
	ligatures = (_vala_array_free (ligatures, ligatures_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

BirdFontFontData*
bird_font_contextual_ligature_get_font_data (BirdFontContextualLigature* self,
                                             BirdFontGlyfTable* glyf_table,
                                             guint16 ligature_lookup_index,
                                             GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	GeeArrayList* backtrack = NULL;
	BirdFontFont* _tmp2_;
	const gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* input = NULL;
	BirdFontFont* _tmp5_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* lookahead = NULL;
	BirdFontFont* _tmp8_;
	const gchar* _tmp9_;
	GeeArrayList* _tmp10_;
	guint16 lookahead_offset = 0U;
	guint16 input_offset = 0U;
	guint16 backtrack_offset = 0U;
	BirdFontFontData* _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	BirdFontFontData* _tmp21_;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GeeArrayList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	BirdFontFontData* _tmp40_;
	GeeArrayList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GeeArrayList* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GeeArrayList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	GeeArrayList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	BirdFontFontData* _tmp59_;
	GeeArrayList* _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	BirdFontFontData* _tmp69_;
	BirdFontFontData* _tmp70_;
	BirdFontFontData* _tmp71_;
	BirdFontFontData* _tmp72_;
	BirdFontFontData* _tmp92_;
	BirdFontFontData* _tmp112_;
	GError* _inner_error0_ = NULL;
	BirdFontFontData* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyf_table != NULL, NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = font;
	_tmp3_ = self->backtrack;
	_tmp4_ = bird_font_font_get_names_in_reverse_order (_tmp2_, _tmp3_);
	backtrack = _tmp4_;
	_tmp5_ = font;
	_tmp6_ = self->input;
	_tmp7_ = bird_font_font_get_names (_tmp5_, _tmp6_);
	input = _tmp7_;
	_tmp8_ = font;
	_tmp9_ = self->lookahead;
	_tmp10_ = bird_font_font_get_names (_tmp8_, _tmp9_);
	lookahead = _tmp10_;
	_tmp11_ = fd;
	bird_font_font_data_add_ushort (_tmp11_, (guint16) 3, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	_tmp12_ = lookahead;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = input;
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = backtrack;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	backtrack_offset = (guint16) (((14 + ((guint16) (_tmp14_ * 2))) + ((guint16) (_tmp17_ * 2))) + ((guint16) (_tmp20_ * 2)));
	_tmp21_ = fd;
	_tmp22_ = backtrack;
	_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	bird_font_font_data_add_ushort (_tmp21_, (guint16) _tmp24_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	{
		guint16 i = 0U;
		i = (guint16) 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				BirdFontFontData* _tmp30_;
				if (!_tmp25_) {
					guint16 _tmp26_;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = backtrack;
				_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				if (!(((gint) i) < _tmp29_)) {
					break;
				}
				_tmp30_ = fd;
				bird_font_font_data_add_ushort (_tmp30_, (guint16) (backtrack_offset + (6 * i)), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (lookahead);
					_g_object_unref0 (input);
					_g_object_unref0 (backtrack);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return NULL;
				}
			}
		}
	}
	_tmp31_ = lookahead;
	_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = input;
	_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = backtrack;
	_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
	_tmp39_ = _tmp38_;
	input_offset = (guint16) (((14 + ((guint16) (_tmp33_ * 2))) + ((guint16) (_tmp36_ * 2))) + ((guint16) (_tmp39_ * (2 + 6))));
	_tmp40_ = fd;
	_tmp41_ = input;
	_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	bird_font_font_data_add_ushort (_tmp40_, (guint16) _tmp43_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	{
		guint16 i = 0U;
		i = (guint16) 0;
		{
			gboolean _tmp44_ = FALSE;
			_tmp44_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				BirdFontFontData* _tmp49_;
				if (!_tmp44_) {
					guint16 _tmp45_;
					_tmp45_ = i;
					i = _tmp45_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp46_ = input;
				_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
				_tmp48_ = _tmp47_;
				if (!(((gint) i) < _tmp48_)) {
					break;
				}
				_tmp49_ = fd;
				bird_font_font_data_add_ushort (_tmp49_, (guint16) (input_offset + (6 * i)), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (lookahead);
					_g_object_unref0 (input);
					_g_object_unref0 (backtrack);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return NULL;
				}
			}
		}
	}
	_tmp50_ = lookahead;
	_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = input;
	_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = backtrack;
	_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
	_tmp58_ = _tmp57_;
	lookahead_offset = (guint16) (((14 + ((guint16) (_tmp52_ * 2))) + ((guint16) (_tmp55_ * (2 + 6)))) + ((guint16) (_tmp58_ * (2 + 6))));
	_tmp59_ = fd;
	_tmp60_ = lookahead;
	_tmp61_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp60_);
	_tmp62_ = _tmp61_;
	bird_font_font_data_add_ushort (_tmp59_, (guint16) _tmp62_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	{
		guint16 i = 0U;
		i = (guint16) 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				BirdFontFontData* _tmp68_;
				if (!_tmp63_) {
					guint16 _tmp64_;
					_tmp64_ = i;
					i = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp65_ = lookahead;
				_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp65_);
				_tmp67_ = _tmp66_;
				if (!(((gint) i) < _tmp67_)) {
					break;
				}
				_tmp68_ = fd;
				bird_font_font_data_add_ushort (_tmp68_, (guint16) (lookahead_offset + (6 * i)), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (lookahead);
					_g_object_unref0 (input);
					_g_object_unref0 (backtrack);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return NULL;
				}
			}
		}
	}
	_tmp69_ = fd;
	bird_font_font_data_add_ushort (_tmp69_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	_tmp70_ = fd;
	bird_font_font_data_add_ushort (_tmp70_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	_tmp71_ = fd;
	bird_font_font_data_add_ushort (_tmp71_, ligature_lookup_index, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (lookahead);
		_g_object_unref0 (input);
		_g_object_unref0 (backtrack);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return NULL;
	}
	_tmp72_ = fd;
	if (bird_font_font_data_length_with_padding (_tmp72_) != ((guint) backtrack_offset)) {
		gchar* _tmp73_;
		gchar* _tmp74_;
		BirdFontFontData* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp73_ = g_strdup_printf ("%hu", backtrack_offset);
		_tmp74_ = _tmp73_;
		_tmp75_ = fd;
		_tmp76_ = g_strdup_printf ("%u", bird_font_font_data_length_with_padding (_tmp75_));
		_tmp77_ = _tmp76_;
		_tmp78_ = g_strconcat ("Wrong backtrack offset: ", _tmp74_, " != ", _tmp77_, NULL);
		_tmp79_ = _tmp78_;
		g_warning ("ContextualLigature.vala:85: %s", _tmp79_);
		_g_free0 (_tmp79_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp74_);
	}
	{
		GeeArrayList* _glyph_name_list = NULL;
		GeeArrayList* _tmp80_;
		gint _glyph_name_size = 0;
		GeeArrayList* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		gint _glyph_name_index = 0;
		_tmp80_ = backtrack;
		_glyph_name_list = _tmp80_;
		_tmp81_ = _glyph_name_list;
		_tmp82_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp81_);
		_tmp83_ = _tmp82_;
		_glyph_name_size = _tmp83_;
		_glyph_name_index = -1;
		while (TRUE) {
			gint _tmp84_;
			gint _tmp85_;
			gchar* glyph_name = NULL;
			GeeArrayList* _tmp86_;
			gpointer _tmp87_;
			BirdFontFontData* _tmp88_;
			BirdFontFontData* _tmp89_;
			BirdFontFontData* _tmp90_;
			const gchar* _tmp91_;
			_glyph_name_index = _glyph_name_index + 1;
			_tmp84_ = _glyph_name_index;
			_tmp85_ = _glyph_name_size;
			if (!(_tmp84_ < _tmp85_)) {
				break;
			}
			_tmp86_ = _glyph_name_list;
			_tmp87_ = gee_abstract_list_get ((GeeAbstractList*) _tmp86_, _glyph_name_index);
			glyph_name = (gchar*) _tmp87_;
			_tmp88_ = fd;
			bird_font_font_data_add_ushort (_tmp88_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp89_ = fd;
			bird_font_font_data_add_ushort (_tmp89_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp90_ = fd;
			_tmp91_ = glyph_name;
			bird_font_font_data_add_ushort (_tmp90_, (guint16) bird_font_glyf_table_get_gid (glyf_table, _tmp91_), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_g_free0 (glyph_name);
		}
	}
	_tmp92_ = fd;
	if (bird_font_font_data_length_with_padding (_tmp92_) != ((guint) input_offset)) {
		gchar* _tmp93_;
		gchar* _tmp94_;
		BirdFontFontData* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		_tmp93_ = g_strdup_printf ("%hu", input_offset);
		_tmp94_ = _tmp93_;
		_tmp95_ = fd;
		_tmp96_ = g_strdup_printf ("%u", bird_font_font_data_length_with_padding (_tmp95_));
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strconcat ("Wrong input offset: ", _tmp94_, " != ", _tmp97_, NULL);
		_tmp99_ = _tmp98_;
		g_warning ("ContextualLigature.vala:97: %s", _tmp99_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp94_);
	}
	{
		GeeArrayList* _glyph_name_list = NULL;
		GeeArrayList* _tmp100_;
		gint _glyph_name_size = 0;
		GeeArrayList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _glyph_name_index = 0;
		_tmp100_ = input;
		_glyph_name_list = _tmp100_;
		_tmp101_ = _glyph_name_list;
		_tmp102_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_glyph_name_size = _tmp103_;
		_glyph_name_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			gchar* glyph_name = NULL;
			GeeArrayList* _tmp106_;
			gpointer _tmp107_;
			BirdFontFontData* _tmp108_;
			BirdFontFontData* _tmp109_;
			BirdFontFontData* _tmp110_;
			const gchar* _tmp111_;
			_glyph_name_index = _glyph_name_index + 1;
			_tmp104_ = _glyph_name_index;
			_tmp105_ = _glyph_name_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _glyph_name_list;
			_tmp107_ = gee_abstract_list_get ((GeeAbstractList*) _tmp106_, _glyph_name_index);
			glyph_name = (gchar*) _tmp107_;
			_tmp108_ = fd;
			bird_font_font_data_add_ushort (_tmp108_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp109_ = fd;
			bird_font_font_data_add_ushort (_tmp109_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp110_ = fd;
			_tmp111_ = glyph_name;
			bird_font_font_data_add_ushort (_tmp110_, (guint16) bird_font_glyf_table_get_gid (glyf_table, _tmp111_), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_g_free0 (glyph_name);
		}
	}
	_tmp112_ = fd;
	if (bird_font_font_data_length_with_padding (_tmp112_) != ((guint) lookahead_offset)) {
		gchar* _tmp113_;
		gchar* _tmp114_;
		BirdFontFontData* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		_tmp113_ = g_strdup_printf ("%hu", lookahead_offset);
		_tmp114_ = _tmp113_;
		_tmp115_ = fd;
		_tmp116_ = g_strdup_printf ("%u", bird_font_font_data_length_with_padding (_tmp115_));
		_tmp117_ = _tmp116_;
		_tmp118_ = g_strconcat ("Wrong lookahead offset: ", _tmp114_, " != ", _tmp117_, NULL);
		_tmp119_ = _tmp118_;
		g_warning ("ContextualLigature.vala:109: %s", _tmp119_);
		_g_free0 (_tmp119_);
		_g_free0 (_tmp117_);
		_g_free0 (_tmp114_);
	}
	{
		GeeArrayList* _glyph_name_list = NULL;
		GeeArrayList* _tmp120_;
		gint _glyph_name_size = 0;
		GeeArrayList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _glyph_name_index = 0;
		_tmp120_ = lookahead;
		_glyph_name_list = _tmp120_;
		_tmp121_ = _glyph_name_list;
		_tmp122_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_glyph_name_size = _tmp123_;
		_glyph_name_index = -1;
		while (TRUE) {
			gint _tmp124_;
			gint _tmp125_;
			gchar* glyph_name = NULL;
			GeeArrayList* _tmp126_;
			gpointer _tmp127_;
			BirdFontFontData* _tmp128_;
			BirdFontFontData* _tmp129_;
			BirdFontFontData* _tmp130_;
			const gchar* _tmp131_;
			_glyph_name_index = _glyph_name_index + 1;
			_tmp124_ = _glyph_name_index;
			_tmp125_ = _glyph_name_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _glyph_name_list;
			_tmp127_ = gee_abstract_list_get ((GeeAbstractList*) _tmp126_, _glyph_name_index);
			glyph_name = (gchar*) _tmp127_;
			_tmp128_ = fd;
			bird_font_font_data_add_ushort (_tmp128_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp129_ = fd;
			bird_font_font_data_add_ushort (_tmp129_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp130_ = fd;
			_tmp131_ = glyph_name;
			bird_font_font_data_add_ushort (_tmp130_, (guint16) bird_font_glyf_table_get_gid (glyf_table, _tmp131_), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (glyph_name);
				_g_object_unref0 (lookahead);
				_g_object_unref0 (input);
				_g_object_unref0 (backtrack);
				_g_object_unref0 (font);
				_g_object_unref0 (fd);
				return NULL;
			}
			_g_free0 (glyph_name);
		}
	}
	result = fd;
	_g_object_unref0 (lookahead);
	_g_object_unref0 (input);
	_g_object_unref0 (backtrack);
	_g_object_unref0 (font);
	return result;
}

BirdFontGlyphSequence*
bird_font_contextual_ligature_get_backtrack (BirdFontContextualLigature* self)
{
	const gchar* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->backtrack;
	_tmp1_ = bird_font_contextual_ligature_get_sequence (self, _tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontGlyphSequence*
bird_font_contextual_ligature_get_input (BirdFontContextualLigature* self)
{
	const gchar* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->input;
	_tmp1_ = bird_font_contextual_ligature_get_sequence (self, _tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontGlyphSequence*
bird_font_contextual_ligature_get_lookahead (BirdFontContextualLigature* self)
{
	const gchar* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->lookahead;
	_tmp1_ = bird_font_contextual_ligature_get_sequence (self, _tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontGlyphSequence*
bird_font_contextual_ligature_get_ligature_sequence (BirdFontContextualLigature* self)
{
	const gchar* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ligatures;
	_tmp1_ = bird_font_contextual_ligature_get_sequence (self, _tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
bird_font_contextual_ligature_is_valid (BirdFontContextualLigature* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _s_list = NULL;
		BirdFontFont* _tmp0_;
		const gchar* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _s_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _s_index = 0;
		_tmp0_ = self->priv->font;
		_tmp1_ = self->backtrack;
		_tmp2_ = bird_font_font_get_names (_tmp0_, _tmp1_);
		_s_list = _tmp2_;
		_tmp3_ = _s_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_s_size = _tmp5_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* s = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontFont* _tmp10_;
			const gchar* _tmp11_;
			BirdFontGlyphCollection* _tmp12_;
			BirdFontGlyphCollection* _tmp13_;
			gboolean _tmp14_;
			_s_index = _s_index + 1;
			_tmp6_ = _s_index;
			_tmp7_ = _s_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _s_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _s_index);
			s = (gchar*) _tmp9_;
			_tmp10_ = self->priv->font;
			_tmp11_ = s;
			_tmp12_ = bird_font_font_get_glyph_collection_by_name (_tmp10_, _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_ == NULL;
			_g_object_unref0 (_tmp13_);
			if (_tmp14_) {
				result = FALSE;
				_g_free0 (s);
				_g_object_unref0 (_s_list);
				return result;
			}
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	{
		GeeArrayList* _s_list = NULL;
		BirdFontFont* _tmp15_;
		const gchar* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _s_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _s_index = 0;
		_tmp15_ = self->priv->font;
		_tmp16_ = self->input;
		_tmp17_ = bird_font_font_get_names (_tmp15_, _tmp16_);
		_s_list = _tmp17_;
		_tmp18_ = _s_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_s_size = _tmp20_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gchar* s = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			BirdFontFont* _tmp25_;
			const gchar* _tmp26_;
			BirdFontGlyphCollection* _tmp27_;
			BirdFontGlyphCollection* _tmp28_;
			gboolean _tmp29_;
			_s_index = _s_index + 1;
			_tmp21_ = _s_index;
			_tmp22_ = _s_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _s_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _s_index);
			s = (gchar*) _tmp24_;
			_tmp25_ = self->priv->font;
			_tmp26_ = s;
			_tmp27_ = bird_font_font_get_glyph_collection_by_name (_tmp25_, _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = _tmp28_ == NULL;
			_g_object_unref0 (_tmp28_);
			if (_tmp29_) {
				result = FALSE;
				_g_free0 (s);
				_g_object_unref0 (_s_list);
				return result;
			}
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	{
		GeeArrayList* _s_list = NULL;
		BirdFontFont* _tmp30_;
		const gchar* _tmp31_;
		GeeArrayList* _tmp32_;
		gint _s_size = 0;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _s_index = 0;
		_tmp30_ = self->priv->font;
		_tmp31_ = self->lookahead;
		_tmp32_ = bird_font_font_get_names (_tmp30_, _tmp31_);
		_s_list = _tmp32_;
		_tmp33_ = _s_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_s_size = _tmp35_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gchar* s = NULL;
			GeeArrayList* _tmp38_;
			gpointer _tmp39_;
			BirdFontFont* _tmp40_;
			const gchar* _tmp41_;
			BirdFontGlyphCollection* _tmp42_;
			BirdFontGlyphCollection* _tmp43_;
			gboolean _tmp44_;
			_s_index = _s_index + 1;
			_tmp36_ = _s_index;
			_tmp37_ = _s_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _s_list;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _s_index);
			s = (gchar*) _tmp39_;
			_tmp40_ = self->priv->font;
			_tmp41_ = s;
			_tmp42_ = bird_font_font_get_glyph_collection_by_name (_tmp40_, _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = _tmp43_ == NULL;
			_g_object_unref0 (_tmp43_);
			if (_tmp44_) {
				result = FALSE;
				_g_free0 (s);
				_g_object_unref0 (_s_list);
				return result;
			}
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	{
		GeeArrayList* _s_list = NULL;
		BirdFontFont* _tmp45_;
		const gchar* _tmp46_;
		GeeArrayList* _tmp47_;
		gint _s_size = 0;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _s_index = 0;
		_tmp45_ = self->priv->font;
		_tmp46_ = self->ligatures;
		_tmp47_ = bird_font_font_get_names (_tmp45_, _tmp46_);
		_s_list = _tmp47_;
		_tmp48_ = _s_list;
		_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_s_size = _tmp50_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			gchar* s = NULL;
			GeeArrayList* _tmp53_;
			gpointer _tmp54_;
			BirdFontFont* _tmp55_;
			const gchar* _tmp56_;
			BirdFontGlyphCollection* _tmp57_;
			BirdFontGlyphCollection* _tmp58_;
			gboolean _tmp59_;
			_s_index = _s_index + 1;
			_tmp51_ = _s_index;
			_tmp52_ = _s_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _s_list;
			_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _s_index);
			s = (gchar*) _tmp54_;
			_tmp55_ = self->priv->font;
			_tmp56_ = s;
			_tmp57_ = bird_font_font_get_glyph_collection_by_name (_tmp55_, _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = _tmp58_ == NULL;
			_g_object_unref0 (_tmp58_);
			if (_tmp59_) {
				result = FALSE;
				_g_free0 (s);
				_g_object_unref0 (_s_list);
				return result;
			}
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	result = TRUE;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static BirdFontGlyphSequence*
bird_font_contextual_ligature_get_sequence (BirdFontContextualLigature* self,
                                            const gchar* context)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphSequence* gs = NULL;
	BirdFontGlyphSequence* _tmp0_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = bird_font_glyph_sequence_new ();
	_g_object_unref0 (gs);
	gs = _tmp0_;
	{
		GeeArrayList* _s_list = NULL;
		BirdFontFont* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _s_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _s_index = 0;
		_tmp1_ = self->priv->font;
		_tmp2_ = bird_font_font_get_names (_tmp1_, context);
		_s_list = _tmp2_;
		_tmp3_ = _s_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_s_size = _tmp5_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* s = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontFont* _tmp10_;
			const gchar* _tmp11_;
			BirdFontGlyphCollection* _tmp12_;
			BirdFontGlyphCollection* _tmp13_;
			BirdFontGlyphSequence* _tmp19_;
			GeeArrayList* _tmp20_;
			BirdFontGlyphCollection* _tmp21_;
			BirdFontGlyph* _tmp22_;
			BirdFontGlyph* _tmp23_;
			_s_index = _s_index + 1;
			_tmp6_ = _s_index;
			_tmp7_ = _s_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _s_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _s_index);
			s = (gchar*) _tmp9_;
			_tmp10_ = self->priv->font;
			_tmp11_ = s;
			_tmp12_ = bird_font_font_get_glyph_collection_by_name (_tmp10_, _tmp11_);
			_g_object_unref0 (gc);
			gc = _tmp12_;
			_tmp13_ = gc;
			if (_tmp13_ == NULL) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				BirdFontGlyphSequence* _tmp18_;
				_tmp14_ = s;
				_tmp15_ = string_to_string (_tmp14_);
				_tmp16_ = g_strconcat ("No glyph found for ", _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				g_warning ("ContextualLigature.vala:175: %s", _tmp17_);
				_g_free0 (_tmp17_);
				_tmp18_ = bird_font_glyph_sequence_new ();
				result = _tmp18_;
				_g_free0 (s);
				_g_object_unref0 (_s_list);
				_g_object_unref0 (gs);
				_g_object_unref0 (gc);
				return result;
			}
			_tmp19_ = gs;
			_tmp20_ = _tmp19_->glyph;
			_tmp21_ = gc;
			_tmp22_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			_tmp23_ = _tmp22_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp23_);
			_g_object_unref0 (_tmp23_);
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	result = gs;
	_g_object_unref0 (gc);
	return result;
}

static void
bird_font_contextual_ligature_class_init (BirdFontContextualLigatureClass * klass,
                                          gpointer klass_data)
{
	bird_font_contextual_ligature_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontContextualLigature_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_contextual_ligature_finalize;
}

static void
bird_font_contextual_ligature_instance_init (BirdFontContextualLigature * self,
                                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = bird_font_contextual_ligature_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->backtrack = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->input = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->lookahead = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->ligatures = _tmp3_;
}

static void
bird_font_contextual_ligature_finalize (GObject * obj)
{
	BirdFontContextualLigature * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CONTEXTUAL_LIGATURE, BirdFontContextualLigature);
	_g_free0 (self->backtrack);
	_g_free0 (self->input);
	_g_free0 (self->lookahead);
	_g_free0 (self->ligatures);
	_g_object_unref0 (self->priv->font);
	G_OBJECT_CLASS (bird_font_contextual_ligature_parent_class)->finalize (obj);
}

static GType
bird_font_contextual_ligature_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontContextualLigatureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_contextual_ligature_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontContextualLigature), 0, (GInstanceInitFunc) bird_font_contextual_ligature_instance_init, NULL };
	GType bird_font_contextual_ligature_type_id;
	bird_font_contextual_ligature_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontContextualLigature", &g_define_type_info, 0);
	BirdFontContextualLigature_private_offset = g_type_add_instance_private (bird_font_contextual_ligature_type_id, sizeof (BirdFontContextualLigaturePrivate));
	return bird_font_contextual_ligature_type_id;
}

GType
bird_font_contextual_ligature_get_type (void)
{
	static volatile gsize bird_font_contextual_ligature_type_id__once = 0;
	if (g_once_init_enter (&bird_font_contextual_ligature_type_id__once)) {
		GType bird_font_contextual_ligature_type_id;
		bird_font_contextual_ligature_type_id = bird_font_contextual_ligature_get_type_once ();
		g_once_init_leave (&bird_font_contextual_ligature_type_id__once, bird_font_contextual_ligature_type_id);
	}
	return bird_font_contextual_ligature_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

