/* SvgFont.c generated by valac 0.56.17, the Vala compiler
 * generated from SvgFont.vala, do not modify */

/*
Copyright (C) 2013 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <glib-object.h>
#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <xmlbird.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_SVG_FONT (bird_font_svg_font_get_type ())
#define BIRD_FONT_SVG_FONT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFont))
#define BIRD_FONT_SVG_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFontClass))
#define BIRD_FONT_IS_SVG_FONT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_SVG_FONT))
#define BIRD_FONT_IS_SVG_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_SVG_FONT))
#define BIRD_FONT_SVG_FONT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFontClass))

typedef struct _BirdFontSvgFont BirdFontSvgFont;
typedef struct _BirdFontSvgFontClass BirdFontSvgFontClass;
typedef struct _BirdFontSvgFontPrivate BirdFontSvgFontPrivate;
enum  {
	BIRD_FONT_SVG_FONT_0_PROPERTY,
	BIRD_FONT_SVG_FONT_NUM_PROPERTIES
};
static GParamSpec* bird_font_svg_font_properties[BIRD_FONT_SVG_FONT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _bird_font_svg_parser_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_svg_parser_unref (var), NULL)))

struct _BirdFontSvgFont {
	GObject parent_instance;
	BirdFontSvgFontPrivate * priv;
};

struct _BirdFontSvgFontClass {
	GObjectClass parent_class;
};

struct _BirdFontSvgFontPrivate {
	BirdFontFont* font;
	gdouble units;
	gdouble font_advance;
};

static gint BirdFontSvgFont_private_offset;
static gpointer bird_font_svg_font_parent_class = NULL;

VALA_EXTERN GType bird_font_svg_font_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontSvgFont* bird_font_svg_font_new (BirdFontFont* f);
VALA_EXTERN BirdFontSvgFont* bird_font_svg_font_construct (GType object_type,
                                               BirdFontFont* f);
VALA_EXTERN void bird_font_svg_font_load (BirdFontSvgFont* self,
                              const gchar* path);
static void bird_font_svg_font_parse_svg_font (BirdFontSvgFont* self,
                                        BTag* tag);
static void bird_font_svg_font_parse_font_tag (BirdFontSvgFont* self,
                                        BTag* tag);
static void bird_font_svg_font_parse_font_limits (BirdFontSvgFont* self,
                                           BTag* tag);
static void bird_font_svg_font_parse_hkern (BirdFontSvgFont* self,
                                     BTag* tag);
static void bird_font_svg_font_parse_glyph (BirdFontSvgFont* self,
                                     BTag* tag);
static gunichar bird_font_svg_font_get_unichar (const gchar* val);
static gboolean bird_font_svg_font_is_ligature (BirdFontSvgFont* self,
                                         const gchar* v);
static void bird_font_svg_font_finalize (GObject * obj);
static GType bird_font_svg_font_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_svg_font_get_instance_private (BirdFontSvgFont* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSvgFont_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontSvgFont*
bird_font_svg_font_construct (GType object_type,
                              BirdFontFont* f)
{
	BirdFontSvgFont * self = NULL;
	BirdFontFont* _tmp0_;
	g_return_val_if_fail (f != NULL, NULL);
	self = (BirdFontSvgFont*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (self->priv->font);
	self->priv->font = _tmp0_;
	return self;
}

BirdFontSvgFont*
bird_font_svg_font_new (BirdFontFont* f)
{
	return bird_font_svg_font_construct (BIRD_FONT_TYPE_SVG_FONT, f);
}

/** Load svg font from file. */
void
bird_font_svg_font_load (BirdFontSvgFont* self,
                         const gchar* path)
{
	gchar* data = NULL;
	BXmlParser* xml_parser = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	{
		gchar* _tmp0_ = NULL;
		BXmlParser* _tmp1_;
		BXmlParser* _tmp2_;
		BTag* _tmp3_;
		BTag* _tmp4_;
		g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = b_xml_parser_new (data);
		_g_object_unref0 (xml_parser);
		xml_parser = _tmp1_;
		_tmp2_ = xml_parser;
		_tmp3_ = b_xml_parser_get_root_tag (_tmp2_);
		_tmp4_ = _tmp3_;
		bird_font_svg_font_parse_svg_font (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("SvgFont.vala:37: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (xml_parser);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (xml_parser);
	_g_free0 (data);
}

static void
bird_font_svg_font_parse_svg_font (BirdFontSvgFont* self,
                                   BTag* tag)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			BTag* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BTag* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			BTag* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			BTag* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp4_ = t;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "defs") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				BTag* _tmp8_;
				_tmp8_ = t;
				bird_font_svg_font_parse_svg_font (self, _tmp8_);
			}
			_tmp9_ = t;
			_tmp10_ = b_tag_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "font") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BTag* _tmp13_;
				BTag* _tmp14_;
				_tmp13_ = t;
				bird_font_svg_font_parse_font_tag (self, _tmp13_);
				_tmp14_ = t;
				bird_font_svg_font_parse_svg_font (self, _tmp14_);
			}
			_tmp15_ = t;
			_tmp16_ = b_tag_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp17_, "font-face") == 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				BTag* _tmp19_;
				_tmp19_ = t;
				bird_font_svg_font_parse_font_limits (self, _tmp19_);
			}
			_tmp20_ = t;
			_tmp21_ = b_tag_get_name (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strcmp0 (_tmp22_, "hkern") == 0;
			_g_free0 (_tmp22_);
			if (_tmp23_) {
				BTag* _tmp24_;
				_tmp24_ = t;
				bird_font_svg_font_parse_hkern (self, _tmp24_);
			}
			_tmp25_ = t;
			_tmp26_ = b_tag_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strcmp0 (_tmp27_, "glyph") == 0;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				BTag* _tmp29_;
				_tmp29_ = t;
				bird_font_svg_font_parse_glyph (self, _tmp29_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
bird_font_svg_font_parse_hkern (BirdFontSvgFont* self,
                                BTag* tag)
{
	gchar* left = NULL;
	gchar* _tmp0_;
	gchar* right = NULL;
	gchar* _tmp1_;
	gchar* left_name = NULL;
	gchar* _tmp2_;
	gchar* right_name = NULL;
	gchar* _tmp3_;
	gdouble kerning = 0.0;
	gunichar l = 0U;
	gunichar r = 0U;
	GString* sl = NULL;
	GString* sr = NULL;
	BirdFontGlyphRange* grr = NULL;
	BirdFontGlyphRange* grl = NULL;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp4_;
	BirdFontFont* _tmp5_;
	BirdFontKerningClasses* _tmp6_;
	BirdFontKerningClasses* _tmp7_;
	const gchar* _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = g_strdup ("");
	left = _tmp0_;
	_tmp1_ = g_strdup ("");
	right = _tmp1_;
	_tmp2_ = g_strdup ("");
	left_name = _tmp2_;
	_tmp3_ = g_strdup ("");
	right_name = _tmp3_;
	kerning = (gdouble) 0;
	_tmp4_ = bird_font_bird_font_get_current_font ();
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_font_get_kerning_classes (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	classes = _tmp7_;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp8_;
		BAttributes* _tmp9_;
		BAttributesIterator* _tmp10_;
		BAttributesIterator* _tmp11_;
		_tmp8_ = b_tag_get_attributes (tag);
		_tmp9_ = _tmp8_;
		_tmp10_ = b_attributes_iterator (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_attr_it = _tmp11_;
		while (TRUE) {
			BAttributesIterator* _tmp12_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp13_;
			BAttribute* _tmp14_;
			BAttribute* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			BAttribute* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			BAttribute* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gboolean _tmp30_;
			BAttribute* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gboolean _tmp36_;
			BAttribute* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gboolean _tmp42_;
			_tmp12_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _attr_it;
			_tmp14_ = b_attributes_iterator_get (_tmp13_);
			attr = _tmp14_;
			_tmp15_ = attr;
			_tmp16_ = b_attribute_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp17_, "u1") == 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				BAttribute* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = attr;
				_tmp20_ = b_attribute_get_content (_tmp19_);
				_g_free0 (left);
				left = _tmp20_;
			}
			_tmp21_ = attr;
			_tmp22_ = b_attribute_get_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "u2") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				BAttribute* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = attr;
				_tmp26_ = b_attribute_get_content (_tmp25_);
				_g_free0 (right);
				right = _tmp26_;
			}
			_tmp27_ = attr;
			_tmp28_ = b_attribute_get_name (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strcmp0 (_tmp29_, "g1") == 0;
			_g_free0 (_tmp29_);
			if (_tmp30_) {
				BAttribute* _tmp31_;
				gchar* _tmp32_;
				_tmp31_ = attr;
				_tmp32_ = b_attribute_get_content (_tmp31_);
				_g_free0 (left_name);
				left_name = _tmp32_;
			}
			_tmp33_ = attr;
			_tmp34_ = b_attribute_get_name (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strcmp0 (_tmp35_, "g2") == 0;
			_g_free0 (_tmp35_);
			if (_tmp36_) {
				BAttribute* _tmp37_;
				gchar* _tmp38_;
				_tmp37_ = attr;
				_tmp38_ = b_attribute_get_content (_tmp37_);
				_g_free0 (right_name);
				right_name = _tmp38_;
			}
			_tmp39_ = attr;
			_tmp40_ = b_attribute_get_name (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strcmp0 (_tmp41_, "k") == 0;
			_g_free0 (_tmp41_);
			if (_tmp42_) {
				BAttribute* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp43_ = attr;
				_tmp44_ = b_attribute_get_content (_tmp43_);
				_tmp45_ = _tmp44_;
				kerning = double_parse (_tmp45_) * self->priv->units;
				_g_free0 (_tmp45_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp46_ = left;
	_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, ",", 0);
	{
		gchar** lk_collection = NULL;
		gint lk_collection_length1 = 0;
		gint _lk_collection_size_ = 0;
		gint lk_it = 0;
		lk_collection = _tmp48_;
		lk_collection_length1 = _vala_array_length (_tmp47_);
		for (lk_it = 0; lk_it < lk_collection_length1; lk_it = lk_it + 1) {
			gchar* _tmp49_;
			gchar* lk = NULL;
			_tmp49_ = g_strdup (lk_collection[lk_it]);
			lk = _tmp49_;
			{
				const gchar* _tmp50_;
				gchar** _tmp51_;
				gchar** _tmp52_;
				_tmp50_ = right;
				_tmp52_ = _tmp51_ = g_strsplit (_tmp50_, ",", 0);
				{
					gchar** rk_collection = NULL;
					gint rk_collection_length1 = 0;
					gint _rk_collection_size_ = 0;
					gint rk_it = 0;
					rk_collection = _tmp52_;
					rk_collection_length1 = _vala_array_length (_tmp51_);
					for (rk_it = 0; rk_it < rk_collection_length1; rk_it = rk_it + 1) {
						gchar* _tmp53_;
						gchar* rk = NULL;
						_tmp53_ = g_strdup (rk_collection[rk_it]);
						rk = _tmp53_;
						{
							const gchar* _tmp54_;
							const gchar* _tmp55_;
							GString* _tmp56_;
							GString* _tmp57_;
							GString* _tmp58_;
							GString* _tmp59_;
							_tmp54_ = lk;
							l = bird_font_svg_font_get_unichar (_tmp54_);
							_tmp55_ = rk;
							r = bird_font_svg_font_get_unichar (_tmp55_);
							_tmp56_ = g_string_new ("");
							_g_string_free0 (sl);
							sl = _tmp56_;
							_tmp57_ = sl;
							g_string_append_unichar (_tmp57_, l);
							_tmp58_ = g_string_new ("");
							_g_string_free0 (sr);
							sr = _tmp58_;
							_tmp59_ = sr;
							g_string_append_unichar (_tmp59_, r);
							{
								BirdFontGlyphRange* _tmp60_;
								BirdFontGlyphRange* _tmp61_;
								GString* _tmp62_;
								const gchar* _tmp63_;
								BirdFontGlyphRange* _tmp64_;
								BirdFontGlyphRange* _tmp65_;
								GString* _tmp66_;
								const gchar* _tmp67_;
								BirdFontKerningClasses* _tmp68_;
								BirdFontGlyphRange* _tmp69_;
								BirdFontGlyphRange* _tmp70_;
								_tmp60_ = bird_font_glyph_range_new ();
								_bird_font_glyph_range_unref0 (grl);
								grl = _tmp60_;
								_tmp61_ = grl;
								_tmp62_ = sl;
								_tmp63_ = _tmp62_->str;
								bird_font_glyph_range_parse_ranges (_tmp61_, _tmp63_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == G_MARKUP_ERROR) {
										goto __catch0_g_markup_error;
									}
									_g_free0 (rk);
									rk_collection = (_vala_array_free (rk_collection, rk_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (lk);
									lk_collection = (_vala_array_free (lk_collection, lk_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (classes);
									_bird_font_glyph_range_unref0 (grl);
									_bird_font_glyph_range_unref0 (grr);
									_g_string_free0 (sr);
									_g_string_free0 (sl);
									_g_free0 (right_name);
									_g_free0 (left_name);
									_g_free0 (right);
									_g_free0 (left);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								_tmp64_ = bird_font_glyph_range_new ();
								_bird_font_glyph_range_unref0 (grr);
								grr = _tmp64_;
								_tmp65_ = grr;
								_tmp66_ = sr;
								_tmp67_ = _tmp66_->str;
								bird_font_glyph_range_parse_ranges (_tmp65_, _tmp67_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == G_MARKUP_ERROR) {
										goto __catch0_g_markup_error;
									}
									_g_free0 (rk);
									rk_collection = (_vala_array_free (rk_collection, rk_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (lk);
									lk_collection = (_vala_array_free (lk_collection, lk_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (classes);
									_bird_font_glyph_range_unref0 (grl);
									_bird_font_glyph_range_unref0 (grr);
									_g_string_free0 (sr);
									_g_string_free0 (sl);
									_g_free0 (right_name);
									_g_free0 (left_name);
									_g_free0 (right);
									_g_free0 (left);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								_tmp68_ = classes;
								_tmp69_ = grl;
								_tmp70_ = grr;
								bird_font_kerning_classes_set_kerning (_tmp68_, _tmp69_, _tmp70_, -kerning, -1);
							}
							goto __finally0;
							__catch0_g_markup_error:
							{
								GError* e = NULL;
								GError* _tmp71_;
								const gchar* _tmp72_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp71_ = e;
								_tmp72_ = _tmp71_->message;
								g_warning ("SvgFont.vala:123: %s", _tmp72_);
								_g_error_free0 (e);
							}
							__finally0:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (rk);
								rk_collection = (_vala_array_free (rk_collection, rk_collection_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (lk);
								lk_collection = (_vala_array_free (lk_collection, lk_collection_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (classes);
								_bird_font_glyph_range_unref0 (grl);
								_bird_font_glyph_range_unref0 (grr);
								_g_string_free0 (sr);
								_g_string_free0 (sl);
								_g_free0 (right_name);
								_g_free0 (left_name);
								_g_free0 (right);
								_g_free0 (left);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							_g_free0 (rk);
						}
					}
					rk_collection = (_vala_array_free (rk_collection, rk_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (lk);
			}
		}
		lk_collection = (_vala_array_free (lk_collection, lk_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (classes);
	_bird_font_glyph_range_unref0 (grl);
	_bird_font_glyph_range_unref0 (grr);
	_g_string_free0 (sr);
	_g_string_free0 (sl);
	_g_free0 (right_name);
	_g_free0 (left_name);
	_g_free0 (right);
	_g_free0 (left);
}

static void
bird_font_svg_font_parse_font_limits (BirdFontSvgFont* self,
                                      BTag* tag)
{
	gdouble top_limit = 0.0;
	gdouble bottom_limit = 0.0;
	BirdFontFont* _tmp35_;
	BirdFontFont* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	top_limit = (gdouble) 0;
	bottom_limit = (gdouble) 0;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp0_;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp0_ = b_tag_get_attributes (tag);
		_tmp1_ = _tmp0_;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_attr_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			BAttribute* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _attr_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			attr = _tmp6_;
			_tmp7_ = attr;
			_tmp8_ = b_attribute_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp9_, "units-per-em") == 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				BAttribute* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = attr;
				_tmp12_ = b_attribute_get_content (_tmp11_);
				_tmp13_ = _tmp12_;
				self->priv->units = 100.0 / double_parse (_tmp13_);
				_g_free0 (_tmp13_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp14_;
		BAttributes* _tmp15_;
		BAttributesIterator* _tmp16_;
		BAttributesIterator* _tmp17_;
		_tmp14_ = b_tag_get_attributes (tag);
		_tmp15_ = _tmp14_;
		_tmp16_ = b_attributes_iterator (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_attr_it = _tmp17_;
		while (TRUE) {
			BAttributesIterator* _tmp18_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp19_;
			BAttribute* _tmp20_;
			BAttribute* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			BAttribute* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp31_;
			_tmp18_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _attr_it;
			_tmp20_ = b_attributes_iterator_get (_tmp19_);
			attr = _tmp20_;
			_tmp21_ = attr;
			_tmp22_ = b_attribute_get_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "ascent") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				BAttribute* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp25_ = attr;
				_tmp26_ = b_attribute_get_content (_tmp25_);
				_tmp27_ = _tmp26_;
				top_limit = double_parse (_tmp27_);
				_g_free0 (_tmp27_);
			}
			_tmp28_ = attr;
			_tmp29_ = b_attribute_get_name (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strcmp0 (_tmp30_, "descent") == 0;
			_g_free0 (_tmp30_);
			if (_tmp31_) {
				BAttribute* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp32_ = attr;
				_tmp33_ = b_attribute_get_content (_tmp32_);
				_tmp34_ = _tmp33_;
				bottom_limit = double_parse (_tmp34_);
				_g_free0 (_tmp34_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	top_limit *= self->priv->units;
	bottom_limit *= self->priv->units;
	_tmp35_ = self->priv->font;
	_tmp35_->bottom_limit = bottom_limit;
	_tmp36_ = self->priv->font;
	_tmp36_->top_limit = top_limit;
}

static void
bird_font_svg_font_parse_font_tag (BirdFontSvgFont* self,
                                   BTag* tag)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp0_;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp0_ = b_tag_get_attributes (tag);
		_tmp1_ = _tmp0_;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_attr_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			BAttribute* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			BAttribute* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			_tmp4_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _attr_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			attr = _tmp6_;
			_tmp7_ = attr;
			_tmp8_ = b_attribute_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp9_, "horiz-adv-x") == 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				BAttribute* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = attr;
				_tmp12_ = b_attribute_get_content (_tmp11_);
				_tmp13_ = _tmp12_;
				self->priv->font_advance = double_parse (_tmp13_);
				_g_free0 (_tmp13_);
			}
			_tmp14_ = attr;
			_tmp15_ = b_attribute_get_name (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strcmp0 (_tmp16_, "id") == 0;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				BirdFontFont* _tmp18_;
				BAttribute* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp18_ = self->priv->font;
				_tmp19_ = attr;
				_tmp20_ = b_attribute_get_content (_tmp19_);
				_tmp21_ = _tmp20_;
				bird_font_font_set_name (_tmp18_, _tmp21_);
				_g_free0 (_tmp21_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
}

/** Obtain unichar value from either a character, a hex representation of
 *  a character or series of characters (f, &#x6d; or ffi).
 */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gunichar
bird_font_svg_font_get_unichar (const gchar* val)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	gunichar unicode_value = 0U;
	const gchar* _tmp1_;
	gunichar result;
	g_return_val_if_fail (val != NULL, 0U);
	_tmp0_ = g_strdup (val);
	v = _tmp0_;
	if (g_strcmp0 (val, "&") == 0) {
		result = (gunichar) '&';
		_g_free0 (v);
		return result;
	}
	_tmp1_ = v;
	if (g_str_has_prefix (_tmp1_, "&")) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp2_ = v;
		_tmp3_ = v;
		_tmp4_ = string_substring (_tmp2_, (glong) 0, (glong) string_index_of (_tmp3_, ";", 0));
		_g_free0 (v);
		v = _tmp4_;
		_tmp5_ = v;
		_tmp6_ = string_replace (_tmp5_, "&#x", "U+");
		_g_free0 (v);
		v = _tmp6_;
		_tmp7_ = v;
		_tmp8_ = string_replace (_tmp7_, ";", "");
		_g_free0 (v);
		v = _tmp8_;
		_tmp9_ = v;
		unicode_value = bird_font_font_to_unichar (_tmp9_);
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = v;
		if (g_utf8_strlen (_tmp10_, (gssize) -1) > 1) {
			g_warning ("SvgFont.vala:190: font contains ligatures");
			result = (gunichar) '\0';
			_g_free0 (v);
			return result;
		}
		_tmp11_ = v;
		unicode_value = string_get_char (_tmp11_, (glong) 0);
	}
	result = unicode_value;
	_g_free0 (v);
	return result;
}

static gboolean
bird_font_svg_font_is_ligature (BirdFontSvgFont* self,
                                const gchar* v)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (v != NULL, FALSE);
	if (g_str_has_prefix (v, "&")) {
		result = FALSE;
		return result;
	}
	result = g_utf8_strlen (v, (gssize) -1) > 1;
	return result;
}

static void
bird_font_svg_font_parse_glyph (BirdFontSvgFont* self,
                                BTag* tag)
{
	gunichar unicode_value = 0U;
	gchar* glyph_name = NULL;
	gchar* _tmp0_;
	gchar* svg = NULL;
	gchar* _tmp1_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyphCollection* glyph_collection = NULL;
	gdouble advance = 0.0;
	gchar* ligature = NULL;
	gchar* _tmp2_;
	BirdFontSvgParser* parser = NULL;
	BirdFontSvgParser* _tmp3_;
	GString* unicode_name = NULL;
	BirdFontSvgParser* _tmp4_;
	GString* _tmp47_;
	const gchar* _tmp48_;
	BirdFontGlyph* _tmp49_;
	BirdFontSvgParser* _tmp50_;
	const gchar* _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	const gchar* _tmp54_;
	BirdFontGlyphCollection* _tmp55_;
	BirdFontFont* _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	unicode_value = (gunichar) 0;
	_tmp0_ = g_strdup ("");
	glyph_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	svg = _tmp1_;
	advance = self->priv->font_advance;
	_tmp2_ = g_strdup ("");
	ligature = _tmp2_;
	_tmp3_ = bird_font_svg_parser_new ();
	parser = _tmp3_;
	_tmp4_ = parser;
	bird_font_svg_parser_set_format (_tmp4_, BIRD_FONT_SVG_FORMAT_INKSCAPE);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp5_;
		BAttributes* _tmp6_;
		BAttributesIterator* _tmp7_;
		BAttributesIterator* _tmp8_;
		_tmp5_ = b_tag_get_attributes (tag);
		_tmp6_ = _tmp5_;
		_tmp7_ = b_attributes_iterator (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_attr_it = _tmp8_;
		while (TRUE) {
			BAttributesIterator* _tmp9_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp10_;
			BAttribute* _tmp11_;
			BAttribute* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_;
			BAttribute* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp31_;
			BAttribute* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gboolean _tmp37_;
			BAttribute* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gboolean _tmp43_;
			_tmp9_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _attr_it;
			_tmp11_ = b_attributes_iterator_get (_tmp10_);
			attr = _tmp11_;
			_tmp12_ = attr;
			_tmp13_ = b_attribute_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strcmp0 (_tmp14_, "unicode") == 0;
			_g_free0 (_tmp14_);
			if (_tmp15_) {
				BAttribute* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				BAttribute* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gboolean _tmp25_;
				_tmp16_ = attr;
				_tmp17_ = b_attribute_get_content (_tmp16_);
				_tmp18_ = _tmp17_;
				unicode_value = bird_font_svg_font_get_unichar (_tmp18_);
				_g_free0 (_tmp18_);
				_tmp19_ = glyph_name;
				if (g_strcmp0 (_tmp19_, "") == 0) {
					BAttribute* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = attr;
					_tmp21_ = b_attribute_get_content (_tmp20_);
					_g_free0 (glyph_name);
					glyph_name = _tmp21_;
				}
				_tmp22_ = attr;
				_tmp23_ = b_attribute_get_content (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = bird_font_svg_font_is_ligature (self, _tmp24_);
				_g_free0 (_tmp24_);
				if (_tmp25_) {
					BAttribute* _tmp26_;
					gchar* _tmp27_;
					_tmp26_ = attr;
					_tmp27_ = b_attribute_get_content (_tmp26_);
					_g_free0 (ligature);
					ligature = _tmp27_;
				}
			}
			_tmp28_ = attr;
			_tmp29_ = b_attribute_get_name (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strcmp0 (_tmp30_, "d") == 0;
			_g_free0 (_tmp30_);
			if (_tmp31_) {
				BAttribute* _tmp32_;
				gchar* _tmp33_;
				_tmp32_ = attr;
				_tmp33_ = b_attribute_get_content (_tmp32_);
				_g_free0 (svg);
				svg = _tmp33_;
			}
			_tmp34_ = attr;
			_tmp35_ = b_attribute_get_name (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strcmp0 (_tmp36_, "glyph-name") == 0;
			_g_free0 (_tmp36_);
			if (_tmp37_) {
				BAttribute* _tmp38_;
				gchar* _tmp39_;
				_tmp38_ = attr;
				_tmp39_ = b_attribute_get_content (_tmp38_);
				_g_free0 (glyph_name);
				glyph_name = _tmp39_;
			}
			_tmp40_ = attr;
			_tmp41_ = b_attribute_get_name (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strcmp0 (_tmp42_, "horiz-adv-x") == 0;
			_g_free0 (_tmp42_);
			if (_tmp43_) {
				BAttribute* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp44_ = attr;
				_tmp45_ = b_attribute_get_content (_tmp44_);
				_tmp46_ = _tmp45_;
				advance = double_parse (_tmp46_);
				_g_free0 (_tmp46_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp47_ = g_string_new ("");
	_g_string_free0 (unicode_name);
	unicode_name = _tmp47_;
	g_string_append_unichar (unicode_name, unicode_value);
	_tmp48_ = unicode_name->str;
	_tmp49_ = bird_font_glyph_new (_tmp48_, unicode_value);
	_g_object_unref0 (glyph);
	glyph = _tmp49_;
	_tmp50_ = parser;
	_tmp51_ = svg;
	bird_font_svg_parser_add_path_to_glyph (_tmp50_, _tmp51_, glyph, TRUE, self->priv->units);
	_tmp52_ = bird_font_glyph_get_left_limit (glyph);
	_tmp53_ = _tmp52_;
	bird_font_glyph_set_right_limit (glyph, _tmp53_ + (advance * self->priv->units));
	_tmp54_ = glyph_name;
	_tmp55_ = bird_font_glyph_collection_new (unicode_value, _tmp54_);
	_g_object_unref0 (glyph_collection);
	glyph_collection = _tmp55_;
	bird_font_glyph_collection_insert_glyph (glyph_collection, glyph, TRUE);
	_tmp56_ = self->priv->font;
	bird_font_font_add_glyph_collection (_tmp56_, glyph_collection);
	_g_string_free0 (unicode_name);
	_bird_font_svg_parser_unref0 (parser);
	_g_free0 (ligature);
	_g_object_unref0 (glyph_collection);
	_g_object_unref0 (glyph);
	_g_free0 (svg);
	_g_free0 (glyph_name);
}

static void
bird_font_svg_font_class_init (BirdFontSvgFontClass * klass,
                               gpointer klass_data)
{
	bird_font_svg_font_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontSvgFont_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_svg_font_finalize;
}

static void
bird_font_svg_font_instance_init (BirdFontSvgFont * self,
                                  gpointer klass)
{
	self->priv = bird_font_svg_font_get_instance_private (self);
	self->priv->units = (gdouble) 1;
	self->priv->font_advance = (gdouble) 0;
}

static void
bird_font_svg_font_finalize (GObject * obj)
{
	BirdFontSvgFont * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFont);
	_g_object_unref0 (self->priv->font);
	G_OBJECT_CLASS (bird_font_svg_font_parent_class)->finalize (obj);
}

static GType
bird_font_svg_font_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSvgFontClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_svg_font_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSvgFont), 0, (GInstanceInitFunc) bird_font_svg_font_instance_init, NULL };
	GType bird_font_svg_font_type_id;
	bird_font_svg_font_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontSvgFont", &g_define_type_info, 0);
	BirdFontSvgFont_private_offset = g_type_add_instance_private (bird_font_svg_font_type_id, sizeof (BirdFontSvgFontPrivate));
	return bird_font_svg_font_type_id;
}

GType
bird_font_svg_font_get_type (void)
{
	static volatile gsize bird_font_svg_font_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_font_type_id__once)) {
		GType bird_font_svg_font_type_id;
		bird_font_svg_font_type_id = bird_font_svg_font_get_type_once ();
		g_once_init_leave (&bird_font_svg_font_type_id__once, bird_font_svg_font_type_id);
	}
	return bird_font_svg_font_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

