/* RelevancyService.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RelevancyService.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-appindexer.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "budgie-private.h"
#include "fuzzer.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_RELEVANCY_SERVICE_0_PROPERTY,
	BUDGIE_RELEVANCY_SERVICE_NUM_PROPERTIES
};
static GParamSpec* budgie_relevancy_service_properties[BUDGIE_RELEVANCY_SERVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer budgie_relevancy_service_parent_class = NULL;
static GeeHashMap* budgie_relevancy_service_scores;
static GeeHashMap* budgie_relevancy_service_scores = NULL;

static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint budgie_relevancy_service_get_best_score (BudgieRelevancyService* self,
                                              gchar** elements,
                                              gint elements_length1,
                                              const gchar* term);
static gboolean budgie_relevancy_service_array_contains (BudgieRelevancyService* self,
                                                  gchar** array,
                                                  gint array_length1,
                                                  const gchar* term);
static gboolean budgie_relevancy_service_is_default_handler (BudgieRelevancyService* self,
                                                      BudgieApplication* app);
static void budgie_relevancy_service_finalize (GObject * obj);
static GType budgie_relevancy_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
* Return a string suitable for working on.
* This works around the issue of GNOME Control Center and others deciding to
* use soft hyphens in their .desktop files.
*/
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
budgie_relevancy_service_searchable_string (const gchar* input)
{
	gchar* mod = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = g_strconcat ("", input, NULL);
	mod = _tmp0_;
	_tmp1_ = string_replace (mod, "\u00AD", "");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	_g_free0 (mod);
	return result;
}

/**
* Get the current relevancy score for an application.
*
* The lower the score, the more relevant it is.
*/
gint
budgie_relevancy_service_get_score (BudgieRelevancyService* self,
                                    BudgieApplication* app)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (app != NULL, 0);
	_tmp0_ = budgie_relevancy_service_scores;
	if (_tmp0_ == NULL) {
		g_warning ("RelevancyService.vala:49: Relevancy HashMap has not been initialized!");
		result = G_MAXINT;
		return result;
	}
	_tmp1_ = budgie_relevancy_service_scores;
	_tmp2_ = budgie_application_get_desktop_id (app);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp3_);
	result = (gint) ((gintptr) _tmp4_);
	return result;
}

/**
* Check if an application's relevancy score is below our
* relevancy threshold.
*/
gboolean
budgie_relevancy_service_is_app_relevant (BudgieRelevancyService* self,
                                          BudgieApplication* app)
{
	GeeHashMap* _tmp0_;
	gint score = 0;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (app != NULL, FALSE);
	_tmp0_ = budgie_relevancy_service_scores;
	if (_tmp0_ == NULL) {
		g_warning ("RelevancyService.vala:62: Relevancy HashMap has not been initialized!");
		result = FALSE;
		return result;
	}
	score = budgie_relevancy_service_get_score (self, app);
	if (score >= 0) {
		_tmp1_ = score < BUDGIE_RELEVANCY_SERVICE_THRESHOLD;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

/**
* Clears our relevancy mappings.
*/
void
budgie_relevancy_service_reset (BudgieRelevancyService* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_relevancy_service_scores;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = budgie_relevancy_service_scores;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
}

/**
* Determine a score in relation to a given search term.
*
* Somewhat unintuitively, the lower the score returned,
* the more relevant this item is. This is because we take
* the Levenshtein Distance between the term and the name
* into account, and it's way easier to have an arbitrary
* threshold when you have a set minimum value.
*
* This was inspired by prior art from Brisk Menu.
*/
static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
budgie_relevancy_service_update_relevancy (BudgieRelevancyService* self,
                                           BudgieApplication* app,
                                           const gchar* term)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _term = NULL;
	gchar* _tmp4_;
	gchar** data = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint data_length1;
	gint _data_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint score = 0;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* name = NULL;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar** fields = NULL;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	const gchar* _tmp43_;
	gboolean _tmp45_ = FALSE;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	GeeHashMap* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	g_return_if_fail (term != NULL);
	_tmp0_ = budgie_relevancy_service_scores;
	if (_tmp0_ == NULL) {
		g_warning ("RelevancyService.vala:95: Relevancy HashMap has not been initialized!");
		return;
	}
	_tmp1_ = budgie_relevancy_service_scores;
	_tmp2_ = budgie_application_get_desktop_id (app);
	_tmp3_ = _tmp2_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp3_, NULL);
	if (g_strcmp0 (term, "") == 0) {
		return;
	}
	_tmp4_ = g_utf8_casefold (term, (gssize) -1);
	_term = _tmp4_;
	_tmp5_ = budgie_application_get_name (app);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = budgie_application_get_generic_name (app);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp7_;
	_tmp11_[1] = _tmp10_;
	data = _tmp11_;
	data_length1 = 2;
	_data_size_ = data_length1;
	_tmp12_ = budgie_application_get_keywords (app, &_tmp13_);
	_tmp12__length1 = _tmp13_;
	_tmp14_ = _tmp12_;
	_tmp14__length1 = _tmp12__length1;
	{
		gchar** k_collection = NULL;
		gint k_collection_length1 = 0;
		gint _k_collection_size_ = 0;
		gint k_it = 0;
		k_collection = _tmp14_;
		k_collection_length1 = _tmp14__length1;
		for (k_it = 0; k_it < k_collection_length1; k_it = k_it + 1) {
			gchar* _tmp15_;
			gchar* k = NULL;
			_tmp15_ = g_strdup (k_collection[k_it]);
			k = _tmp15_;
			{
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = k;
				_tmp17_ = g_strdup (_tmp16_);
				_vala_array_add1 (&data, &data_length1, &_data_size_, _tmp17_);
				_g_free0 (k);
			}
		}
	}
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	_tmp19_ = _term;
	score = budgie_relevancy_service_get_best_score (self, _tmp18_, (gint) _tmp18__length1, _tmp19_);
	if (score < 0) {
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp20_ = budgie_relevancy_service_scores;
		_tmp21_ = budgie_application_get_desktop_id (app);
		_tmp22_ = _tmp21_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp22_, (gpointer) ((gintptr) score));
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_term);
		return;
	}
	_tmp23_ = budgie_application_get_name (app);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_utf8_casefold (_tmp24_, (gssize) -1);
	name = _tmp25_;
	if (score == 0) {
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GeeHashMap* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp26_ = name;
		_tmp27_ = _term;
		if (!g_str_has_prefix (_tmp26_, _tmp27_)) {
			gint _tmp28_;
			_tmp28_ = score;
			score = _tmp28_ + 1;
		}
		_tmp29_ = budgie_relevancy_service_scores;
		_tmp30_ = budgie_application_get_desktop_id (app);
		_tmp31_ = _tmp30_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp31_, (gpointer) ((gintptr) score));
		_g_free0 (name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_term);
		return;
	}
	_tmp32_ = name;
	_tmp33_ = _term;
	if (string_contains (_tmp32_, _tmp33_)) {
		gint _tmp34_;
		_tmp34_ = score;
		score = _tmp34_ - 1;
	}
	_tmp35_ = budgie_application_get_description (app);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup (_tmp36_);
	_tmp38_ = budgie_application_get_exec (app);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strdup (_tmp39_);
	_tmp41_ = g_new0 (gchar*, 2 + 1);
	_tmp41_[0] = _tmp37_;
	_tmp41_[1] = _tmp40_;
	fields = _tmp41_;
	fields_length1 = 2;
	_fields_size_ = fields_length1;
	_tmp42_ = fields;
	_tmp42__length1 = fields_length1;
	_tmp43_ = _term;
	if (budgie_relevancy_service_array_contains (self, _tmp42_, (gint) _tmp42__length1, _tmp43_)) {
		gint _tmp44_;
		_tmp44_ = score;
		score = _tmp44_ - 1;
	}
	_tmp46_ = name;
	_tmp47_ = _term;
	if (string_contains (_tmp46_, _tmp47_)) {
		_tmp45_ = budgie_relevancy_service_is_default_handler (self, app);
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gint _tmp50_;
		_tmp48_ = budgie_application_get_name (app);
		_tmp49_ = _tmp48_;
		g_debug ("RelevancyService.vala:157: Application '%s' is default handler", _tmp49_);
		_tmp50_ = score;
		score = _tmp50_ - 1;
	}
	_tmp51_ = budgie_relevancy_service_scores;
	_tmp52_ = budgie_application_get_desktop_id (app);
	_tmp53_ = _tmp52_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp51_, _tmp53_, (gpointer) ((gintptr) MAX (score, 0)));
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
	data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_term);
}

/**
    	 * Retrieve the highest score by performing a fuzzy match on a list of strings
 */
static gint
budgie_relevancy_service_get_best_score (BudgieRelevancyService* self,
                                         gchar** elements,
                                         gint elements_length1,
                                         const gchar* term)
{
	gint score = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (term != NULL, 0);
	score = -1;
	{
		gchar** e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = elements;
		e_collection_length1 = elements_length1;
		for (e_it = 0; e_it < e_collection_length1; e_it = e_it + 1) {
			gchar* _tmp0_;
			gchar* e = NULL;
			_tmp0_ = g_strdup (e_collection[e_it]);
			e = _tmp0_;
			{
				const gchar* _tmp1_;
				gchar* target = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gint tmp_score = 0;
				const gchar* _tmp4_;
				gboolean _tmp5_ = FALSE;
				_tmp1_ = e;
				if (_tmp1_ == NULL) {
					_g_free0 (e);
					continue;
				}
				_tmp2_ = e;
				_tmp3_ = budgie_relevancy_service_searchable_string (_tmp2_);
				target = _tmp3_;
				_tmp4_ = target;
				tmp_score = fuzzer_get_fuzzy_score (_tmp4_, term, 1);
				if (tmp_score >= 0) {
					gboolean _tmp6_ = FALSE;
					if (tmp_score < score) {
						_tmp6_ = TRUE;
					} else {
						_tmp6_ = score == -1;
					}
					_tmp5_ = _tmp6_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					score = tmp_score;
				}
				_g_free0 (target);
				_g_free0 (e);
			}
		}
	}
	result = score;
	return result;
}

static gboolean
budgie_relevancy_service_array_contains (BudgieRelevancyService* self,
                                         gchar** array,
                                         gint array_length1,
                                         const gchar* term)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (term != NULL, FALSE);
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = array;
		field_collection_length1 = array_length1;
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			gchar* _tmp0_;
			gchar* field = NULL;
			_tmp0_ = g_strdup (field_collection[field_it]);
			field = _tmp0_;
			{
				const gchar* _tmp1_;
				gchar* ct = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = field;
				if (_tmp1_ == NULL) {
					_g_free0 (field);
					continue;
				}
				_tmp2_ = field;
				_tmp3_ = budgie_relevancy_service_searchable_string (_tmp2_);
				ct = _tmp3_;
				_tmp4_ = ct;
				if (g_str_match_string (_tmp4_, term, TRUE)) {
					result = TRUE;
					_g_free0 (ct);
					_g_free0 (field);
					return result;
				}
				_g_free0 (ct);
				_g_free0 (field);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * Check if an application is the default handler for
 * any of its supported MIME types.
 */
static gboolean
budgie_relevancy_service_is_default_handler (BudgieRelevancyService* self,
                                             BudgieApplication* app)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (app != NULL, FALSE);
	_tmp0_ = budgie_application_get_content_types (app, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	{
		gchar** content_type_collection = NULL;
		gint content_type_collection_length1 = 0;
		gint _content_type_collection_size_ = 0;
		gint content_type_it = 0;
		content_type_collection = _tmp2_;
		content_type_collection_length1 = _tmp2__length1;
		for (content_type_it = 0; content_type_it < content_type_collection_length1; content_type_it = content_type_it + 1) {
			gchar* _tmp3_;
			gchar* content_type = NULL;
			_tmp3_ = g_strdup (content_type_collection[content_type_it]);
			content_type = _tmp3_;
			{
				GAppInfo* default_app = NULL;
				const gchar* _tmp4_;
				GAppInfo* _tmp5_;
				GAppInfo* _tmp6_;
				GAppInfo* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp4_ = content_type;
				_tmp5_ = g_app_info_get_default_for_type (_tmp4_, FALSE);
				default_app = _tmp5_;
				_tmp6_ = default_app;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (default_app);
					_g_free0 (content_type);
					continue;
				}
				_tmp7_ = default_app;
				_tmp8_ = g_app_info_get_id (_tmp7_);
				_tmp9_ = budgie_application_get_desktop_id (app);
				_tmp10_ = _tmp9_;
				if (g_strcmp0 (_tmp8_, _tmp10_) == 0) {
					result = TRUE;
					_g_object_unref0 (default_app);
					_g_free0 (content_type);
					return result;
				}
				_g_object_unref0 (default_app);
				_g_free0 (content_type);
			}
		}
	}
	result = FALSE;
	return result;
}

BudgieRelevancyService*
budgie_relevancy_service_construct (GType object_type)
{
	BudgieRelevancyService * self = NULL;
	self = (BudgieRelevancyService*) g_object_new (object_type, NULL);
	return self;
}

BudgieRelevancyService*
budgie_relevancy_service_new (void)
{
	return budgie_relevancy_service_construct (BUDGIE_TYPE_RELEVANCY_SERVICE);
}

static void
budgie_relevancy_service_class_init (BudgieRelevancyServiceClass * klass,
                                     gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	budgie_relevancy_service_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_relevancy_service_finalize;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (budgie_relevancy_service_scores);
	budgie_relevancy_service_scores = _tmp0_;
}

static void
budgie_relevancy_service_instance_init (BudgieRelevancyService * self,
                                        gpointer klass)
{
}

static void
budgie_relevancy_service_finalize (GObject * obj)
{
	BudgieRelevancyService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RELEVANCY_SERVICE, BudgieRelevancyService);
	G_OBJECT_CLASS (budgie_relevancy_service_parent_class)->finalize (obj);
}

/**
* This class keeps track of how relevant each application
* in the menu is with relation to a search term.
*/
static GType
budgie_relevancy_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRelevancyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_relevancy_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRelevancyService), 0, (GInstanceInitFunc) budgie_relevancy_service_instance_init, NULL };
	GType budgie_relevancy_service_type_id;
	budgie_relevancy_service_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieRelevancyService", &g_define_type_info, 0);
	return budgie_relevancy_service_type_id;
}

GType
budgie_relevancy_service_get_type (void)
{
	static volatile gsize budgie_relevancy_service_type_id__once = 0;
	if (g_once_init_enter (&budgie_relevancy_service_type_id__once)) {
		GType budgie_relevancy_service_type_id;
		budgie_relevancy_service_type_id = budgie_relevancy_service_get_type_once ();
		g_once_init_leave (&budgie_relevancy_service_type_id__once, budgie_relevancy_service_type_id);
	}
	return budgie_relevancy_service_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

