// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/policy/v1beta1/configuration.proto

//go:build !protoopaque

package policyv1beta1

import (
	v1 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/option/v1"
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PolicyConfig is the Policy's configuration. This consists of the lint, breaking, and plugin
// configurations required to run the Policy.
type PolicyConfig struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The lint config.
	Lint *PolicyConfig_LintConfig `protobuf:"bytes,1,opt,name=lint,proto3" json:"lint,omitempty"`
	// The breaking config.
	Breaking *PolicyConfig_BreakingConfig `protobuf:"bytes,2,opt,name=breaking,proto3" json:"breaking,omitempty"`
	// The check plugin configs.
	Plugins       []*PolicyConfig_CheckPluginConfig `protobuf:"bytes,3,rep,name=plugins,proto3" json:"plugins,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PolicyConfig) Reset() {
	*x = PolicyConfig{}
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig) ProtoMessage() {}

func (x *PolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyConfig) GetLint() *PolicyConfig_LintConfig {
	if x != nil {
		return x.Lint
	}
	return nil
}

func (x *PolicyConfig) GetBreaking() *PolicyConfig_BreakingConfig {
	if x != nil {
		return x.Breaking
	}
	return nil
}

func (x *PolicyConfig) GetPlugins() []*PolicyConfig_CheckPluginConfig {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *PolicyConfig) SetLint(v *PolicyConfig_LintConfig) {
	x.Lint = v
}

func (x *PolicyConfig) SetBreaking(v *PolicyConfig_BreakingConfig) {
	x.Breaking = v
}

func (x *PolicyConfig) SetPlugins(v []*PolicyConfig_CheckPluginConfig) {
	x.Plugins = v
}

func (x *PolicyConfig) HasLint() bool {
	if x == nil {
		return false
	}
	return x.Lint != nil
}

func (x *PolicyConfig) HasBreaking() bool {
	if x == nil {
		return false
	}
	return x.Breaking != nil
}

func (x *PolicyConfig) ClearLint() {
	x.Lint = nil
}

func (x *PolicyConfig) ClearBreaking() {
	x.Breaking = nil
}

type PolicyConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The lint config.
	Lint *PolicyConfig_LintConfig
	// The breaking config.
	Breaking *PolicyConfig_BreakingConfig
	// The check plugin configs.
	Plugins []*PolicyConfig_CheckPluginConfig
}

func (b0 PolicyConfig_builder) Build() *PolicyConfig {
	m0 := &PolicyConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.Lint = b.Lint
	x.Breaking = b.Breaking
	x.Plugins = b.Plugins
	return m0
}

// A lint config consists of the generic check config and additional lint-specifc configs
// required for running lint.
type PolicyConfig_LintConfig struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The list of check rules and/or categories used for the Policy.
	Use []string `protobuf:"bytes,1,rep,name=use,proto3" json:"use,omitempty"`
	// The list of check rules and/or categories to exclude for the Policy.
	Except []string `protobuf:"bytes,2,rep,name=except,proto3" json:"except,omitempty"`
	// The suffix that controls the behavior of the ENUM_ZERO_VALUE_SUFFIX lint rule. By default,
	// this rule verifies that the zero value of all enums ends in `_UNSPECIFIED`, however, this
	// allows organizations to choose a different suffix.
	EnumZeroValueSuffix string `protobuf:"bytes,3,opt,name=enum_zero_value_suffix,json=enumZeroValueSuffix,proto3" json:"enum_zero_value_suffix,omitempty"`
	// The bool allows the same message type to be used for a single RPC's request and response type.
	RpcAllowSameRequestResponse bool `protobuf:"varint,4,opt,name=rpc_allow_same_request_response,json=rpcAllowSameRequestResponse,proto3" json:"rpc_allow_same_request_response,omitempty"`
	// The bool allows RPC requests to be google.protobuf.Empty messages.
	RpcAllowGoogleProtobufEmptyRequests bool `protobuf:"varint,5,opt,name=rpc_allow_google_protobuf_empty_requests,json=rpcAllowGoogleProtobufEmptyRequests,proto3" json:"rpc_allow_google_protobuf_empty_requests,omitempty"`
	// The bool allows RPC responses to be google.protobuf.Empty messages.
	RpcAllowGoogleProtobufEmptyResponses bool `protobuf:"varint,6,opt,name=rpc_allow_google_protobuf_empty_responses,json=rpcAllowGoogleProtobufEmptyResponses,proto3" json:"rpc_allow_google_protobuf_empty_responses,omitempty"`
	// The suffix controls the behavior of the SERVICE_SUFFIX lint rule. By default, this rule
	// verifies that all service names are suffixed with `Service`, however this allows organizations
	// to choose a different suffix.
	ServiceSuffix string `protobuf:"bytes,7,opt,name=service_suffix,json=serviceSuffix,proto3" json:"service_suffix,omitempty"`
	// The bool disables the builtin rules and categories.
	DisableBuiltin bool `protobuf:"varint,8,opt,name=disable_builtin,json=disableBuiltin,proto3" json:"disable_builtin,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PolicyConfig_LintConfig) Reset() {
	*x = PolicyConfig_LintConfig{}
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyConfig_LintConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig_LintConfig) ProtoMessage() {}

func (x *PolicyConfig_LintConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyConfig_LintConfig) GetUse() []string {
	if x != nil {
		return x.Use
	}
	return nil
}

func (x *PolicyConfig_LintConfig) GetExcept() []string {
	if x != nil {
		return x.Except
	}
	return nil
}

func (x *PolicyConfig_LintConfig) GetEnumZeroValueSuffix() string {
	if x != nil {
		return x.EnumZeroValueSuffix
	}
	return ""
}

func (x *PolicyConfig_LintConfig) GetRpcAllowSameRequestResponse() bool {
	if x != nil {
		return x.RpcAllowSameRequestResponse
	}
	return false
}

func (x *PolicyConfig_LintConfig) GetRpcAllowGoogleProtobufEmptyRequests() bool {
	if x != nil {
		return x.RpcAllowGoogleProtobufEmptyRequests
	}
	return false
}

func (x *PolicyConfig_LintConfig) GetRpcAllowGoogleProtobufEmptyResponses() bool {
	if x != nil {
		return x.RpcAllowGoogleProtobufEmptyResponses
	}
	return false
}

func (x *PolicyConfig_LintConfig) GetServiceSuffix() string {
	if x != nil {
		return x.ServiceSuffix
	}
	return ""
}

func (x *PolicyConfig_LintConfig) GetDisableBuiltin() bool {
	if x != nil {
		return x.DisableBuiltin
	}
	return false
}

func (x *PolicyConfig_LintConfig) SetUse(v []string) {
	x.Use = v
}

func (x *PolicyConfig_LintConfig) SetExcept(v []string) {
	x.Except = v
}

func (x *PolicyConfig_LintConfig) SetEnumZeroValueSuffix(v string) {
	x.EnumZeroValueSuffix = v
}

func (x *PolicyConfig_LintConfig) SetRpcAllowSameRequestResponse(v bool) {
	x.RpcAllowSameRequestResponse = v
}

func (x *PolicyConfig_LintConfig) SetRpcAllowGoogleProtobufEmptyRequests(v bool) {
	x.RpcAllowGoogleProtobufEmptyRequests = v
}

func (x *PolicyConfig_LintConfig) SetRpcAllowGoogleProtobufEmptyResponses(v bool) {
	x.RpcAllowGoogleProtobufEmptyResponses = v
}

func (x *PolicyConfig_LintConfig) SetServiceSuffix(v string) {
	x.ServiceSuffix = v
}

func (x *PolicyConfig_LintConfig) SetDisableBuiltin(v bool) {
	x.DisableBuiltin = v
}

type PolicyConfig_LintConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of check rules and/or categories used for the Policy.
	Use []string
	// The list of check rules and/or categories to exclude for the Policy.
	Except []string
	// The suffix that controls the behavior of the ENUM_ZERO_VALUE_SUFFIX lint rule. By default,
	// this rule verifies that the zero value of all enums ends in `_UNSPECIFIED`, however, this
	// allows organizations to choose a different suffix.
	EnumZeroValueSuffix string
	// The bool allows the same message type to be used for a single RPC's request and response type.
	RpcAllowSameRequestResponse bool
	// The bool allows RPC requests to be google.protobuf.Empty messages.
	RpcAllowGoogleProtobufEmptyRequests bool
	// The bool allows RPC responses to be google.protobuf.Empty messages.
	RpcAllowGoogleProtobufEmptyResponses bool
	// The suffix controls the behavior of the SERVICE_SUFFIX lint rule. By default, this rule
	// verifies that all service names are suffixed with `Service`, however this allows organizations
	// to choose a different suffix.
	ServiceSuffix string
	// The bool disables the builtin rules and categories.
	DisableBuiltin bool
}

func (b0 PolicyConfig_LintConfig_builder) Build() *PolicyConfig_LintConfig {
	m0 := &PolicyConfig_LintConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.Use = b.Use
	x.Except = b.Except
	x.EnumZeroValueSuffix = b.EnumZeroValueSuffix
	x.RpcAllowSameRequestResponse = b.RpcAllowSameRequestResponse
	x.RpcAllowGoogleProtobufEmptyRequests = b.RpcAllowGoogleProtobufEmptyRequests
	x.RpcAllowGoogleProtobufEmptyResponses = b.RpcAllowGoogleProtobufEmptyResponses
	x.ServiceSuffix = b.ServiceSuffix
	x.DisableBuiltin = b.DisableBuiltin
	return m0
}

// A breaking config consists of the generic check config and additional breaking-specifc configs
// required for running breaking change detection.
type PolicyConfig_BreakingConfig struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The list of check rules and/or categories used for the Policy.
	Use []string `protobuf:"bytes,1,rep,name=use,proto3" json:"use,omitempty"`
	// The list of check rules and/or categories to exclude for the Policy.
	Except []string `protobuf:"bytes,2,rep,name=except,proto3" json:"except,omitempty"`
	// This bool determines whether to ignore unstable packages for breaking change detection:
	//   - v\d+test.*
	//   - v\d+(alpha|beta)\d*
	//   - v\d+p\d+(alpha|beta)\d*
	IgnoreUnstablePackages bool `protobuf:"varint,3,opt,name=ignore_unstable_packages,json=ignoreUnstablePackages,proto3" json:"ignore_unstable_packages,omitempty"`
	// The bool disables the builtin rules and categories.
	DisableBuiltin bool `protobuf:"varint,4,opt,name=disable_builtin,json=disableBuiltin,proto3" json:"disable_builtin,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PolicyConfig_BreakingConfig) Reset() {
	*x = PolicyConfig_BreakingConfig{}
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyConfig_BreakingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig_BreakingConfig) ProtoMessage() {}

func (x *PolicyConfig_BreakingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyConfig_BreakingConfig) GetUse() []string {
	if x != nil {
		return x.Use
	}
	return nil
}

func (x *PolicyConfig_BreakingConfig) GetExcept() []string {
	if x != nil {
		return x.Except
	}
	return nil
}

func (x *PolicyConfig_BreakingConfig) GetIgnoreUnstablePackages() bool {
	if x != nil {
		return x.IgnoreUnstablePackages
	}
	return false
}

func (x *PolicyConfig_BreakingConfig) GetDisableBuiltin() bool {
	if x != nil {
		return x.DisableBuiltin
	}
	return false
}

func (x *PolicyConfig_BreakingConfig) SetUse(v []string) {
	x.Use = v
}

func (x *PolicyConfig_BreakingConfig) SetExcept(v []string) {
	x.Except = v
}

func (x *PolicyConfig_BreakingConfig) SetIgnoreUnstablePackages(v bool) {
	x.IgnoreUnstablePackages = v
}

func (x *PolicyConfig_BreakingConfig) SetDisableBuiltin(v bool) {
	x.DisableBuiltin = v
}

type PolicyConfig_BreakingConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of check rules and/or categories used for the Policy.
	Use []string
	// The list of check rules and/or categories to exclude for the Policy.
	Except []string
	// This bool determines whether to ignore unstable packages for breaking change detection:
	//   - v\d+test.*
	//   - v\d+(alpha|beta)\d*
	//   - v\d+p\d+(alpha|beta)\d*
	IgnoreUnstablePackages bool
	// The bool disables the builtin rules and categories.
	DisableBuiltin bool
}

func (b0 PolicyConfig_BreakingConfig_builder) Build() *PolicyConfig_BreakingConfig {
	m0 := &PolicyConfig_BreakingConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.Use = b.Use
	x.Except = b.Except
	x.IgnoreUnstablePackages = b.IgnoreUnstablePackages
	x.DisableBuiltin = b.DisableBuiltin
	return m0
}

// A plugin config consists of the configs for invoking a check plugin.
type PolicyConfig_CheckPluginConfig struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugin name.
	Name *PolicyConfig_CheckPluginConfig_Name `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Options for the Plugin.
	Options []*v1.Option `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
	// The arguments to invoke the Plugin with.
	Args          []string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PolicyConfig_CheckPluginConfig) Reset() {
	*x = PolicyConfig_CheckPluginConfig{}
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyConfig_CheckPluginConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig_CheckPluginConfig) ProtoMessage() {}

func (x *PolicyConfig_CheckPluginConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyConfig_CheckPluginConfig) GetName() *PolicyConfig_CheckPluginConfig_Name {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *PolicyConfig_CheckPluginConfig) GetOptions() []*v1.Option {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *PolicyConfig_CheckPluginConfig) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *PolicyConfig_CheckPluginConfig) SetName(v *PolicyConfig_CheckPluginConfig_Name) {
	x.Name = v
}

func (x *PolicyConfig_CheckPluginConfig) SetOptions(v []*v1.Option) {
	x.Options = v
}

func (x *PolicyConfig_CheckPluginConfig) SetArgs(v []string) {
	x.Args = v
}

func (x *PolicyConfig_CheckPluginConfig) HasName() bool {
	if x == nil {
		return false
	}
	return x.Name != nil
}

func (x *PolicyConfig_CheckPluginConfig) ClearName() {
	x.Name = nil
}

type PolicyConfig_CheckPluginConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugin name.
	Name *PolicyConfig_CheckPluginConfig_Name
	// The Options for the Plugin.
	Options []*v1.Option
	// The arguments to invoke the Plugin with.
	Args []string
}

func (b0 PolicyConfig_CheckPluginConfig_builder) Build() *PolicyConfig_CheckPluginConfig {
	m0 := &PolicyConfig_CheckPluginConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.Name = b.Name
	x.Options = b.Options
	x.Args = b.Args
	return m0
}

// The fully-qualified name of a check Plugin within a BSR instance.
//
// If an untyped reference is specified it is interpreted to either be an Commit id or Label
// name. If no reference is set, then at the time of running the Policy, the latest commit on
// the default label of the Plugin is used.
type PolicyConfig_CheckPluginConfig_Name struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The name of the Organization owner.
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the Plugin.
	Plugin string `protobuf:"bytes,2,opt,name=plugin,proto3" json:"plugin,omitempty"`
	// The untyped reference, applying the semantics as documented on the Name message.
	//
	// If this value is present but empty, this should be treated as not present, that is an empty
	// value is the same as a null value.
	Ref           string `protobuf:"bytes,3,opt,name=ref,proto3" json:"ref,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PolicyConfig_CheckPluginConfig_Name) Reset() {
	*x = PolicyConfig_CheckPluginConfig_Name{}
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyConfig_CheckPluginConfig_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig_CheckPluginConfig_Name) ProtoMessage() {}

func (x *PolicyConfig_CheckPluginConfig_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_configuration_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyConfig_CheckPluginConfig_Name) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *PolicyConfig_CheckPluginConfig_Name) GetPlugin() string {
	if x != nil {
		return x.Plugin
	}
	return ""
}

func (x *PolicyConfig_CheckPluginConfig_Name) GetRef() string {
	if x != nil {
		return x.Ref
	}
	return ""
}

func (x *PolicyConfig_CheckPluginConfig_Name) SetOwner(v string) {
	x.Owner = v
}

func (x *PolicyConfig_CheckPluginConfig_Name) SetPlugin(v string) {
	x.Plugin = v
}

func (x *PolicyConfig_CheckPluginConfig_Name) SetRef(v string) {
	x.Ref = v
}

type PolicyConfig_CheckPluginConfig_Name_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the Organization owner.
	Owner string
	// The name of the Plugin.
	Plugin string
	// The untyped reference, applying the semantics as documented on the Name message.
	//
	// If this value is present but empty, this should be treated as not present, that is an empty
	// value is the same as a null value.
	Ref string
}

func (b0 PolicyConfig_CheckPluginConfig_Name_builder) Build() *PolicyConfig_CheckPluginConfig_Name {
	m0 := &PolicyConfig_CheckPluginConfig_Name{}
	b, x := &b0, m0
	_, _ = b, x
	x.Owner = b.Owner
	x.Plugin = b.Plugin
	x.Ref = b.Ref
	return m0
}

var File_buf_registry_policy_v1beta1_configuration_proto protoreflect.FileDescriptor

const file_buf_registry_policy_v1beta1_configuration_proto_rawDesc = "" +
	"\n" +
	"/buf/registry/policy/v1beta1/configuration.proto\x12\x1bbuf.registry.policy.v1beta1\x1a!buf/plugin/option/v1/option.proto\x1a\x1bbuf/validate/validate.proto\"\xec\n" +
	"\n" +
	"\fPolicyConfig\x12H\n" +
	"\x04lint\x18\x01 \x01(\v24.buf.registry.policy.v1beta1.PolicyConfig.LintConfigR\x04lint\x12T\n" +
	"\bbreaking\x18\x02 \x01(\v28.buf.registry.policy.v1beta1.PolicyConfig.BreakingConfigR\bbreaking\x12U\n" +
	"\aplugins\x18\x03 \x03(\v2;.buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfigR\aplugins\x1a\xa7\x04\n" +
	"\n" +
	"LintConfig\x12A\n" +
	"\x03use\x18\x01 \x03(\tB/\xbaH,\x92\x01)\x10\xfa\x01\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x03use\x12G\n" +
	"\x06except\x18\x02 \x03(\tB/\xbaH,\x92\x01)\x10\xfa\x01\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x06except\x12=\n" +
	"\x16enum_zero_value_suffix\x18\x03 \x01(\tB\b\xbaH\x05r\x03\x18\xfa\x01R\x13enumZeroValueSuffix\x12D\n" +
	"\x1frpc_allow_same_request_response\x18\x04 \x01(\bR\x1brpcAllowSameRequestResponse\x12U\n" +
	"(rpc_allow_google_protobuf_empty_requests\x18\x05 \x01(\bR#rpcAllowGoogleProtobufEmptyRequests\x12W\n" +
	")rpc_allow_google_protobuf_empty_responses\x18\x06 \x01(\bR$rpcAllowGoogleProtobufEmptyResponses\x12/\n" +
	"\x0eservice_suffix\x18\a \x01(\tB\b\xbaH\x05r\x03\x18\xfa\x01R\rserviceSuffix\x12'\n" +
	"\x0fdisable_builtin\x18\b \x01(\bR\x0edisableBuiltin\x1a\xff\x01\n" +
	"\x0eBreakingConfig\x12A\n" +
	"\x03use\x18\x01 \x03(\tB/\xbaH,\x92\x01)\x10\xfa\x01\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x03use\x12G\n" +
	"\x06except\x18\x02 \x03(\tB/\xbaH,\x92\x01)\x10\xfa\x01\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x06except\x128\n" +
	"\x18ignore_unstable_packages\x18\x03 \x01(\bR\x16ignoreUnstablePackages\x12'\n" +
	"\x0fdisable_builtin\x18\x04 \x01(\bR\x0edisableBuiltin\x1a\xb8\x02\n" +
	"\x11CheckPluginConfig\x12\\\n" +
	"\x04name\x18\x01 \x01(\v2@.buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig.NameB\x06\xbaH\x03\xc8\x01\x01R\x04name\x126\n" +
	"\aoptions\x18\x03 \x03(\v2\x1c.buf.plugin.option.v1.OptionR\aoptions\x12$\n" +
	"\x04args\x18\x04 \x03(\tB\x10\xbaH\r\x92\x01\n" +
	"\x10\xfa\x01\"\x05r\x03\x18\xfa\x01R\x04args\x1ag\n" +
	"\x04Name\x12 \n" +
	"\x05owner\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x18 R\x05owner\x12!\n" +
	"\x06plugin\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x06plugin\x12\x1a\n" +
	"\x03ref\x18\x03 \x01(\tB\b\xbaH\x05r\x03\x18\xfa\x01R\x03refBaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/policy/v1beta1;policyv1beta1b\x06proto3"

var file_buf_registry_policy_v1beta1_configuration_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_buf_registry_policy_v1beta1_configuration_proto_goTypes = []any{
	(*PolicyConfig)(nil),                        // 0: buf.registry.policy.v1beta1.PolicyConfig
	(*PolicyConfig_LintConfig)(nil),             // 1: buf.registry.policy.v1beta1.PolicyConfig.LintConfig
	(*PolicyConfig_BreakingConfig)(nil),         // 2: buf.registry.policy.v1beta1.PolicyConfig.BreakingConfig
	(*PolicyConfig_CheckPluginConfig)(nil),      // 3: buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig
	(*PolicyConfig_CheckPluginConfig_Name)(nil), // 4: buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig.Name
	(*v1.Option)(nil),                           // 5: buf.plugin.option.v1.Option
}
var file_buf_registry_policy_v1beta1_configuration_proto_depIdxs = []int32{
	1, // 0: buf.registry.policy.v1beta1.PolicyConfig.lint:type_name -> buf.registry.policy.v1beta1.PolicyConfig.LintConfig
	2, // 1: buf.registry.policy.v1beta1.PolicyConfig.breaking:type_name -> buf.registry.policy.v1beta1.PolicyConfig.BreakingConfig
	3, // 2: buf.registry.policy.v1beta1.PolicyConfig.plugins:type_name -> buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig
	4, // 3: buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig.name:type_name -> buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig.Name
	5, // 4: buf.registry.policy.v1beta1.PolicyConfig.CheckPluginConfig.options:type_name -> buf.plugin.option.v1.Option
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_registry_policy_v1beta1_configuration_proto_init() }
func file_buf_registry_policy_v1beta1_configuration_proto_init() {
	if File_buf_registry_policy_v1beta1_configuration_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_policy_v1beta1_configuration_proto_rawDesc), len(file_buf_registry_policy_v1beta1_configuration_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_policy_v1beta1_configuration_proto_goTypes,
		DependencyIndexes: file_buf_registry_policy_v1beta1_configuration_proto_depIdxs,
		MessageInfos:      file_buf_registry_policy_v1beta1_configuration_proto_msgTypes,
	}.Build()
	File_buf_registry_policy_v1beta1_configuration_proto = out.File
	file_buf_registry_policy_v1beta1_configuration_proto_goTypes = nil
	file_buf_registry_policy_v1beta1_configuration_proto_depIdxs = nil
}
