
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarksfoldersbutton_wrapper.h"

// Wrappers providing overrides
#include "toolbutton_wrapper.h"
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BookmarksFoldersButton_Type = nullptr;
static PyTypeObject *Sbk_BookmarksFoldersButton_TypeF(void)
{
    return _Sbk_BookmarksFoldersButton_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void BookmarksFoldersButtonWrapper::pysideInitQtMetaTypes()
{
}

void BookmarksFoldersButtonWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

BookmarksFoldersButtonWrapper::BookmarksFoldersButtonWrapper(::QWidget * parent, ::BookmarkItem * folder) : BookmarksFoldersButton(parent, folder)
{
}

void BookmarksFoldersButtonWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::changeEvent(e);
    }
    WebViewWrapper::sbk_o_changeEvent("BookmarksFoldersButton", funcName, gil, pyOverride, e);
}

void BookmarksFoldersButtonWrapper::checkStateSet()
{
    static const char *funcName = "checkStateSet";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::checkStateSet();
    }
    WebViewWrapper::sbk_o_closeView("BookmarksFoldersButton", funcName, gil, pyOverride);
}

void BookmarksFoldersButtonWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BookmarksFoldersButton", funcName, gil, pyOverride, signal);
}

void BookmarksFoldersButtonWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

int BookmarksFoldersButtonWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("BookmarksFoldersButton", funcName, gil, pyOverride);
}

void BookmarksFoldersButtonWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BookmarksFoldersButton", funcName, gil, pyOverride, signal);
}

void BookmarksFoldersButtonWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

bool BookmarksFoldersButtonWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::event(e);
    }
    return WebViewWrapper::sbk_o_event("BookmarksFoldersButton", funcName, gil, pyOverride, e);
}

bool BookmarksFoldersButtonWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("BookmarksFoldersButton", funcName, gil, pyOverride, watched, event);
}

void BookmarksFoldersButtonWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::focusInEvent(arg__1);
    }
    WebViewWrapper::sbk_o_focusInEvent("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

bool BookmarksFoldersButtonWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("BookmarksFoldersButton", funcName, gil, pyOverride, next);
}

void BookmarksFoldersButtonWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::focusOutEvent(arg__1);
    }
    WebViewWrapper::sbk_o_focusOutEvent("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

bool BookmarksFoldersButtonWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("BookmarksFoldersButton", funcName, gil, pyOverride);
}

int BookmarksFoldersButtonWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

void BookmarksFoldersButtonWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

bool BookmarksFoldersButtonWrapper::hitButton(const ::QPoint & pos) const
{
    static const char *funcName = "hitButton";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::hitButton(pos);
    }
    return ToolButtonWrapper::sbk_o_hitButton("BookmarksFoldersButton", funcName, gil, pyOverride, pos);
}

void BookmarksFoldersButtonWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("BookmarksFoldersButton", funcName, gil, pyOverride, painter);
}

void BookmarksFoldersButtonWrapper::initStyleOption(::QStyleOptionButton * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::initStyleOption(option);
    }
    sbk_o_initStyleOption("BookmarksFoldersButton", funcName, gil, pyOverride, option);
}

void BookmarksFoldersButtonWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionButton * option)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionButton_IDX]), option)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionButton_IDX]), option)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void BookmarksFoldersButtonWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

::QVariant BookmarksFoldersButtonWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

void BookmarksFoldersButtonWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::keyPressEvent(arg__1);
    }
    WebViewWrapper::sbk_o_keyPressEvent("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

void BookmarksFoldersButtonWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyReleaseEvent(e);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("BookmarksFoldersButton", funcName, gil, pyOverride, e);
}

void BookmarksFoldersButtonWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

int BookmarksFoldersButtonWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

::QSize BookmarksFoldersButtonWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("BookmarksFoldersButton", funcName, gil, pyOverride);
}

void BookmarksFoldersButtonWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::mouseMoveEvent(arg__1);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

void BookmarksFoldersButtonWrapper::mousePressEvent(::QMouseEvent * e)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mousePressEvent(e);
    }
    WebViewWrapper::sbk_o_mousePressEvent("BookmarksFoldersButton", funcName, gil, pyOverride, e);
}

void BookmarksFoldersButtonWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mouseReleaseEvent(e);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("BookmarksFoldersButton", funcName, gil, pyOverride, e);
}

void BookmarksFoldersButtonWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

bool BookmarksFoldersButtonWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("BookmarksFoldersButton", funcName, gil, pyOverride, eventType, message, result);
}

void BookmarksFoldersButtonWrapper::nextCheckState()
{
    static const char *funcName = "nextCheckState";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::nextCheckState();
    }
    WebViewWrapper::sbk_o_closeView("BookmarksFoldersButton", funcName, gil, pyOverride);
}

::QPaintEngine * BookmarksFoldersButtonWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("BookmarksFoldersButton", funcName, gil, pyOverride);
}

void BookmarksFoldersButtonWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::paintEvent(arg__1);
    }
    WebViewWrapper::sbk_o_paintEvent("BookmarksFoldersButton", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * BookmarksFoldersButtonWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("BookmarksFoldersButton", funcName, gil, pyOverride, offset);
}

void BookmarksFoldersButtonWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("BookmarksFoldersButton", funcName, gil, pyOverride, visible);
}

::QPainter * BookmarksFoldersButtonWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("BookmarksFoldersButton", funcName, gil, pyOverride);
}

void BookmarksFoldersButtonWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

::QSize BookmarksFoldersButtonWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("BookmarksFoldersButton", funcName, gil, pyOverride);
}

void BookmarksFoldersButtonWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

void BookmarksFoldersButtonWrapper::timerEvent(::QTimerEvent * e)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::timerEvent(e);
    }
    WebViewWrapper::sbk_o_timerEvent("BookmarksFoldersButton", funcName, gil, pyOverride, e);
}

void BookmarksFoldersButtonWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarksFoldersButton_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("BookmarksFoldersButton", funcName, gil, pyOverride, event);
}

const QMetaObject *BookmarksFoldersButtonWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return BookmarksFoldersButton::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int BookmarksFoldersButtonWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = BookmarksFoldersButton::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *BookmarksFoldersButtonWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< BookmarksFoldersButtonWrapper *>(this));
    }
    return BookmarksFoldersButton::qt_metacast(_clname);
}

BookmarksFoldersButtonWrapper::~BookmarksFoldersButtonWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_BookmarksFoldersButton_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BookmarksFoldersButton_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BookmarksFoldersButton >()))
        return -1;

    BookmarksFoldersButtonWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:BookmarksFoldersButton", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: BookmarksFoldersButton::BookmarksFoldersButton(QWidget*,BookmarkItem*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // BookmarksFoldersButton(QWidget*,BookmarkItem*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
            overloadId = 0; // BookmarksFoldersButton(QWidget*,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"folder", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::BookmarkItem *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // BookmarksFoldersButton(QWidget*,BookmarkItem*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) BookmarksFoldersButtonWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new BookmarksFoldersButtonWrapper(cppArg0, cppArg1);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< BookmarksFoldersButton >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);
    };


    return 1;
}

static PyObject *Sbk_BookmarksFoldersButtonFunc_selectedFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksFoldersButtonWrapper *>(reinterpret_cast< ::BookmarksFoldersButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectedFolder()const
        BookmarkItem * cppResult = const_cast<const BookmarksFoldersButtonWrapper *>(cppSelf)->selectedFolder();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFoldersButtonFunc_setSelectedFolder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksFoldersButtonWrapper *>(reinterpret_cast< ::BookmarksFoldersButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarksFoldersButton::setSelectedFolder(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // setSelectedFolder(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectedFolder", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectedFolder(BookmarkItem*)
            cppSelf->setSelectedFolder(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_BookmarksFoldersButton_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BookmarksFoldersButton_methods[] = {
    {"selectedFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFoldersButtonFunc_selectedFolder), METH_NOARGS, nullptr},
    {"setSelectedFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFoldersButtonFunc_setSelectedFolder), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_BookmarksFoldersButton_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::BookmarksFoldersButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<BookmarksFoldersButtonWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_BookmarksFoldersButton_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BookmarksFoldersButton_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_BookmarksFoldersButtonSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::BookmarksFoldersButton *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]))
        return static_cast< ::QPushButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractButton_IDX]))
        return static_cast< ::QAbstractButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BookmarksFoldersButton_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_BookmarksFoldersButton_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BookmarksFoldersButton_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BookmarksFoldersButton_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BookmarksFoldersButton_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BookmarksFoldersButton_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BookmarksFoldersButton_spec = {
    "1:PyFalkon.BookmarksFoldersButton",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BookmarksFoldersButton_slots
};

} //extern "C"

static void *Sbk_BookmarksFoldersButton_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::BookmarksFoldersButton *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::BookmarksFoldersButton *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::BookmarksFoldersButton *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BookmarksFoldersButton_PythonToCpp_BookmarksFoldersButton_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BookmarksFoldersButton_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BookmarksFoldersButton_PythonToCpp_BookmarksFoldersButton_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BookmarksFoldersButton_TypeF()))
        return BookmarksFoldersButton_PythonToCpp_BookmarksFoldersButton_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BookmarksFoldersButton_PTR_CppToPython_BookmarksFoldersButton(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::BookmarksFoldersButton *>(const_cast<void *>(cppIn)), Sbk_BookmarksFoldersButton_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BookmarksFoldersButton_SignatureStrings[] = {
    "PyFalkon.BookmarksFoldersButton(self,parent:PySide6.QtWidgets.QWidget,folder:PyFalkon.BookmarkItem=nullptr)",
    "PyFalkon.BookmarksFoldersButton.selectedFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.BookmarksFoldersButton.setSelectedFolder(self,folder:PyFalkon.BookmarkItem)",
    nullptr}; // Sentinel
#else
static constexpr size_t BookmarksFoldersButton_SignatureByteSize = 127;
static constexpr uint8_t BookmarksFoldersButton_SignatureBytes[127] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x73, 0xca, 0xcf, 0xcf, 0xce,
    0x4d, 0x2c, 0xca, 0x2e, 0x76, 0xcb, 0xcf, 0x49, 0x49, 0x2d, 0x2a, 0x76, 0x2a, 0x2d, 0x29, 0xc9,
    0xcf, 0xd3, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x48, 0x2c, 0x4a, 0xcd, 0x2b, 0xb1, 0x0a, 0xa8,
    0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x09, 0xcf, 0x4c, 0x49, 0x4f, 0x2d, 0x29, 0xd6,
    0x0b, 0x84, 0x30, 0x74, 0xd2, 0xc0, 0x7a, 0x80, 0x0a, 0xd0, 0x0c, 0xf3, 0x2c, 0x49, 0xcd, 0xb5,
    0xcd, 0x2b, 0xcd, 0xc9, 0x29, 0x28, 0x29, 0xd2, 0xe4, 0x0a, 0xc0, 0x6f, 0x97, 0x1e, 0xd0, 0xae,
    0xd4, 0xe4, 0x92, 0xd4, 0x14, 0x88, 0x28, 0xd8, 0x6a, 0x4d, 0x5d, 0x3b, 0xac, 0x86, 0x12, 0x61,
    0x56, 0x49, 0x30, 0xa6, 0x71, 0x78, 0x1d, 0xaa, 0xc9, 0x05, 0x00, 0xc7, 0x56, 0x65, 0x97
};
#endif

PyTypeObject *init_BookmarksFoldersButton(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX].type;

    Shiboken::AutoDecRef Sbk_BookmarksFoldersButton_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]))));

    _Sbk_BookmarksFoldersButton_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BookmarksFoldersButton",
        "BookmarksFoldersButton*",
        &Sbk_BookmarksFoldersButton_spec,
        &Shiboken::callCppDestructor< BookmarksFoldersButton >,
        Sbk_BookmarksFoldersButton_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_BookmarksFoldersButton_TypeF(); // references _Sbk_BookmarksFoldersButton_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BookmarksFoldersButton_SignatureStrings);
#else
    InitSignatureBytes(pyType, BookmarksFoldersButton_SignatureBytes, BookmarksFoldersButton_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BookmarksFoldersButton_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_BookmarksFoldersButton_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BookmarksFoldersButton_PythonToCpp_BookmarksFoldersButton_PTR,
        is_BookmarksFoldersButton_PythonToCpp_BookmarksFoldersButton_PTR_Convertible,
        BookmarksFoldersButton_PTR_CppToPython_BookmarksFoldersButton);

    Shiboken::Conversions::registerConverterName(converter, "BookmarksFoldersButton");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksFoldersButton*");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksFoldersButton&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarksFoldersButton).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(BookmarksFoldersButtonWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_BookmarksFoldersButton_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_BookmarksFoldersButton_TypeF(), &Sbk_BookmarksFoldersButtonSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_BookmarksFoldersButton_TypeF(), &Sbk_BookmarksFoldersButton_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::BookmarksFoldersButton::staticMetaObject);
    BookmarksFoldersButtonWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::BookmarksFoldersButton::staticMetaObject, sizeof(BookmarksFoldersButtonWrapper));

    return pyType;
}
