/* util-files.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-files.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

gchar*
files_get_filesize_as_string (gint64 filesize)
{
	gint64 scale = 0LL;
	gchar* units = NULL;
	gchar* _tmp0_;
	gchar* result;
	scale = (gint64) 1;
	_tmp0_ = g_strdup (_ ("bytes"));
	units = _tmp0_;
	if (filesize > FILES_TERABYTE) {
		gchar* _tmp1_;
		scale = FILES_TERABYTE;
		_tmp1_ = g_strdup (C_ ("Abbreviation for terabyte", "TB"));
		_g_free0 (units);
		units = _tmp1_;
	} else {
		if (filesize > FILES_GIGABYTE) {
			gchar* _tmp2_;
			scale = FILES_GIGABYTE;
			_tmp2_ = g_strdup (C_ ("Abbreviation for gigabyte", "GB"));
			_g_free0 (units);
			units = _tmp2_;
		} else {
			if (filesize > FILES_MEGABYTE) {
				gchar* _tmp3_;
				scale = FILES_MEGABYTE;
				_tmp3_ = g_strdup (C_ ("Abbreviation for megabyte", "MB"));
				_g_free0 (units);
				units = _tmp3_;
			} else {
				if (filesize > FILES_KILOBYTE) {
					gchar* _tmp4_;
					scale = FILES_KILOBYTE;
					_tmp4_ = g_strdup (C_ ("Abbreviation for kilobyte", "KB"));
					_g_free0 (units);
					units = _tmp4_;
				}
			}
		}
	}
	if (scale == ((gint64) 1)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, filesize);
		_tmp6_ = _tmp5_;
		_tmp7_ = units;
		_tmp8_ = g_strdup_printf ("%s %s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		_g_free0 (units);
		return result;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = units;
		_tmp11_ = g_strdup_printf ("%.2f %s", (gdouble) (((gfloat) filesize) / ((gfloat) scale)), _tmp10_);
		result = _tmp11_;
		_g_free0 (units);
		return result;
	}
}

