/* gitg-font-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-font-manager.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2019 - Alberto Fanjul
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <pango/pango.h>
#include <dazzle.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_FONT_MANAGER_0_PROPERTY,
	GITG_FONT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gitg_font_manager_properties[GITG_FONT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

struct _GitgFontManagerPrivate {
	GSettings* d_font_settings;
	GSettings* d_global_settings;
	GtkCssProvider* css_provider;
};

static gint GitgFontManager_private_offset;
static gpointer gitg_font_manager_parent_class = NULL;

static GSettings* gitg_font_manager_try_settings (GitgFontManager* self,
                                           const gchar* schema_id);
static void ___lambda54_ (GitgFontManager* self,
                   GSettings* s,
                   const gchar* k);
static void gitg_font_manager_update_font_settings (GitgFontManager* self);
static void ____lambda54__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void ___lambda55_ (GitgFontManager* self,
                   GSettings* s,
                   const gchar* k);
static void ____lambda55__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void ___lambda56_ (GitgFontManager* self,
                   GSettings* s,
                   const gchar* k);
static void ____lambda56__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void gitg_font_manager_finalize (GObject * obj);
static GType gitg_font_manager_get_type_once (void);

static inline gpointer
gitg_font_manager_get_instance_private (GitgFontManager* self)
{
	return G_STRUCT_MEMBER_P (self, GitgFontManager_private_offset);
}

static void
___lambda54_ (GitgFontManager* self,
              GSettings* s,
              const gchar* k)
{
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	gitg_font_manager_update_font_settings (self);
}

static void
____lambda54__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda54_ ((GitgFontManager*) self, _sender, key);
}

static void
___lambda55_ (GitgFontManager* self,
              GSettings* s,
              const gchar* k)
{
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	gitg_font_manager_update_font_settings (self);
}

static void
____lambda55__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda55_ ((GitgFontManager*) self, _sender, key);
}

static void
___lambda56_ (GitgFontManager* self,
              GSettings* s,
              const gchar* k)
{
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	gitg_font_manager_update_font_settings (self);
}

static void
____lambda56__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda56_ ((GitgFontManager*) self, _sender, key);
}

GitgFontManager*
gitg_font_manager_construct (GType object_type,
                             GtkTextView* text_view,
                             gboolean plugin)
{
	GitgFontManager * self = NULL;
	GtkCssProvider* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp8_;
	GtkStyleContext* _tmp10_;
	GtkCssProvider* _tmp11_;
	g_return_val_if_fail (text_view != NULL, NULL);
	self = (GitgFontManager*) g_object_new (object_type, NULL);
	if (plugin) {
		GSettings* _tmp0_;
		GSettings* _tmp1_;
		_tmp0_ = gitg_font_manager_try_settings (self, APPLICATION_ID ".preferences.interface");
		_g_object_unref0 (self->priv->d_font_settings);
		self->priv->d_font_settings = _tmp0_;
		_tmp1_ = gitg_font_manager_try_settings (self, "org.gnome.desktop.interface");
		_g_object_unref0 (self->priv->d_global_settings);
		self->priv->d_global_settings = _tmp1_;
	} else {
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		_tmp2_ = g_settings_new (APPLICATION_ID ".preferences.interface");
		_g_object_unref0 (self->priv->d_font_settings);
		self->priv->d_font_settings = _tmp2_;
		_tmp3_ = g_settings_new ("org.gnome.desktop.interface");
		_g_object_unref0 (self->priv->d_global_settings);
		self->priv->d_global_settings = _tmp3_;
	}
	_tmp4_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp4_;
	_tmp5_ = self->priv->d_font_settings;
	if (_tmp5_ != NULL) {
		GSettings* _tmp6_;
		GSettings* _tmp7_;
		_tmp6_ = self->priv->d_font_settings;
		g_signal_connect_object (_tmp6_, "changed::use-default-font", (GCallback) ____lambda54__g_settings_changed, self, 0);
		_tmp7_ = self->priv->d_font_settings;
		g_signal_connect_object (_tmp7_, "changed::monospace-font-name", (GCallback) ____lambda55__g_settings_changed, self, 0);
	}
	_tmp8_ = self->priv->d_global_settings;
	if (_tmp8_ != NULL) {
		GSettings* _tmp9_;
		_tmp9_ = self->priv->d_global_settings;
		g_signal_connect_object (_tmp9_, "changed::monospace-font-name", (GCallback) ____lambda56__g_settings_changed, self, 0);
	}
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) text_view);
	_tmp11_ = self->priv->css_provider;
	gtk_style_context_add_provider (_tmp10_, (GtkStyleProvider*) _tmp11_, (guint) GTK_STYLE_PROVIDER_PRIORITY_SETTINGS);
	gitg_font_manager_update_font_settings (self);
	return self;
}

GitgFontManager*
gitg_font_manager_new (GtkTextView* text_view,
                       gboolean plugin)
{
	return gitg_font_manager_construct (GITG_TYPE_FONT_MANAGER, text_view, plugin);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static GSettings*
gitg_font_manager_try_settings (GitgFontManager* self,
                                const gchar* schema_id)
{
	GSettingsSchemaSource* source = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSettingsSchema* _tmp4_;
	GSettingsSchema* _tmp5_;
	gboolean _tmp6_;
	GSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (schema_id != NULL, NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	source = _tmp1_;
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_settings_schema_source_unref0 (source);
		return result;
	}
	_tmp3_ = source;
	_tmp4_ = g_settings_schema_source_lookup (_tmp3_, schema_id, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_settings_schema_unref0 (_tmp5_);
	if (_tmp6_) {
		GSettings* _tmp7_;
		_tmp7_ = g_settings_new (schema_id);
		result = _tmp7_;
		_g_settings_schema_source_unref0 (source);
		return result;
	}
	result = NULL;
	_g_settings_schema_source_unref0 (source);
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
gitg_font_manager_update_font_settings (GitgFontManager* self)
{
	gchar* fname = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_;
	PangoFontDescription* font_desc = NULL;
	const gchar* _tmp7_;
	PangoFontDescription* _tmp8_;
	gchar* css = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_font_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "monospace-font-name");
	fname = _tmp1_;
	_tmp3_ = self->priv->d_font_settings;
	if (g_settings_get_boolean (_tmp3_, "use-default-font")) {
		GSettings* _tmp4_;
		_tmp4_ = self->priv->d_global_settings;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GSettings* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->d_global_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "monospace-font-name");
		_g_free0 (fname);
		fname = _tmp6_;
	}
	_tmp7_ = fname;
	_tmp8_ = pango_font_description_from_string (_tmp7_);
	font_desc = _tmp8_;
	_tmp9_ = dzl_pango_font_description_to_css (font_desc);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("textview { %s }", _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	css = _tmp12_;
	{
		GtkCssProvider* _tmp13_;
		_tmp13_ = self->priv->css_provider;
		gtk_css_provider_load_from_data (_tmp13_, css, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("gitg-font-manager.vala:87: Error applying font: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (css);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (fname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (css);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_free0 (fname);
}

static void
gitg_font_manager_class_init (GitgFontManagerClass * klass,
                              gpointer klass_data)
{
	gitg_font_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgFontManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gitg_font_manager_finalize;
}

static void
gitg_font_manager_instance_init (GitgFontManager * self,
                                 gpointer klass)
{
	self->priv = gitg_font_manager_get_instance_private (self);
}

static void
gitg_font_manager_finalize (GObject * obj)
{
	GitgFontManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_FONT_MANAGER, GitgFontManager);
	_g_object_unref0 (self->priv->d_font_settings);
	_g_object_unref0 (self->priv->d_global_settings);
	_g_object_unref0 (self->priv->css_provider);
	G_OBJECT_CLASS (gitg_font_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_font_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgFontManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_font_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgFontManager), 0, (GInstanceInitFunc) gitg_font_manager_instance_init, NULL };
	GType gitg_font_manager_type_id;
	gitg_font_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgFontManager", &g_define_type_info, 0);
	GitgFontManager_private_offset = g_type_add_instance_private (gitg_font_manager_type_id, sizeof (GitgFontManagerPrivate));
	return gitg_font_manager_type_id;
}

GType
gitg_font_manager_get_type (void)
{
	static gsize gitg_font_manager_type_id__once = 0;
	if (g_once_init_enter (&gitg_font_manager_type_id__once)) {
		GType gitg_font_manager_type_id;
		gitg_font_manager_type_id = gitg_font_manager_get_type_once ();
		g_once_init_leave (&gitg_font_manager_type_id__once, gitg_font_manager_type_id);
	}
	return gitg_font_manager_type_id__once;
}

