/* gitg-ref.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ref.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_PARSED_REF_NAME_0_PROPERTY,
	GITG_PARSED_REF_NAME_RTYPE_PROPERTY,
	GITG_PARSED_REF_NAME_NAME_PROPERTY,
	GITG_PARSED_REF_NAME_SHORTNAME_PROPERTY,
	GITG_PARSED_REF_NAME_REMOTE_NAME_PROPERTY,
	GITG_PARSED_REF_NAME_REMOTE_BRANCH_PROPERTY,
	GITG_PARSED_REF_NAME_PREFIX_PROPERTY,
	GITG_PARSED_REF_NAME_NUM_PROPERTIES
};
static GParamSpec* gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block21Data Block21Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _GitgParsedRefNamePrivate {
	gchar* d_shortname;
	gchar* d_name;
	gchar* d_remote_name;
	gchar* d_remote_branch;
	gchar* d_prefix;
	GitgRefType _rtype;
};

struct _Block21Data {
	int _ref_count_;
	GitgRef* self;
	GRegex* valregex;
};

static gint GitgParsedRefName_private_offset;
static gpointer gitg_parsed_ref_name_parent_class = NULL;
static GRegex* gitg_ref_s_remote_key_regex;
static GRegex* gitg_ref_s_remote_key_regex = NULL;

static void gitg_parsed_ref_name_parse_name (GitgParsedRefName* self,
                                      const gchar* name);
static void gitg_parsed_ref_name_set_rtype (GitgParsedRefName* self,
                                     GitgRefType value);
static void gitg_parsed_ref_name_finalize (GObject * obj);
static GType gitg_parsed_ref_name_get_type_once (void);
static void _vala_gitg_parsed_ref_name_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gitg_parsed_ref_name_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void gitg_ref_add_push_ref (GitgRef* self,
                            const gchar* spec);
static gint __lambda31_ (GitgRef* a,
                  GitgRef* b);
static gint ___lambda31__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void gitg_ref_add_branch_configured_push (GitgRef* self,
                                          GgitConfig* cfg);
static void gitg_ref_add_remote_configured_push (GitgRef* self,
                                          GgitConfig* cfg);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gint ___lambda32_ (Block21Data* _data21_,
                   GMatchInfo* info,
                   const gchar* val);
static gint ____lambda32__ggit_config_match_callback (GMatchInfo* match_info,
                                               const gchar* value,
                                               gpointer self);
static void gitg_ref_add_branch_same_name_push (GitgRef* self,
                                         GgitConfig* cfg);
static void gitg_ref_compose_pushes (GitgRef* self);
static GType gitg_ref_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

 G_GNUC_NO_INLINE static GType
gitg_ref_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_REF_TYPE_NONE, "GITG_REF_TYPE_NONE", "none"}, {GITG_REF_TYPE_BRANCH, "GITG_REF_TYPE_BRANCH", "branch"}, {GITG_REF_TYPE_REMOTE, "GITG_REF_TYPE_REMOTE", "remote"}, {GITG_REF_TYPE_TAG, "GITG_REF_TYPE_TAG", "tag"}, {GITG_REF_TYPE_STASH, "GITG_REF_TYPE_STASH", "stash"}, {0, NULL, NULL}};
	GType gitg_ref_type_type_id;
	gitg_ref_type_type_id = g_enum_register_static ("GitgRefType", values);
	return gitg_ref_type_type_id;
}

GType
gitg_ref_type_get_type (void)
{
	static gsize gitg_ref_type_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_type_type_id__once)) {
		GType gitg_ref_type_type_id;
		gitg_ref_type_type_id = gitg_ref_type_get_type_once ();
		g_once_init_leave (&gitg_ref_type_type_id__once, gitg_ref_type_type_id);
	}
	return gitg_ref_type_type_id__once;
}

 G_GNUC_NO_INLINE static GType
gitg_ref_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_REF_STATE_NONE, "GITG_REF_STATE_NONE", "none"}, {GITG_REF_STATE_SELECTED, "GITG_REF_STATE_SELECTED", "selected"}, {GITG_REF_STATE_PRELIGHT, "GITG_REF_STATE_PRELIGHT", "prelight"}, {0, NULL, NULL}};
	GType gitg_ref_state_type_id;
	gitg_ref_state_type_id = g_enum_register_static ("GitgRefState", values);
	return gitg_ref_state_type_id;
}

GType
gitg_ref_state_get_type (void)
{
	static gsize gitg_ref_state_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_state_type_id__once)) {
		GType gitg_ref_state_type_id;
		gitg_ref_state_type_id = gitg_ref_state_get_type_once ();
		g_once_init_leave (&gitg_ref_state_type_id__once, gitg_ref_state_type_id);
	}
	return gitg_ref_state_type_id__once;
}

static inline gpointer
gitg_parsed_ref_name_get_instance_private (GitgParsedRefName* self)
{
	return G_STRUCT_MEMBER_P (self, GitgParsedRefName_private_offset);
}

GitgParsedRefName*
gitg_parsed_ref_name_construct (GType object_type,
                                const gchar* name)
{
	GitgParsedRefName * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GitgParsedRefName*) g_object_new (object_type, NULL);
	gitg_parsed_ref_name_parse_name (self, name);
	return self;
}

GitgParsedRefName*
gitg_parsed_ref_name_new (const gchar* name)
{
	return gitg_parsed_ref_name_construct (GITG_TYPE_PARSED_REF_NAME, name);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
gitg_parsed_ref_name_parse_name (GitgParsedRefName* self,
                                 const gchar* name)
{
	gchar* _tmp0_;
	gchar** prefixes = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint prefixes_length1;
	gint _prefixes_size_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->d_name);
	self->priv->d_name = _tmp0_;
	_tmp1_ = g_strdup ("refs/heads/");
	_tmp2_ = g_strdup ("refs/remotes/");
	_tmp3_ = g_strdup ("refs/tags/");
	_tmp4_ = g_strdup ("refs/stash");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	prefixes = _tmp5_;
	prefixes_length1 = 4;
	_prefixes_size_ = prefixes_length1;
	_tmp6_ = g_strdup (name);
	_g_free0 (self->priv->d_shortname);
	self->priv->d_shortname = _tmp6_;
	_g_free0 (self->priv->d_prefix);
	self->priv->d_prefix = NULL;
	_tmp7_ = self->priv->d_name;
	if (g_strcmp0 (_tmp7_, "HEAD") == 0) {
		gitg_parsed_ref_name_set_rtype (self, GITG_REF_TYPE_BRANCH);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				GitgRefType _tmp17_;
				GitgRefType _tmp28_;
				if (!_tmp8_) {
					gint _tmp9_;
					i = i + 1;
					_tmp9_ = i;
				}
				_tmp8_ = FALSE;
				_tmp10_ = prefixes;
				_tmp10__length1 = prefixes_length1;
				if (!(i < _tmp10__length1)) {
					break;
				}
				_tmp11_ = self->priv->d_name;
				_tmp12_ = prefixes;
				_tmp12__length1 = prefixes_length1;
				_tmp13_ = _tmp12_[i];
				if (!g_str_has_prefix (_tmp11_, _tmp13_)) {
					continue;
				}
				_tmp14_ = prefixes;
				_tmp14__length1 = prefixes_length1;
				_tmp15_ = _tmp14_[i];
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (self->priv->d_prefix);
				self->priv->d_prefix = _tmp16_;
				gitg_parsed_ref_name_set_rtype (self, (GitgRefType) (i + 1));
				_tmp17_ = self->priv->_rtype;
				if (_tmp17_ == GITG_REF_TYPE_STASH) {
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = g_strdup ("refs/");
					_g_free0 (self->priv->d_prefix);
					self->priv->d_prefix = _tmp18_;
					_tmp19_ = g_strdup ("stash");
					_g_free0 (self->priv->d_shortname);
					self->priv->d_shortname = _tmp19_;
				} else {
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gchar* _tmp27_;
					_tmp20_ = self->priv->d_name;
					_tmp21_ = self->priv->d_prefix;
					_tmp22_ = strlen (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = self->priv->d_name;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = string_slice (_tmp20_, (glong) _tmp23_, (glong) _tmp26_);
					_g_free0 (self->priv->d_shortname);
					self->priv->d_shortname = _tmp27_;
				}
				_tmp28_ = self->priv->_rtype;
				if (_tmp28_ == GITG_REF_TYPE_REMOTE) {
					gint pos = 0;
					const gchar* _tmp29_;
					_tmp29_ = self->priv->d_shortname;
					pos = string_index_of_char (_tmp29_, (gunichar) '/', 0);
					if (pos != -1) {
						const gchar* _tmp30_;
						gchar* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp30_ = self->priv->d_shortname;
						_tmp31_ = string_substring (_tmp30_, (glong) 0, (glong) pos);
						_g_free0 (self->priv->d_remote_name);
						self->priv->d_remote_name = _tmp31_;
						_tmp32_ = self->priv->d_shortname;
						_tmp33_ = string_substring (_tmp32_, (glong) (pos + 1), (glong) -1);
						_g_free0 (self->priv->d_remote_branch);
						self->priv->d_remote_branch = _tmp33_;
					} else {
						const gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp34_ = self->priv->d_shortname;
						_tmp35_ = g_strdup (_tmp34_);
						_g_free0 (self->priv->d_remote_name);
						self->priv->d_remote_name = _tmp35_;
					}
				}
			}
		}
	}
	prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
}

GitgRefType
gitg_parsed_ref_name_get_rtype (GitgParsedRefName* self)
{
	GitgRefType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rtype;
	return result;
}

static void
gitg_parsed_ref_name_set_rtype (GitgParsedRefName* self,
                                GitgRefType value)
{
	GitgRefType old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_parsed_ref_name_get_rtype (self);
	if (old_value != value) {
		self->priv->_rtype = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_RTYPE_PROPERTY]);
	}
}

gchar*
gitg_parsed_ref_name_get_name (GitgParsedRefName* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_shortname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
gitg_parsed_ref_name_get_remote_name (GitgParsedRefName* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_remote_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
gitg_parsed_ref_name_get_remote_branch (GitgParsedRefName* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_remote_branch;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

const gchar*
gitg_parsed_ref_name_get_prefix (GitgParsedRefName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_prefix;
	result = _tmp0_;
	return result;
}

static void
gitg_parsed_ref_name_class_init (GitgParsedRefNameClass * klass,
                                 gpointer klass_data)
{
	gitg_parsed_ref_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgParsedRefName_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_parsed_ref_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_parsed_ref_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_parsed_ref_name_finalize;
	/**
	 * The type of ref.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_RTYPE_PROPERTY, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_RTYPE_PROPERTY] = g_param_spec_enum ("rtype", "rtype", "rtype", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The full name of the ref.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_NAME_PROPERTY, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The short name of the ref. This represents the name of the ref
	 * without the information of the type of ref.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_SHORTNAME_PROPERTY, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_SHORTNAME_PROPERTY] = g_param_spec_string ("shortname", "shortname", "shortname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The remote name of the ref (only for remote refs)
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_REMOTE_NAME_PROPERTY, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_REMOTE_NAME_PROPERTY] = g_param_spec_string ("remote-name", "remote-name", "remote-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The remote branch name of the ref (only for remote refs)
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_REMOTE_BRANCH_PROPERTY, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_REMOTE_BRANCH_PROPERTY] = g_param_spec_string ("remote-branch", "remote-branch", "remote-branch", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_PREFIX_PROPERTY, gitg_parsed_ref_name_properties[GITG_PARSED_REF_NAME_PREFIX_PROPERTY] = g_param_spec_string ("prefix", "prefix", "prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_parsed_ref_name_instance_init (GitgParsedRefName * self,
                                    gpointer klass)
{
	self->priv = gitg_parsed_ref_name_get_instance_private (self);
}

static void
gitg_parsed_ref_name_finalize (GObject * obj)
{
	GitgParsedRefName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName);
	_g_free0 (self->priv->d_shortname);
	_g_free0 (self->priv->d_name);
	_g_free0 (self->priv->d_remote_name);
	_g_free0 (self->priv->d_remote_branch);
	_g_free0 (self->priv->d_prefix);
	G_OBJECT_CLASS (gitg_parsed_ref_name_parent_class)->finalize (obj);
}

/**
 * Parse ref name into components.
 *
 * This class parses a refname and splits it into several components.
 *
 */
 G_GNUC_NO_INLINE static GType
gitg_parsed_ref_name_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgParsedRefNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_parsed_ref_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgParsedRefName), 0, (GInstanceInitFunc) gitg_parsed_ref_name_instance_init, NULL };
	GType gitg_parsed_ref_name_type_id;
	gitg_parsed_ref_name_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgParsedRefName", &g_define_type_info, 0);
	GitgParsedRefName_private_offset = g_type_add_instance_private (gitg_parsed_ref_name_type_id, sizeof (GitgParsedRefNamePrivate));
	return gitg_parsed_ref_name_type_id;
}

GType
gitg_parsed_ref_name_get_type (void)
{
	static gsize gitg_parsed_ref_name_type_id__once = 0;
	if (g_once_init_enter (&gitg_parsed_ref_name_type_id__once)) {
		GType gitg_parsed_ref_name_type_id;
		gitg_parsed_ref_name_type_id = gitg_parsed_ref_name_get_type_once ();
		g_once_init_leave (&gitg_parsed_ref_name_type_id__once, gitg_parsed_ref_name_type_id);
	}
	return gitg_parsed_ref_name_type_id__once;
}

static void
_vala_gitg_parsed_ref_name_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GitgParsedRefName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName);
	switch (property_id) {
		case GITG_PARSED_REF_NAME_RTYPE_PROPERTY:
		g_value_set_enum (value, gitg_parsed_ref_name_get_rtype (self));
		break;
		case GITG_PARSED_REF_NAME_NAME_PROPERTY:
		g_value_take_string (value, gitg_parsed_ref_name_get_name (self));
		break;
		case GITG_PARSED_REF_NAME_SHORTNAME_PROPERTY:
		g_value_take_string (value, gitg_parsed_ref_name_get_shortname (self));
		break;
		case GITG_PARSED_REF_NAME_REMOTE_NAME_PROPERTY:
		g_value_take_string (value, gitg_parsed_ref_name_get_remote_name (self));
		break;
		case GITG_PARSED_REF_NAME_REMOTE_BRANCH_PROPERTY:
		g_value_take_string (value, gitg_parsed_ref_name_get_remote_branch (self));
		break;
		case GITG_PARSED_REF_NAME_PREFIX_PROPERTY:
		g_value_set_string (value, gitg_parsed_ref_name_get_prefix (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_parsed_ref_name_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GitgParsedRefName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName);
	switch (property_id) {
		case GITG_PARSED_REF_NAME_RTYPE_PROPERTY:
		gitg_parsed_ref_name_set_rtype (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GitgRepository*
gitg_ref_get_owner (GitgRef* self)
{
	GitgRefIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->get_owner) {
		return _iface_->get_owner (self);
	}
	return NULL;
}

static gint
__lambda31_ (GitgRef* a,
             GitgRef* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ggit_ref_get_name ((GgitRef*) a);
	_tmp1_ = ggit_ref_get_name ((GgitRef*) b);
	result = g_ascii_strcasecmp (_tmp0_, _tmp1_);
	return result;
}

static gint
___lambda31__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda31_ ((GitgRef*) a, (GitgRef*) b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_ref_add_push_ref (GitgRef* self,
                       const gchar* spec)
{
	GitgRef* rf = NULL;
	GList* _tmp6_;
	GList* _tmp7_;
	GitgRef* _tmp8_;
	GList* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (spec != NULL);
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_;
		GitgRepository* _tmp2_;
		GitgRef* _tmp3_;
		GitgRef* _tmp4_;
		GitgRef* _tmp5_;
		_tmp1_ = gitg_ref_get_owner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gitg_repository_lookup_reference (_tmp2_, spec, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (rf);
		rf = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (rf);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (rf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = gitg_ref_get_d_pushes (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = rf;
	_tmp9_ = g_list_find_custom (_tmp7_, _tmp8_, ___lambda31__gcompare_func);
	if (_tmp9_ == NULL) {
		GList* _tmp10_;
		GList* _tmp11_;
		GitgRef* _tmp12_;
		GitgRef* _tmp13_;
		_tmp10_ = gitg_ref_get_d_pushes (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = rf;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		gitg_ref_set_d_pushes (self, g_list_append (_tmp11_, _tmp13_));
	}
	_g_object_unref0 (rf);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_ref_add_branch_configured_push (GitgRef* self,
                                     GgitConfig* cfg)
{
	gchar* remote = NULL;
	gchar* merge = NULL;
	GitgParsedRefName* nm = NULL;
	const gchar* _tmp26_;
	GitgParsedRefName* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GitgParsedRefName* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (cfg != NULL);
	{
		const gchar* _tmp0_ = NULL;
		GitgParsedRefName* _tmp1_;
		GitgParsedRefName* _tmp2_;
		GitgParsedRefName* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		GitgParsedRefName* _tmp14_;
		GitgParsedRefName* _tmp15_;
		GitgParsedRefName* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp1_ = gitg_ref_get_parsed_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gitg_parsed_ref_name_get_shortname (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("branch.", _tmp7_, ".remote", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = ggit_config_get_string (cfg, _tmp9_, &_inner_error0_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (_tmp3_);
		_tmp0_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = g_strdup (_tmp0_);
		_g_free0 (remote);
		remote = _tmp12_;
		_tmp14_ = gitg_ref_get_parsed_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gitg_parsed_ref_name_get_shortname (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("branch.", _tmp20_, ".merge", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = ggit_config_get_string (cfg, _tmp22_, &_inner_error0_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (_tmp16_);
		_tmp13_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp25_ = g_strdup (_tmp13_);
		_g_free0 (merge);
		merge = _tmp25_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (merge);
		_g_free0 (remote);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (merge);
		_g_free0 (remote);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp26_ = merge;
	_tmp27_ = gitg_parsed_ref_name_new (_tmp26_);
	nm = _tmp27_;
	_tmp28_ = remote;
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = nm;
	_tmp31_ = gitg_parsed_ref_name_get_shortname (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = g_strconcat ("refs/remotes/", _tmp29_, "/", _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	gitg_ref_add_push_ref (self, _tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp33_);
	_g_object_unref0 (nm);
	_g_free0 (merge);
	_g_free0 (remote);
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		GitgRef* self;
		self = _data21_->self;
		_g_regex_unref0 (_data21_->valregex);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static gint
___lambda32_ (Block21Data* _data21_,
              GMatchInfo* info,
              const gchar* val)
{
	GitgRef* self;
	GMatchInfo* vinfo = NULL;
	GRegex* _tmp0_;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* rname = NULL;
	gchar* _tmp3_;
	gchar* pref = NULL;
	GMatchInfo* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gint result;
	self = _data21_->self;
	g_return_val_if_fail (info != NULL, 0);
	g_return_val_if_fail (val != NULL, 0);
	_tmp0_ = _data21_->valregex;
	_tmp2_ = g_regex_match (_tmp0_, val, 0, &_tmp1_);
	_g_match_info_unref0 (vinfo);
	vinfo = _tmp1_;
	if (!_tmp2_) {
		result = 0;
		_g_match_info_unref0 (vinfo);
		return result;
	}
	_tmp3_ = g_match_info_fetch (info, 1);
	rname = _tmp3_;
	_tmp4_ = vinfo;
	_tmp5_ = g_match_info_fetch (_tmp4_, 1);
	pref = _tmp5_;
	_tmp6_ = rname;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = pref;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat ("refs/remotes/", _tmp7_, "/", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gitg_ref_add_push_ref (self, _tmp11_);
	_g_free0 (_tmp11_);
	result = 0;
	_g_free0 (pref);
	_g_free0 (rname);
	_g_match_info_unref0 (vinfo);
	return result;
}

static gint
____lambda32__ggit_config_match_callback (GMatchInfo* match_info,
                                          const gchar* value,
                                          gpointer self)
{
	gint result;
	result = ___lambda32_ (self, match_info, value);
	return result;
}

static void
gitg_ref_add_remote_configured_push (GitgRef* self,
                                     GgitConfig* cfg)
{
	Block21Data* _data21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (cfg != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	{
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp13_;
		_tmp1_ = ggit_ref_get_name ((GgitRef*) self);
		_tmp2_ = g_regex_escape_string (_tmp1_, -1);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("^%s:(.*)", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_regex_new (_tmp5_, 0, 0, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_tmp0_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (_data21_->valregex);
		_data21_->valregex = _tmp8_;
		_tmp9_ = gitg_ref_s_remote_key_regex;
		if (_tmp9_ == NULL) {
			GRegex* _tmp10_ = NULL;
			GRegex* _tmp11_;
			GRegex* _tmp12_;
			_tmp11_ = g_regex_new ("remote\\.(.*)\\.push", 0, 0, &_inner_error0_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			_g_regex_unref0 (gitg_ref_s_remote_key_regex);
			gitg_ref_s_remote_key_regex = _tmp12_;
			_g_regex_unref0 (_tmp10_);
		}
		_tmp13_ = gitg_ref_s_remote_key_regex;
		ggit_config_match_foreach (cfg, _tmp13_, ____lambda32__ggit_config_match_callback, _data21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		block21_data_unref (_data21_);
		_data21_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block21_data_unref (_data21_);
		_data21_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

static void
gitg_ref_add_branch_same_name_push (GitgRef* self,
                                    GgitConfig* cfg)
{
	gchar* remote = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GitgParsedRefName* _tmp15_;
	GitgParsedRefName* _tmp16_;
	GitgParsedRefName* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (cfg != NULL);
	{
		const gchar* _tmp0_ = NULL;
		GitgParsedRefName* _tmp1_;
		GitgParsedRefName* _tmp2_;
		GitgParsedRefName* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = gitg_ref_get_parsed_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gitg_parsed_ref_name_get_shortname (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("branch.", _tmp7_, ".remote", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = ggit_config_get_string (cfg, _tmp9_, &_inner_error0_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (_tmp3_);
		_tmp0_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = g_strdup (_tmp0_);
		_g_free0 (remote);
		remote = _tmp12_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (remote);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (remote);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp13_ = remote;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = gitg_ref_get_parsed_name (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = gitg_parsed_ref_name_get_shortname (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("refs/remotes/", _tmp14_, "/", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	gitg_ref_add_push_ref (self, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_g_object_unref0 (_tmp17_);
	_g_free0 (remote);
}

static void
gitg_ref_compose_pushes (GitgRef* self)
{
	GgitConfig* cfg = NULL;
	GgitConfig* _tmp6_;
	GgitConfig* _tmp7_;
	GgitConfig* _tmp8_;
	GError* _inner_error0_ = NULL;
	gitg_ref_set_d_pushes (self, NULL);
	{
		GgitConfig* _tmp0_ = NULL;
		GitgRepository* _tmp1_;
		GitgRepository* _tmp2_;
		GgitConfig* _tmp3_;
		GgitConfig* _tmp4_;
		GgitConfig* _tmp5_;
		_tmp1_ = gitg_ref_get_owner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = ggit_repository_get_config ((GgitRepository*) _tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (cfg);
		cfg = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (cfg);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cfg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = cfg;
	gitg_ref_add_branch_configured_push (self, _tmp6_);
	_tmp7_ = cfg;
	gitg_ref_add_remote_configured_push (self, _tmp7_);
	_tmp8_ = cfg;
	gitg_ref_add_branch_same_name_push (self, _tmp8_);
	_g_object_unref0 (cfg);
}

GitgParsedRefName*
gitg_ref_get_d_parsed_name (GitgRef* self)
{
	GitgRefIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->get_d_parsed_name) {
		return _iface_->get_d_parsed_name (self);
	}
	return NULL;
}

void
gitg_ref_set_d_parsed_name (GitgRef* self,
                            GitgParsedRefName* value)
{
	GitgRefIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->set_d_parsed_name) {
		_iface_->set_d_parsed_name (self, value);
	}
}

GList*
gitg_ref_get_d_pushes (GitgRef* self)
{
	GitgRefIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->get_d_pushes) {
		return _iface_->get_d_pushes (self);
	}
	return NULL;
}

void
gitg_ref_set_d_pushes (GitgRef* self,
                       GList* value)
{
	GitgRefIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->set_d_pushes) {
		_iface_->set_d_pushes (self, value);
	}
}

GitgRefState
gitg_ref_get_state (GitgRef* self)
{
	GitgRefIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->get_state) {
		return _iface_->get_state (self);
	}
	return 0;
}

void
gitg_ref_set_state (GitgRef* self,
                    GitgRefState value)
{
	GitgRefIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->set_state) {
		_iface_->set_state (self, value);
	}
}

gboolean
gitg_ref_get_working (GitgRef* self)
{
	GitgRefIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->get_working) {
		return _iface_->get_working (self);
	}
	return FALSE;
}

void
gitg_ref_set_working (GitgRef* self,
                      gboolean value)
{
	GitgRefIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_REF_GET_INTERFACE (self);
	if (_iface_->set_working) {
		_iface_->set_working (self, value);
	}
}

GitgParsedRefName*
gitg_ref_get_parsed_name (GitgRef* self)
{
	GitgParsedRefName* result;
	GitgParsedRefName* _tmp0_;
	GitgParsedRefName* _tmp1_;
	GitgParsedRefName* _tmp5_;
	GitgParsedRefName* _tmp6_;
	GitgParsedRefName* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_ref_get_d_parsed_name (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GitgParsedRefName* _tmp3_;
		GitgParsedRefName* _tmp4_;
		_tmp2_ = ggit_ref_get_name ((GgitRef*) self);
		_tmp3_ = gitg_parsed_ref_name_new (_tmp2_);
		_tmp4_ = _tmp3_;
		gitg_ref_set_d_parsed_name (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	_tmp5_ = gitg_ref_get_d_parsed_name (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

GList*
gitg_ref_get_pushes (GitgRef* self)
{
	GList* result;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_ref_get_d_pushes (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gitg_ref_compose_pushes (self);
	}
	_tmp2_ = gitg_ref_get_d_pushes (self);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
gitg_ref_default_init (GitgRefIface * iface,
                       gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_object ("d-parsed-name", "d-parsed-name", "d-parsed-name", GITG_TYPE_PARSED_REF_NAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_pointer ("d-pushes", "d-pushes", "d-pushes", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_enum ("state", "state", "state", GITG_TYPE_REF_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("working", "working", "working", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

 G_GNUC_NO_INLINE static GType
gitg_ref_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRefIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ref_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gitg_ref_type_id;
	gitg_ref_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgRef", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gitg_ref_type_id, ggit_ref_get_type ());
	return gitg_ref_type_id;
}

GType
gitg_ref_get_type (void)
{
	static gsize gitg_ref_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_type_id__once)) {
		GType gitg_ref_type_id;
		gitg_ref_type_id = gitg_ref_get_type_once ();
		g_once_init_leave (&gitg_ref_type_id__once, gitg_ref_type_id);
	}
	return gitg_ref_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

