/* gitg-textconv.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-textconv.vala, do not modify */

/*
 *
 * Copyright (C) 2021 - Alberto Fanjul
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <libgit2-glib/ggit.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GitgParamSpecTextConv GitgParamSpecTextConv;

struct _GitgParamSpecTextConv {
	GParamSpec parent_instance;
};

static gpointer gitg_text_conv_parent_class = NULL;

static gchar* gitg_text_conv_get_textconv_command (GitgRepository* repository,
                                            GgitDiffFile* file);
static guint8* _vala_array_dup26 (guint8* self,
                           gssize length);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static guint8* _vala_array_dup27 (guint8* self,
                           gssize length);
static void _vala_GgitOId_free (GgitOId* self);
static guint8* _vala_array_dup28 (guint8* self,
                           gssize length);
static guint8* gitg_text_conv_textconv (const gchar* command,
                                 guint8* data,
                                 gint data_length1,
                                 gint* result_length1);
static guint8* _vala_array_dup29 (guint8* self,
                           gssize length);
static void _g_free_gdestroy_notify (void* data);
static guint8* _vala_array_dup30 (guint8* self,
                           gssize length);
static void gitg_text_conv_finalize (GitgTextConv * obj);
static GType gitg_text_conv_get_type_once (void);

gboolean
gitg_text_conv_has_textconv_command (GitgRepository* repository,
                                     GgitDiffFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (repository != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = gitg_text_conv_get_textconv_command (repository, file);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
gitg_text_conv_get_textconv_command (GitgRepository* repository,
                                     GgitDiffFile* file)
{
	gchar* command = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* diffattr = NULL;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (repository != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	command = NULL;
	_tmp0_ = ggit_diff_file_get_path (file);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	diffattr = NULL;
	{
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = path;
		_tmp4_ = ggit_repository_get_attribute ((GgitRepository*) repository, _tmp3_, "diff", GGIT_ATTRIBUTE_CHECK_FILE_THEN_INDEX, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_strdup (_tmp2_);
		_g_free0 (diffattr);
		diffattr = _tmp5_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (diffattr);
		_g_free0 (path);
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = diffattr;
	if (_tmp6_ != NULL) {
		gchar* textconv_key = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = diffattr;
		_tmp8_ = g_strdup_printf ("diff.%s.textconv", _tmp7_);
		textconv_key = _tmp8_;
		{
			GgitConfig* _tmp9_ = NULL;
			GgitConfig* _tmp10_;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = ggit_repository_get_config ((GgitRepository*) repository, &_inner_error0_);
			_tmp9_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp12_ = textconv_key;
			_tmp13_ = ggit_config_get_string (_tmp9_, _tmp12_, &_inner_error0_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp9_);
				goto __catch1_g_error;
			}
			_tmp14_ = g_strdup (_tmp11_);
			_g_free0 (command);
			command = _tmp14_;
			_g_object_unref0 (_tmp9_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (textconv_key);
			_g_free0 (diffattr);
			_g_free0 (path);
			_g_free0 (command);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (textconv_key);
	}
	result = command;
	_g_free0 (diffattr);
	_g_free0 (path);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup26 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static gpointer
__vala_GgitOId_copy0 (gpointer self)
{
	return self ? _vala_GgitOId_copy (self) : NULL;
}

static guint8*
_vala_array_dup27 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

guint8*
gitg_text_conv_get_textconv_content (GitgRepository* repository,
                                     GgitDiffFile* file,
                                     gint* result_length1)
{
	guint8* content = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint content_length1;
	gint _content_size_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (repository != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = string_get_data ("", &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup26 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	content = _tmp3_;
	content_length1 = _tmp3__length1;
	_content_size_ = content_length1;
	if (file != NULL) {
		GgitOId* oid = NULL;
		GgitOId* _tmp4_;
		GgitOId* _tmp5_;
		guint8* raw_content = NULL;
		gint raw_content_length1;
		gint _raw_content_size_;
		GgitOId* _tmp6_;
		_tmp4_ = ggit_diff_file_get_oid (file);
		_tmp5_ = __vala_GgitOId_copy0 (_tmp4_);
		oid = _tmp5_;
		raw_content = NULL;
		raw_content_length1 = 0;
		_raw_content_size_ = raw_content_length1;
		_tmp6_ = oid;
		if (!ggit_oid_is_zero (_tmp6_)) {
			{
				GgitBlob* blob = NULL;
				GgitOId* _tmp7_;
				gpointer _tmp8_;
				GgitBlob* _tmp9_;
				gsize _tmp10_ = 0;
				guint8* _tmp11_;
				guint8* _tmp12_;
				gint _tmp12__length1;
				guint8* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_ = 0;
				guint8* _tmp15_;
				_tmp7_ = oid;
				_tmp8_ = gitg_repository_lookup (repository, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp7_, &_inner_error0_);
				blob = (GgitBlob*) _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp9_ = blob;
				_tmp11_ = ggit_blob_get_raw_content (_tmp9_, &_tmp10_);
				_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup27 (_tmp11_, _tmp10_) : _tmp11_;
				_tmp12__length1 = _tmp10_;
				raw_content = (g_free (raw_content), NULL);
				raw_content = _tmp12_;
				raw_content_length1 = _tmp12__length1;
				_raw_content_size_ = raw_content_length1;
				_tmp13_ = raw_content;
				_tmp13__length1 = raw_content_length1;
				_tmp15_ = gitg_text_conv_get_textconv_content_from_raw (repository, file, _tmp13_, (gint) _tmp13__length1, &_tmp14_);
				content = (g_free (content), NULL);
				content = _tmp15_;
				content_length1 = _tmp14_;
				_content_size_ = content_length1;
				_g_object_unref0 (blob);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				raw_content = (g_free (raw_content), NULL);
				__vala_GgitOId_free0 (oid);
				content = (g_free (content), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		raw_content = (g_free (raw_content), NULL);
		__vala_GgitOId_free0 (oid);
	}
	_tmp16_ = content;
	_tmp16__length1 = content_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}

static guint8*
_vala_array_dup28 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

guint8*
gitg_text_conv_get_textconv_content_from_raw (GitgRepository* repository,
                                              GgitDiffFile* file,
                                              guint8* raw_content,
                                              gint raw_content_length1,
                                              gint* result_length1)
{
	guint8* content = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint content_length1;
	gint _content_size_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* result;
	g_return_val_if_fail (repository != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = string_get_data ("", &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup28 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	content = _tmp3_;
	content_length1 = _tmp3__length1;
	_content_size_ = content_length1;
	if (raw_content != NULL) {
		gchar* command = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = gitg_text_conv_get_textconv_command (repository, file);
		command = _tmp4_;
		_tmp5_ = command;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			gint _tmp7_ = 0;
			guint8* _tmp8_;
			_tmp6_ = command;
			_tmp8_ = gitg_text_conv_textconv (_tmp6_, raw_content, (gint) raw_content_length1, &_tmp7_);
			content = (g_free (content), NULL);
			content = _tmp8_;
			content_length1 = _tmp7_;
			_content_size_ = content_length1;
		}
		_g_free0 (command);
	}
	_tmp9_ = content;
	_tmp9__length1 = content_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

static guint8*
_vala_array_dup29 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
_g_free_gdestroy_notify (void* data)
{
	g_free (data);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static guint8*
_vala_array_dup30 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
gitg_text_conv_textconv (const gchar* command,
                         guint8* data,
                         gint data_length1,
                         gint* result_length1)
{
	gchar* lines = NULL;
	gchar* _tmp0_;
	const gchar* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_ = 0;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint8* _tmp30_;
	gint _tmp30__length1;
	guint8* _tmp31_;
	gint _tmp31__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = g_strdup ("");
	lines = _tmp0_;
	{
		GSubprocess* subproc = NULL;
		GSubprocess* _tmp1_;
		GMemoryInputStream* input = NULL;
		guint8* _tmp2_;
		gint _tmp2__length1;
		GMemoryInputStream* _tmp3_;
		GSubprocess* _tmp4_;
		GOutputStream* _tmp5_;
		GMemoryInputStream* _tmp6_;
		GInputStream* end_pipe = NULL;
		GSubprocess* _tmp7_;
		GInputStream* _tmp8_;
		GInputStream* _tmp9_;
		GDataInputStream* output = NULL;
		GInputStream* _tmp10_;
		GDataInputStream* _tmp11_;
		gchar* line = NULL;
		_tmp1_ = g_subprocess_new (G_SUBPROCESS_FLAGS_STDIN_PIPE | G_SUBPROCESS_FLAGS_STDOUT_PIPE, &_inner_error0_, command, "/dev/stdin", NULL);
		subproc = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = (data != NULL) ? _vala_array_dup29 (data, data_length1) : data;
		_tmp2__length1 = data_length1;
		_tmp3_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp2_, _tmp2__length1, _g_free_gdestroy_notify);
		input = _tmp3_;
		_tmp4_ = subproc;
		_tmp5_ = g_subprocess_get_stdin_pipe (_tmp4_);
		_tmp6_ = input;
		g_output_stream_splice (_tmp5_, (GInputStream*) _tmp6_, G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (input);
			_g_object_unref0 (subproc);
			goto __catch0_g_error;
		}
		_tmp7_ = subproc;
		_tmp8_ = g_subprocess_get_stdout_pipe (_tmp7_);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		end_pipe = _tmp9_;
		_tmp10_ = end_pipe;
		_tmp11_ = g_data_input_stream_new (_tmp10_);
		output = _tmp11_;
		line = NULL;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gchar* _tmp14_ = NULL;
				GDataInputStream* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				if (!_tmp12_) {
					const gchar* _tmp13_;
					_tmp13_ = line;
					if (!(_tmp13_ != NULL)) {
						break;
					}
				}
				_tmp12_ = FALSE;
				_tmp15_ = output;
				_tmp16_ = g_data_input_stream_read_line (_tmp15_, NULL, NULL, &_inner_error0_);
				_tmp14_ = _tmp16_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (output);
					_g_object_unref0 (end_pipe);
					_g_object_unref0 (input);
					_g_object_unref0 (subproc);
					goto __catch0_g_error;
				}
				_tmp17_ = _tmp14_;
				_tmp14_ = NULL;
				_g_free0 (line);
				line = _tmp17_;
				_tmp18_ = line;
				if (_tmp18_ != NULL) {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp19_ = line;
					_tmp20_ = string_replace (_tmp19_, "\f", "");
					_g_free0 (line);
					line = _tmp20_;
					_tmp21_ = lines;
					_tmp22_ = line;
					_tmp23_ = g_strconcat (_tmp22_, "\n", NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp21_, _tmp24_, NULL);
					_g_free0 (lines);
					lines = _tmp25_;
					_g_free0 (_tmp24_);
				}
				_g_free0 (_tmp14_);
			}
		}
		_g_free0 (line);
		_g_object_unref0 (output);
		_g_object_unref0 (end_pipe);
		_g_object_unref0 (input);
		_g_object_unref0 (subproc);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (lines);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp26_ = lines;
	_tmp27_ = string_get_data (_tmp26_, &_tmp28_);
	_tmp27__length1 = _tmp28_;
	_tmp29_ = _tmp27_;
	_tmp29__length1 = _tmp27__length1;
	_tmp30_ = (_tmp29_ != NULL) ? _vala_array_dup30 (_tmp29_, _tmp29__length1) : _tmp29_;
	_tmp30__length1 = _tmp29__length1;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _tmp30__length1;
	if (result_length1) {
		*result_length1 = _tmp31__length1;
	}
	result = _tmp31_;
	_g_free0 (lines);
	return result;
}

GitgTextConv*
gitg_text_conv_construct (GType object_type)
{
	GitgTextConv* self = NULL;
	self = (GitgTextConv*) g_type_create_instance (object_type);
	return self;
}

GitgTextConv*
gitg_text_conv_new (void)
{
	return gitg_text_conv_construct (GITG_TYPE_TEXT_CONV);
}

static void
gitg_value_text_conv_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_text_conv_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_text_conv_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_text_conv_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_text_conv_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_text_conv_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_text_conv_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgTextConv * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_text_conv_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_text_conv_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	GitgTextConv ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_text_conv_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_text_conv (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	GitgParamSpecTextConv* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_TEXT_CONV), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_text_conv (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_TEXT_CONV), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_text_conv (GValue* value,
                          gpointer v_object)
{
	GitgTextConv * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_TEXT_CONV));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_TEXT_CONV));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_text_conv_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_text_conv_unref (old);
	}
}

void
gitg_value_take_text_conv (GValue* value,
                           gpointer v_object)
{
	GitgTextConv * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_TEXT_CONV));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_TEXT_CONV));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_text_conv_unref (old);
	}
}

static void
gitg_text_conv_class_init (GitgTextConvClass * klass,
                           gpointer klass_data)
{
	gitg_text_conv_parent_class = g_type_class_peek_parent (klass);
	((GitgTextConvClass *) klass)->finalize = gitg_text_conv_finalize;
}

static void
gitg_text_conv_instance_init (GitgTextConv * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_text_conv_finalize (GitgTextConv * obj)
{
	GitgTextConv * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_TEXT_CONV, GitgTextConv);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gitg_text_conv_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_text_conv_init, gitg_value_text_conv_free_value, gitg_value_text_conv_copy_value, gitg_value_text_conv_peek_pointer, "p", gitg_value_text_conv_collect_value, "p", gitg_value_text_conv_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgTextConvClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_text_conv_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTextConv), 0, (GInstanceInitFunc) gitg_text_conv_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_text_conv_type_id;
	gitg_text_conv_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgTextConv", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_text_conv_type_id;
}

GType
gitg_text_conv_get_type (void)
{
	static gsize gitg_text_conv_type_id__once = 0;
	if (g_once_init_enter (&gitg_text_conv_type_id__once)) {
		GType gitg_text_conv_type_id;
		gitg_text_conv_type_id = gitg_text_conv_get_type_once ();
		g_once_init_leave (&gitg_text_conv_type_id__once, gitg_text_conv_type_id);
	}
	return gitg_text_conv_type_id__once;
}

gpointer
gitg_text_conv_ref (gpointer instance)
{
	GitgTextConv * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_text_conv_unref (gpointer instance)
{
	GitgTextConv * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_TEXT_CONV_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

