/* gdi.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gdi.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "games-dreamcast-plugin.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "gnome-games.h"

#define GAMES_GDI_NEW_LINE "\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_GDI_0_PROPERTY,
	GAMES_GDI_FILE_PROPERTY,
	GAMES_GDI_TRACKS_NUMBER_PROPERTY,
	GAMES_GDI_NUM_PROPERTIES
};
static GParamSpec* games_gdi_properties[GAMES_GDI_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_GDI_ERROR (games_gdi_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesGdiPrivate {
	GFile* _file;
	gboolean parsed;
	GamesGdiTrackNode* tracks;
	gint tracks_length1;
	gint _tracks_size_;
};

typedef enum  {
	GAMES_GDI_ERROR_UNEXPECTED_TOKEN,
	GAMES_GDI_ERROR_UNEXPECTED_EOL,
	GAMES_GDI_ERROR_UNEXPECTED_EOF,
	GAMES_GDI_ERROR_INVALID_TRACK_NUMBER,
	GAMES_GDI_ERROR_INVALID_TRACK_MODE,
	GAMES_GDI_ERROR_NOT_A_TRACK
} GamesGdiError;
#define GAMES_GDI_ERROR games_gdi_error_quark ()

static gint GamesGdi_private_offset;
static gpointer games_gdi_parent_class = NULL;
static GRegex* games_gdi_token_regex;
static GRegex* games_gdi_token_regex = NULL;
static GType games_gdi_type_id = 0;

static void _vala_GamesGdiTrackNode_array_free (GamesGdiTrackNode * array,
                                         gssize array_length);
VALA_EXTERN GQuark games_gdi_error_quark (void);
VALA_EXTERN GType games_gdi_error_get_type (void) G_GNUC_CONST ;
static gchar** games_gdi_tokenize (GamesGdi* self,
                            gint* result_length1,
                            GError** error);
static gchar** games_gdi_tokenize_line (const gchar* line,
                                 gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void games_gdi_parse_track_count_line (GamesGdi* self,
                                       gchar*** tokens,
                                       gint* tokens_length1,
                                       gsize* i,
                                       gsize line,
                                       GError** error);
static void games_gdi_parse_track_line (GamesGdi* self,
                                 gchar*** tokens,
                                 gint* tokens_length1,
                                 gsize* i,
                                 gsize line,
                                 GamesGdiTrackNode* result,
                                 GError** error);
static void _vala_array_add5 (GamesGdiTrackNode* * array,
                       gint* length,
                       gint* size,
                       const GamesGdiTrackNode* value);
static void games_gdi_skip_token (GamesGdi* self,
                           gchar*** tokens,
                           gint* tokens_length1,
                           gsize* i,
                           gsize line,
                           GError** error);
static void games_gdi_is_end_of_line (GamesGdi* self,
                               gchar*** tokens,
                               gint* tokens_length1,
                               gsize* i,
                               gsize line,
                               GError** error);
static gchar* games_gdi_get_token (GamesGdi* self,
                            gchar*** tokens,
                            gint* tokens_length1,
                            gsize* i,
                            gsize line,
                            GError** error);
static void games_gdi_finalize (GObject * obj);
static void _vala_games_gdi_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_games_gdi_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
games_gdi_get_instance_private (GamesGdi* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGdi_private_offset);
}

static void
_vala_GamesGdiTrackNode_array_free (GamesGdiTrackNode * array,
                                    gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gdi_track_node_destroy (&array[i]);
		}
	}
	g_free (array);
}

GamesGdi*
games_gdi_construct (GType object_type,
                     GFile* file)
{
	GamesGdi * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesGdi*) g_object_new (object_type, "file", file, NULL);
	return self;
}

GamesGdi*
games_gdi_new (GFile* file)
{
	return games_gdi_construct (GAMES_TYPE_GDI, file);
}

void
games_gdi_get_track (GamesGdi* self,
                     guint i,
                     GamesGdiTrackNode* result,
                     GError** error)
{
	GamesGdiTrackNode* _tmp0_;
	gint _tmp0__length1;
	GamesGdiTrackNode* _tmp6_;
	gint _tmp6__length1;
	GamesGdiTrackNode _tmp7_;
	GamesGdiTrackNode _tmp8_;
	GamesGdiTrackNode _tmp9_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->parsed, "parsed");
	_tmp0_ = self->priv->tracks;
	_tmp0__length1 = self->priv->tracks_length1;
	if (i >= ((guint) _tmp0__length1)) {
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp1_ = self->priv->_file;
		_tmp2_ = g_file_get_uri (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_NOT_A_TRACK, "“%s” doesn’t have a track for index %u.", _tmp3_, i);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp6_ = self->priv->tracks;
	_tmp6__length1 = self->priv->tracks_length1;
	_tmp7_ = _tmp6_[i];
	_tmp8_ = _tmp7_;
	games_gdi_track_node_copy (&_tmp8_, &_tmp9_);
	*result = _tmp9_;
	return;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
games_gdi_tokenize (GamesGdi* self,
                    gint* result_length1,
                    GError** error)
{
	GInputStream* stream = NULL;
	GFile* _tmp0_;
	GInputStream* _tmp1_;
	GDataInputStream* data_stream = NULL;
	GInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	gchar** tokens = NULL;
	gchar** _tmp4_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar* line = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	_tmp1_ = games_unicode_read (_tmp0_, GAMES_UNICODE_ENCODING_UTF_8, &_inner_error0_);
	stream = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = stream;
	_tmp3_ = g_data_input_stream_new (_tmp2_);
	data_stream = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	tokens = _tmp4_;
	tokens_length1 = 0;
	_tokens_size_ = tokens_length1;
	while (TRUE) {
		gchar* _tmp5_ = NULL;
		GDataInputStream* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		gchar** _tmp12_;
		_tmp6_ = data_stream;
		_tmp7_ = g_data_input_stream_read_line_utf8 (_tmp6_, NULL, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data_stream);
			_g_object_unref0 (stream);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (line);
		line = _tmp8_;
		_tmp9_ = line;
		if (!(_tmp9_ != NULL)) {
			_g_free0 (_tmp5_);
			break;
		}
		_tmp10_ = line;
		_tmp12_ = games_gdi_tokenize_line (_tmp10_, &_tmp11_);
		{
			gchar** token_collection = NULL;
			gint token_collection_length1 = 0;
			gint _token_collection_size_ = 0;
			gint token_it = 0;
			token_collection = _tmp12_;
			token_collection_length1 = _tmp11_;
			for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
				gchar* _tmp13_;
				gchar* token = NULL;
				_tmp13_ = g_strdup (token_collection[token_it]);
				token = _tmp13_;
				{
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = token;
					_tmp15_ = g_strdup (_tmp14_);
					_vala_array_add1 (&tokens, &tokens_length1, &_tokens_size_, _tmp15_);
					_g_free0 (token);
				}
			}
			token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (_tmp5_);
	}
	_tmp16_ = tokens;
	_tmp16__length1 = tokens_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_free0 (line);
	_g_object_unref0 (data_stream);
	_g_object_unref0 (stream);
	return result;
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
games_gdi_tokenize_line (const gchar* line,
                         gint* result_length1)
{
	GRegex* _tmp0_;
	gchar** tokens = NULL;
	gchar** _tmp2_;
	gint tokens_length1;
	gint _tokens_size_;
	GRegex* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gboolean _tmp14_ = FALSE;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** result;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = games_gdi_token_regex;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\s*([^\"\\s]+)|(\".+?\")\\s*", 0));
		_g_regex_unref0 (games_gdi_token_regex);
		games_gdi_token_regex = _tmp1_;
	}
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	tokens = _tmp2_;
	tokens_length1 = 0;
	_tokens_size_ = tokens_length1;
	_tmp3_ = games_gdi_token_regex;
	_tmp5_ = _tmp4_ = g_regex_split (_tmp3_, line, 0);
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp5_;
		token_collection_length1 = _vala_array_length (_tmp4_);
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp6_;
			gchar* token = NULL;
			_tmp6_ = g_strdup (token_collection[token_it]);
			token = _tmp6_;
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				static GQuark _tmp9_label2 = 0;
				static GQuark _tmp9_label3 = 0;
				_tmp7_ = token;
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if ((_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("\r")))) || (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("\r\n"))))) {
					switch (0) {
						default:
						{
							gchar* _tmp11_;
							_tmp11_ = g_strdup (GAMES_GDI_NEW_LINE);
							_vala_array_add2 (&tokens, &tokens_length1, &_tokens_size_, _tmp11_);
							break;
						}
					}
				} else if ((_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("")))) || (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string (" "))))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp12_ = token;
							_tmp13_ = g_strdup (_tmp12_);
							_vala_array_add3 (&tokens, &tokens_length1, &_tokens_size_, _tmp13_);
							break;
						}
					}
				}
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp15_ = tokens;
	_tmp15__length1 = tokens_length1;
	if (_tmp15__length1 != 0) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		_tmp16_ = tokens;
		_tmp16__length1 = tokens_length1;
		_tmp17_ = tokens;
		_tmp17__length1 = tokens_length1;
		_tmp18_ = _tmp16_[_tmp17__length1 - 1];
		_tmp14_ = g_strcmp0 (_tmp18_, GAMES_GDI_NEW_LINE) != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (GAMES_GDI_NEW_LINE);
		_vala_array_add4 (&tokens, &tokens_length1, &_tokens_size_, _tmp19_);
	}
	_tmp20_ = tokens;
	_tmp20__length1 = tokens_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}

static void
_vala_array_add5 (GamesGdiTrackNode* * array,
                  gint* length,
                  gint* size,
                  const GamesGdiTrackNode* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGdiTrackNode, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

void
games_gdi_parse (GamesGdi* self,
                 GError** error)
{
	gchar** tokens = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gsize line = 0UL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_assert (!self->priv->parsed, "!parsed");
	self->priv->parsed = TRUE;
	_tmp1_ = games_gdi_tokenize (self, &_tmp0_, &_inner_error0_);
	tokens = _tmp1_;
	tokens_length1 = _tmp0_;
	_tokens_size_ = tokens_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	line = (gsize) 1;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar** _tmp4_;
				gint _tmp4__length1;
				if (!_tmp2_) {
					gsize _tmp3_;
					_tmp3_ = line;
					line = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = tokens;
				_tmp4__length1 = tokens_length1;
				if (!(i < ((gsize) _tmp4__length1))) {
					break;
				}
				if (line == ((gsize) 1)) {
					games_gdi_parse_track_count_line (self, &tokens, (gint*) (&tokens_length1), &i, line, &_inner_error0_);
					_tokens_size_ = tokens_length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
				} else {
					GamesGdiTrackNode _tmp5_ = {0};
					GamesGdiTrackNode _tmp6_ = {0};
					GamesGdiTrackNode _tmp7_;
					games_gdi_parse_track_line (self, &tokens, (gint*) (&tokens_length1), &i, line, &_tmp6_, &_inner_error0_);
					_tokens_size_ = tokens_length1;
					_tmp5_ = _tmp6_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_tmp7_ = _tmp5_;
					memset (&_tmp5_, 0, sizeof (GamesGdiTrackNode));
					_vala_array_add5 (&self->priv->tracks, &self->priv->tracks_length1, &self->priv->_tracks_size_, &_tmp7_);
					games_gdi_track_node_destroy (&_tmp5_);
				}
			}
		}
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}

static void
games_gdi_parse_track_count_line (GamesGdi* self,
                                  gchar*** tokens,
                                  gint* tokens_length1,
                                  gsize* i,
                                  gsize line,
                                  GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	games_gdi_skip_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	games_gdi_is_end_of_line (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_gdi_parse_track_line (GamesGdi* self,
                            gchar*** tokens,
                            gint* tokens_length1,
                            gsize* i,
                            gsize line,
                            GamesGdiTrackNode* result,
                            GError** error)
{
	gchar* track_number_string = NULL;
	gchar* _tmp0_;
	gchar* file_name = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GFile* dir = NULL;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* child_file = NULL;
	GFile* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	gint track_number = 0;
	const gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GamesGdiTrackNode _tmp29_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_gdi_get_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	track_number_string = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	games_gdi_skip_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	games_gdi_skip_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	games_gdi_skip_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = games_gdi_get_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	file_name = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = file_name;
	if (g_str_has_prefix (_tmp4_, "\"")) {
		const gchar* _tmp5_;
		_tmp5_ = file_name;
		_tmp3_ = g_str_has_suffix (_tmp5_, "\"");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = file_name;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ > 1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = file_name;
		_tmp10_ = file_name;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_slice (_tmp9_, (glong) 1, (glong) (_tmp12_ - 1));
		_g_free0 (file_name);
		file_name = _tmp13_;
	}
	_tmp14_ = self->priv->_file;
	_tmp15_ = g_file_get_parent (_tmp14_);
	dir = _tmp15_;
	_tmp16_ = dir;
	_tmp17_ = file_name;
	_tmp18_ = g_file_get_child (_tmp16_, _tmp17_);
	child_file = _tmp18_;
	games_gdi_skip_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_name);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_name);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	games_gdi_is_end_of_line (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_name);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_name);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp19_ = track_number_string;
	track_number = atoi (_tmp19_);
	if (track_number < 1) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = track_number > 99;
	}
	if (_tmp20_) {
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		GError* _tmp26_;
		_tmp21_ = self->priv->_file;
		_tmp22_ = g_file_get_basename (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = track_number_string;
		_tmp25_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_INVALID_TRACK_NUMBER, "%s:%lu: Invalid track number %s, expected a number in the 1-99 range.", _tmp23_, (gulong) line, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp23_);
		_inner_error0_ = _tmp26_;
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_name);
			_g_free0 (track_number_string);
			return;
		} else {
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_name);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp27_ = child_file;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	memset (&_tmp29_, 0, sizeof (GamesGdiTrackNode));
	_g_object_unref0 (_tmp29_.file);
	_tmp29_.file = _tmp28_;
	_tmp29_.track_number = track_number;
	*result = _tmp29_;
	_g_object_unref0 (child_file);
	_g_object_unref0 (dir);
	_g_free0 (file_name);
	_g_free0 (track_number_string);
	return;
}

static void
games_gdi_skip_token (GamesGdi* self,
                      gchar*** tokens,
                      gint* tokens_length1,
                      gsize* i,
                      gsize line,
                      GError** error)
{
	const gchar* _tmp5_;
	gsize _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if ((*i) >= ((gsize) (*tokens_length1))) {
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp0_ = self->priv->_file;
		_tmp1_ = g_file_get_basename (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_UNEXPECTED_EOF, "%s:%lu: Unexpected end of file, expected a token.", _tmp2_, (gulong) line);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = (*tokens)[*i];
	if (g_strcmp0 (_tmp5_, GAMES_GDI_NEW_LINE) == 0) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp6_ = self->priv->_file;
		_tmp7_ = g_file_get_basename (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_UNEXPECTED_EOL, "%s:%lu: Unexpected end of line, expected a token.", _tmp8_, (gulong) line);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp11_ = *i;
	*i = _tmp11_ + 1;
}

static gchar*
games_gdi_get_token (GamesGdi* self,
                     gchar*** tokens,
                     gint* tokens_length1,
                     gsize* i,
                     gsize line,
                     GError** error)
{
	const gchar* _tmp5_;
	gsize _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if ((*i) >= ((gsize) (*tokens_length1))) {
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp0_ = self->priv->_file;
		_tmp1_ = g_file_get_basename (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_UNEXPECTED_EOF, "%s:%lu: Unexpected end of file, expected a token.", _tmp2_, (gulong) line);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = (*tokens)[*i];
	if (g_strcmp0 (_tmp5_, GAMES_GDI_NEW_LINE) == 0) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp6_ = self->priv->_file;
		_tmp7_ = g_file_get_basename (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_UNEXPECTED_EOL, "%s:%lu: Unexpected end of line, expected a token.", _tmp8_, (gulong) line);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = *i;
	*i = _tmp11_ + 1;
	_tmp12_ = (*tokens)[_tmp11_];
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	return result;
}

static void
games_gdi_is_end_of_line (GamesGdi* self,
                          gchar*** tokens,
                          gint* tokens_length1,
                          gsize* i,
                          gsize line,
                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	gsize _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if ((*i) < ((gsize) (*tokens_length1))) {
		const gchar* _tmp1_;
		_tmp1_ = (*tokens)[*i];
		_tmp0_ = g_strcmp0 (_tmp1_, GAMES_GDI_NEW_LINE) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = self->priv->_file;
		_tmp3_ = g_file_get_basename (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = (*tokens)[*i];
		_tmp6_ = g_error_new (GAMES_GDI_ERROR, GAMES_GDI_ERROR_UNEXPECTED_TOKEN, "%s:%lu: Unexpected token %s, expected end of line.", _tmp4_, (gulong) line, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GAMES_GDI_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp8_ = *i;
	*i = _tmp8_ + 1;
}

GFile*
games_gdi_get_file (GamesGdi* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
games_gdi_set_file (GamesGdi* self,
                    GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_gdi_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_gdi_properties[GAMES_GDI_FILE_PROPERTY]);
	}
}

guint
games_gdi_get_tracks_number (GamesGdi* self)
{
	guint result;
	GamesGdiTrackNode* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0U);
	_vala_assert (self->priv->parsed, "parsed");
	_tmp0_ = self->priv->tracks;
	_tmp0__length1 = self->priv->tracks_length1;
	result = (guint) _tmp0__length1;
	return result;
}

void
games_gdi_track_node_copy (const GamesGdiTrackNode* self,
                           GamesGdiTrackNode* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	_tmp0_ = (*self).file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).file);
	(*dest).file = _tmp1_;
	(*dest).track_number = (*self).track_number;
}

void
games_gdi_track_node_destroy (GamesGdiTrackNode* self)
{
	_g_object_unref0 ((*self).file);
}

GamesGdiTrackNode*
games_gdi_track_node_dup (const GamesGdiTrackNode* self)
{
	GamesGdiTrackNode* dup;
	dup = g_new0 (GamesGdiTrackNode, 1);
	games_gdi_track_node_copy (self, dup);
	return dup;
}

void
games_gdi_track_node_free (GamesGdiTrackNode* self)
{
	games_gdi_track_node_destroy (self);
	g_free (self);
}

static GType
games_gdi_track_node_get_type_once (void)
{
	GType games_gdi_track_node_type_id;
	games_gdi_track_node_type_id = g_boxed_type_register_static ("GamesGdiTrackNode", (GBoxedCopyFunc) games_gdi_track_node_dup, (GBoxedFreeFunc) games_gdi_track_node_free);
	return games_gdi_track_node_type_id;
}

GType
games_gdi_track_node_get_type (void)
{
	static volatile gsize games_gdi_track_node_type_id__once = 0;
	if (g_once_init_enter (&games_gdi_track_node_type_id__once)) {
		GType games_gdi_track_node_type_id;
		games_gdi_track_node_type_id = games_gdi_track_node_get_type_once ();
		g_once_init_leave (&games_gdi_track_node_type_id__once, games_gdi_track_node_type_id);
	}
	return games_gdi_track_node_type_id__once;
}

static void
games_gdi_class_init (GamesGdiClass * klass,
                      gpointer klass_data)
{
	games_gdi_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGdi_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_gdi_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_gdi_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_gdi_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GDI_FILE_PROPERTY, games_gdi_properties[GAMES_GDI_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GDI_TRACKS_NUMBER_PROPERTY, games_gdi_properties[GAMES_GDI_TRACKS_NUMBER_PROPERTY] = g_param_spec_uint ("tracks-number", "tracks-number", "tracks-number", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
games_gdi_instance_init (GamesGdi * self,
                         gpointer klass)
{
	self->priv = games_gdi_get_instance_private (self);
	self->priv->parsed = FALSE;
}

static void
games_gdi_finalize (GObject * obj)
{
	GamesGdi * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GDI, GamesGdi);
	_g_object_unref0 (self->priv->_file);
	self->priv->tracks = (_vala_GamesGdiTrackNode_array_free (self->priv->tracks, self->priv->tracks_length1), NULL);
	G_OBJECT_CLASS (games_gdi_parent_class)->finalize (obj);
}

GType
games_gdi_get_type (void)
{
	return games_gdi_type_id;
}

GType
games_gdi_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGdiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gdi_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGdi), 0, (GInstanceInitFunc) games_gdi_instance_init, NULL };
	games_gdi_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesGdi", &g_define_type_info, 0);
	GamesGdi_private_offset = sizeof (GamesGdiPrivate);
	return games_gdi_type_id;
}

static void
_vala_games_gdi_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GamesGdi * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GDI, GamesGdi);
	switch (property_id) {
		case GAMES_GDI_FILE_PROPERTY:
		g_value_set_object (value, games_gdi_get_file (self));
		break;
		case GAMES_GDI_TRACKS_NUMBER_PROPERTY:
		g_value_set_uint (value, games_gdi_get_tracks_number (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_gdi_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GamesGdi * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GDI, GamesGdi);
	switch (property_id) {
		case GAMES_GDI_FILE_PROPERTY:
		games_gdi_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GQuark
games_gdi_error_quark (void)
{
	return g_quark_from_static_string ("games-gdi-error-quark");
}

static GType
games_gdi_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_GDI_ERROR_UNEXPECTED_TOKEN, "GAMES_GDI_ERROR_UNEXPECTED_TOKEN", "unexpected-token"}, {GAMES_GDI_ERROR_UNEXPECTED_EOL, "GAMES_GDI_ERROR_UNEXPECTED_EOL", "unexpected-eol"}, {GAMES_GDI_ERROR_UNEXPECTED_EOF, "GAMES_GDI_ERROR_UNEXPECTED_EOF", "unexpected-eof"}, {GAMES_GDI_ERROR_INVALID_TRACK_NUMBER, "GAMES_GDI_ERROR_INVALID_TRACK_NUMBER", "invalid-track-number"}, {GAMES_GDI_ERROR_INVALID_TRACK_MODE, "GAMES_GDI_ERROR_INVALID_TRACK_MODE", "invalid-track-mode"}, {GAMES_GDI_ERROR_NOT_A_TRACK, "GAMES_GDI_ERROR_NOT_A_TRACK", "not-a-track"}, {0, NULL, NULL}};
	GType games_gdi_error_type_id;
	games_gdi_error_type_id = g_enum_register_static ("GamesGdiError", values);
	return games_gdi_error_type_id;
}

GType
games_gdi_error_get_type (void)
{
	static volatile gsize games_gdi_error_type_id__once = 0;
	if (g_once_init_enter (&games_gdi_error_type_id__once)) {
		GType games_gdi_error_type_id;
		games_gdi_error_type_id = games_gdi_error_get_type_once ();
		g_once_init_leave (&games_gdi_error_type_id__once, games_gdi_error_type_id);
	}
	return games_gdi_error_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

