/* nintendo-ds-runner.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nintendo-ds-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <retro-gtk.h>
#include <gio/gio.h>
#include "linux/input-event-codes.h"
#include "games-nintendo-ds-plugin.h"

#define GAMES_NINTENDO_DS_RUNNER_SCREENS_LAYOUT_OPTION "desmume_screens_layout"
#define GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_OPTION "desmume_screens_gap"
#define GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_NONE "0"
#define GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_DEFAULT "80"
#define GAMES_NINTENDO_DS_RUNNER_HEADER_GAME_CODE_OFFSET ((gsize) 12)
#define GAMES_NINTENDO_DS_RUNNER_HEADER_GAME_CODE_SIZE ((gsize) 3)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_NINTENDO_DS_RUNNER (games_nintendo_ds_runner_get_type ())
#define GAMES_NINTENDO_DS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_NINTENDO_DS_RUNNER, GamesNintendoDsRunner))
#define GAMES_NINTENDO_DS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_NINTENDO_DS_RUNNER, GamesNintendoDsRunnerClass))
#define GAMES_IS_NINTENDO_DS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_NINTENDO_DS_RUNNER))
#define GAMES_IS_NINTENDO_DS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_NINTENDO_DS_RUNNER))
#define GAMES_NINTENDO_DS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_NINTENDO_DS_RUNNER, GamesNintendoDsRunnerClass))

typedef struct _GamesNintendoDsRunner GamesNintendoDsRunner;
typedef struct _GamesNintendoDsRunnerClass GamesNintendoDsRunnerClass;
typedef struct _GamesNintendoDsRunnerPrivate GamesNintendoDsRunnerPrivate;
enum  {
	GAMES_NINTENDO_DS_RUNNER_0_PROPERTY,
	GAMES_NINTENDO_DS_RUNNER_SCREEN_LAYOUT_PROPERTY,
	GAMES_NINTENDO_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY,
	GAMES_NINTENDO_DS_RUNNER_NUM_PROPERTIES
};
static GParamSpec* games_nintendo_ds_runner_properties[GAMES_NINTENDO_DS_RUNNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesNintendoDsRunner {
	GamesRetroRunner parent_instance;
	GamesNintendoDsRunnerPrivate * priv;
};

struct _GamesNintendoDsRunnerClass {
	GamesRetroRunnerClass parent_class;
};

struct _GamesNintendoDsRunnerPrivate {
	GamesScreenLayout _screen_layout;
	gboolean _view_bottom_screen;
};

static gint GamesNintendoDsRunner_private_offset;
static gpointer games_nintendo_ds_runner_parent_class = NULL;
static GHashTable* games_nintendo_ds_runner_layouts;
static GHashTable* games_nintendo_ds_runner_layouts = NULL;
static GHashTable* games_nintendo_ds_runner_gap_overrides;
static GHashTable* games_nintendo_ds_runner_gap_overrides = NULL;
static GType games_nintendo_ds_runner_type_id = 0;

GType games_nintendo_ds_runner_register_type (GTypeModule * module);
VALA_EXTERN GType games_nintendo_ds_runner_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesNintendoDsRunner* games_nintendo_ds_runner_new (GamesGame* game,
                                                     GamesRetroCoreSource* source);
VALA_EXTERN GamesNintendoDsRunner* games_nintendo_ds_runner_construct (GType object_type,
                                                           GamesGame* game,
                                                           GamesRetroCoreSource* source);
static gboolean games_nintendo_ds_runner_core_supports_layouts (GamesNintendoDsRunner* self);
static gchar* games_nintendo_ds_runner_get_screen_gap_width (GamesNintendoDsRunner* self);
static void games_nintendo_ds_runner_update_screen_layout (GamesNintendoDsRunner* self);
VALA_EXTERN gchar* games_nintendo_ds_layout_get_value (GamesScreenLayout layout);
VALA_EXTERN GamesScreenLayout games_nintendo_ds_runner_get_screen_layout (GamesNintendoDsRunner* self);
VALA_EXTERN gboolean games_nintendo_ds_runner_get_view_bottom_screen (GamesNintendoDsRunner* self);
static GamesHeaderBarWidget* games_nintendo_ds_runner_real_get_extra_widget (GamesRetroRunner* base);
static gboolean games_nintendo_ds_runner_real_key_press_event (GamesRetroRunner* base,
                                                        guint keyval,
                                                        GdkModifierType state);
static GamesScreenLayout* _games_screen_layout_dup (GamesScreenLayout* self);
VALA_EXTERN void games_nintendo_ds_runner_set_screen_layout (GamesNintendoDsRunner* self,
                                                 GamesScreenLayout value);
static gboolean games_nintendo_ds_runner_swap_screens (GamesNintendoDsRunner* self);
static gboolean games_nintendo_ds_runner_real_gamepad_button_press_event (GamesRetroRunner* base,
                                                                   guint16 button);
VALA_EXTERN void games_nintendo_ds_runner_set_view_bottom_screen (GamesNintendoDsRunner* self,
                                                      gboolean value);
static void games_nintendo_ds_runner_real_save_to_snapshot (GamesRetroRunner* base,
                                                     GamesSnapshot* snapshot,
                                                     GError** error);
static void games_nintendo_ds_runner_real_load_from_snapshot (GamesRetroRunner* base,
                                                       GamesSnapshot* snapshot,
                                                       GError** error);
static void games_nintendo_ds_runner_real_reset_with_snapshot (GamesRetroRunner* base,
                                                        GamesSnapshot* last_snapshot,
                                                        GError** error);
static void _g_free0_ (gpointer var);
static void games_nintendo_ds_runner_finalize (GObject * obj);
static void _vala_games_nintendo_ds_runner_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_games_nintendo_ds_runner_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
games_nintendo_ds_runner_get_instance_private (GamesNintendoDsRunner* self)
{
	return G_STRUCT_MEMBER_P (self, GamesNintendoDsRunner_private_offset);
}

GamesNintendoDsRunner*
games_nintendo_ds_runner_construct (GType object_type,
                                    GamesGame* game,
                                    GamesRetroCoreSource* source)
{
	GamesNintendoDsRunner * self = NULL;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (GamesNintendoDsRunner*) games_retro_runner_construct_from_source (object_type, game, source);
	return self;
}

GamesNintendoDsRunner*
games_nintendo_ds_runner_new (GamesGame* game,
                              GamesRetroCoreSource* source)
{
	return games_nintendo_ds_runner_construct (GAMES_TYPE_NINTENDO_DS_RUNNER, game, source);
}

static gboolean
games_nintendo_ds_runner_core_supports_layouts (GamesNintendoDsRunner* self)
{
	RetroCore* core = NULL;
	RetroCore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RetroCore* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_retro_runner_get_core ((GamesRetroRunner*) self);
	core = _tmp0_;
	_tmp3_ = core;
	if (_tmp3_ != NULL) {
		RetroCore* _tmp4_;
		_tmp4_ = core;
		_tmp2_ = retro_core_has_option (_tmp4_, GAMES_NINTENDO_DS_RUNNER_SCREENS_LAYOUT_OPTION);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		RetroCore* _tmp5_;
		_tmp5_ = core;
		_tmp1_ = retro_core_has_option (_tmp5_, GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_OPTION);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (core);
	return result;
}

static gchar*
games_nintendo_ds_runner_get_screen_gap_width (GamesNintendoDsRunner* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GamesMediaSet* _tmp0_;
		GamesMediaSet* _tmp1_;
		GamesMedia* _tmp2_ = NULL;
		GamesMediaSet* _tmp3_;
		GamesMediaSet* _tmp4_;
		GamesMedia* _tmp5_;
		GamesUri** uris = NULL;
		gint _tmp6_ = 0;
		GamesUri** _tmp7_;
		gint uris_length1;
		gint _uris_size_;
		GFile* file = NULL;
		GamesUri** _tmp8_;
		gint _tmp8__length1;
		GamesUri* _tmp9_;
		GFile* _tmp10_;
		GamesStringInputStream* stream = NULL;
		GFile* _tmp11_;
		GamesStringInputStream* _tmp12_;
		gchar* game_code = NULL;
		GamesStringInputStream* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GHashTable* _tmp16_;
		const gchar* _tmp17_;
		gconstpointer _tmp18_;
		gchar* _tmp19_;
		_tmp0_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp1_ = _tmp0_;
		_vala_assert (games_media_set_get_size (_tmp1_) == 1, "media_set.get_size () == 1");
		_tmp3_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = games_media_set_get_media (_tmp4_, (guint) 0, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = games_media_get_uris (_tmp2_, &_tmp6_);
		uris = _tmp7_;
		uris_length1 = _tmp6_;
		_uris_size_ = uris_length1;
		_tmp8_ = uris;
		_tmp8__length1 = uris_length1;
		_tmp9_ = _tmp8_[0];
		_tmp10_ = games_uri_to_file (_tmp9_);
		file = _tmp10_;
		_tmp11_ = file;
		_tmp12_ = games_string_input_stream_new (_tmp11_);
		stream = _tmp12_;
		_tmp13_ = stream;
		_tmp14_ = games_string_input_stream_read_string_for_size (_tmp13_, GAMES_NINTENDO_DS_RUNNER_HEADER_GAME_CODE_OFFSET, GAMES_NINTENDO_DS_RUNNER_HEADER_GAME_CODE_SIZE, &_inner_error0_);
		game_code = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (file);
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
			_g_object_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp16_ = games_nintendo_ds_runner_gap_overrides;
		_tmp17_ = game_code;
		_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
		_tmp15_ = (const gchar*) _tmp18_;
		if (_tmp15_ == NULL) {
			_tmp15_ = GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_DEFAULT;
		}
		_tmp19_ = g_strdup (_tmp15_);
		result = _tmp19_;
		_g_free0 (game_code);
		_g_object_unref0 (stream);
		_g_object_unref0 (file);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (_tmp2_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_critical ("nintendo-ds-runner.vala:89: Couldn't read the header: %s", _tmp21_);
		_tmp22_ = g_strdup (GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_DEFAULT);
		result = _tmp22_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_nintendo_ds_runner_update_screen_layout (GamesNintendoDsRunner* self)
{
	RetroCore* core = NULL;
	RetroCore* _tmp0_;
	RetroOption* screens_layout_option = NULL;
	RetroCore* _tmp1_;
	RetroOption* _tmp2_;
	RetroOption* _tmp3_;
	gchar* screens_layout_option_value = NULL;
	GamesScreenLayout _tmp4_;
	GamesScreenLayout _tmp5_;
	gchar* _tmp6_;
	GamesScreenLayout _tmp7_;
	GamesScreenLayout _tmp8_;
	RetroOption* screens_gap_option = NULL;
	RetroCore* _tmp13_;
	RetroOption* _tmp14_;
	RetroOption* _tmp15_;
	gchar* screens_gap = NULL;
	GamesScreenLayout _tmp16_;
	GamesScreenLayout _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!games_nintendo_ds_runner_core_supports_layouts (self)) {
		return;
	}
	_tmp0_ = games_retro_runner_get_core ((GamesRetroRunner*) self);
	core = _tmp0_;
	_tmp1_ = core;
	_tmp2_ = retro_core_get_option (_tmp1_, GAMES_NINTENDO_DS_RUNNER_SCREENS_LAYOUT_OPTION);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	screens_layout_option = _tmp3_;
	_tmp4_ = games_nintendo_ds_runner_get_screen_layout (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_nintendo_ds_layout_get_value (_tmp5_);
	screens_layout_option_value = _tmp6_;
	_tmp7_ = games_nintendo_ds_runner_get_screen_layout (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == GAMES_SCREEN_LAYOUT_QUICK_SWITCH) {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_;
		gboolean _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = games_nintendo_ds_runner_get_view_bottom_screen (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			_tmp9_ = "bottom only";
		} else {
			_tmp9_ = "top only";
		}
		_tmp12_ = g_strdup (_tmp9_);
		_g_free0 (screens_layout_option_value);
		screens_layout_option_value = _tmp12_;
	}
	_tmp13_ = core;
	_tmp14_ = retro_core_get_option (_tmp13_, GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_OPTION);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	screens_gap_option = _tmp15_;
	_tmp16_ = games_nintendo_ds_runner_get_screen_layout (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == GAMES_SCREEN_LAYOUT_TOP_BOTTOM) {
		gchar* _tmp18_;
		_tmp18_ = games_nintendo_ds_runner_get_screen_gap_width (self);
		_g_free0 (screens_gap);
		screens_gap = _tmp18_;
	} else {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (GAMES_NINTENDO_DS_RUNNER_SCREENS_GAP_NONE);
		_g_free0 (screens_gap);
		screens_gap = _tmp19_;
	}
	{
		RetroOption* _tmp20_;
		const gchar* _tmp21_;
		RetroOption* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = screens_layout_option;
		_tmp21_ = screens_layout_option_value;
		retro_option_set_value (_tmp20_, _tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp22_ = screens_gap_option;
		_tmp23_ = screens_gap;
		retro_option_set_value (_tmp22_, _tmp23_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_critical ("nintendo-ds-runner.vala:118: Failed to set desmume option: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (screens_gap);
		_g_object_unref0 (screens_gap_option);
		_g_free0 (screens_layout_option_value);
		_g_object_unref0 (screens_layout_option);
		_g_object_unref0 (core);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (screens_gap);
	_g_object_unref0 (screens_gap_option);
	_g_free0 (screens_layout_option_value);
	_g_object_unref0 (screens_layout_option);
	_g_object_unref0 (core);
}

static GamesHeaderBarWidget*
games_nintendo_ds_runner_real_get_extra_widget (GamesRetroRunner* base)
{
	GamesNintendoDsRunner * self;
	GamesScreenLayoutSwitcher* switcher = NULL;
	GamesScreenLayoutSwitcher* _tmp0_;
	GamesScreenLayoutSwitcher* _tmp1_;
	GamesScreenLayoutSwitcher* _tmp2_;
	GamesHeaderBarWidget* result;
	self = (GamesNintendoDsRunner*) base;
	if (!games_nintendo_ds_runner_core_supports_layouts (self)) {
		result = NULL;
		return result;
	}
	_tmp0_ = games_screen_layout_switcher_new ();
	g_object_ref_sink (_tmp0_);
	switcher = _tmp0_;
	_tmp1_ = switcher;
	g_object_bind_property_with_closures ((GObject*) self, "screen-layout", (GObject*) _tmp1_, "screen-layout", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = switcher;
	g_object_bind_property_with_closures ((GObject*) self, "view-bottom-screen", (GObject*) _tmp2_, "view-bottom-screen", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = (GamesHeaderBarWidget*) switcher;
	return result;
}

static GamesScreenLayout*
_games_screen_layout_dup (GamesScreenLayout* self)
{
	GamesScreenLayout* dup;
	dup = g_new0 (GamesScreenLayout, 1);
	memcpy (dup, self, sizeof (GamesScreenLayout));
	return dup;
}

static gpointer
__games_screen_layout_dup0 (gpointer self)
{
	return self ? _games_screen_layout_dup (self) : NULL;
}

static gboolean
games_nintendo_ds_runner_real_key_press_event (GamesRetroRunner* base,
                                               guint keyval,
                                               GdkModifierType state)
{
	GamesNintendoDsRunner * self;
	GamesScreenLayout _tmp5_;
	GamesScreenLayout _tmp6_;
	guint _tmp7_ = 0U;
	gboolean _tmp8_;
	gboolean _tmp9_;
	guint switch_keyval = 0U;
	gboolean result;
	self = (GamesNintendoDsRunner*) base;
	if (state == GDK_MOD1_MASK) {
		GamesScreenLayout* shortcut_layout = NULL;
		GHashTable* _tmp0_;
		gconstpointer _tmp1_;
		GamesScreenLayout* _tmp2_;
		GamesScreenLayout* _tmp3_;
		_tmp0_ = games_nintendo_ds_runner_layouts;
		_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) keyval));
		_tmp2_ = __games_screen_layout_dup0 ((GamesScreenLayout*) _tmp1_);
		shortcut_layout = _tmp2_;
		_tmp3_ = shortcut_layout;
		if (_tmp3_ != NULL) {
			GamesScreenLayout* _tmp4_;
			_tmp4_ = shortcut_layout;
			games_nintendo_ds_runner_set_screen_layout (self, *_tmp4_);
			result = TRUE;
			_g_free0 (shortcut_layout);
			return result;
		}
		_g_free0 (shortcut_layout);
	}
	_tmp5_ = games_nintendo_ds_runner_get_screen_layout (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != GAMES_SCREEN_LAYOUT_QUICK_SWITCH) {
		result = FALSE;
		return result;
	}
	_tmp8_ = games_nintendo_ds_runner_get_view_bottom_screen (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp7_ = GDK_KEY_Page_Up;
	} else {
		_tmp7_ = GDK_KEY_Page_Down;
	}
	switch_keyval = _tmp7_;
	if (keyval == switch_keyval) {
		result = games_nintendo_ds_runner_swap_screens (self);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
games_nintendo_ds_runner_real_gamepad_button_press_event (GamesRetroRunner* base,
                                                          guint16 button)
{
	GamesNintendoDsRunner * self;
	gboolean result;
	self = (GamesNintendoDsRunner*) base;
	if (button == BTN_THUMBR) {
		result = games_nintendo_ds_runner_swap_screens (self);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
games_nintendo_ds_runner_swap_screens (GamesNintendoDsRunner* self)
{
	GamesScreenLayout _tmp0_;
	GamesScreenLayout _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_nintendo_ds_runner_get_screen_layout (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != GAMES_SCREEN_LAYOUT_QUICK_SWITCH) {
		result = FALSE;
		return result;
	}
	_tmp2_ = games_nintendo_ds_runner_get_view_bottom_screen (self);
	_tmp3_ = _tmp2_;
	games_nintendo_ds_runner_set_view_bottom_screen (self, !_tmp3_);
	result = TRUE;
	return result;
}

static void
games_nintendo_ds_runner_real_save_to_snapshot (GamesRetroRunner* base,
                                                GamesSnapshot* snapshot,
                                                GError** error)
{
	GamesNintendoDsRunner * self;
	GamesNintendoDsSnapshot* ds_snapshot = NULL;
	GamesNintendoDsSnapshot* _tmp0_;
	GamesNintendoDsSnapshot* _tmp1_;
	GamesScreenLayout _tmp2_;
	GamesScreenLayout _tmp3_;
	GamesNintendoDsSnapshot* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (GamesNintendoDsRunner*) base;
	g_return_if_fail (snapshot != NULL);
	GAMES_RETRO_RUNNER_CLASS (games_nintendo_ds_runner_parent_class)->save_to_snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner), snapshot, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_vala_assert (GAMES_IS_NINTENDO_DS_SNAPSHOT (snapshot), "snapshot is NintendoDsSnapshot");
	_tmp0_ = _g_object_ref0 (GAMES_IS_NINTENDO_DS_SNAPSHOT (snapshot) ? ((GamesNintendoDsSnapshot*) snapshot) : NULL);
	ds_snapshot = _tmp0_;
	_tmp1_ = ds_snapshot;
	_tmp2_ = games_nintendo_ds_runner_get_screen_layout (self);
	_tmp3_ = _tmp2_;
	games_nintendo_ds_snapshot_set_screen_layout (_tmp1_, _tmp3_);
	_tmp4_ = ds_snapshot;
	_tmp5_ = games_nintendo_ds_runner_get_view_bottom_screen (self);
	_tmp6_ = _tmp5_;
	games_nintendo_ds_snapshot_set_view_bottom_screen (_tmp4_, _tmp6_);
	_g_object_unref0 (ds_snapshot);
}

static void
games_nintendo_ds_runner_real_load_from_snapshot (GamesRetroRunner* base,
                                                  GamesSnapshot* snapshot,
                                                  GError** error)
{
	GamesNintendoDsRunner * self;
	GamesNintendoDsSnapshot* ds_snapshot = NULL;
	GamesNintendoDsSnapshot* _tmp0_;
	GamesNintendoDsSnapshot* _tmp1_;
	GamesScreenLayout _tmp2_;
	GamesScreenLayout _tmp3_;
	GamesNintendoDsSnapshot* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (GamesNintendoDsRunner*) base;
	g_return_if_fail (snapshot != NULL);
	GAMES_RETRO_RUNNER_CLASS (games_nintendo_ds_runner_parent_class)->load_from_snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner), snapshot, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_vala_assert (GAMES_IS_NINTENDO_DS_SNAPSHOT (snapshot), "snapshot is NintendoDsSnapshot");
	_tmp0_ = _g_object_ref0 (GAMES_IS_NINTENDO_DS_SNAPSHOT (snapshot) ? ((GamesNintendoDsSnapshot*) snapshot) : NULL);
	ds_snapshot = _tmp0_;
	_tmp1_ = ds_snapshot;
	_tmp2_ = games_nintendo_ds_snapshot_get_screen_layout (_tmp1_);
	_tmp3_ = _tmp2_;
	games_nintendo_ds_runner_set_screen_layout (self, _tmp3_);
	_tmp4_ = ds_snapshot;
	_tmp5_ = games_nintendo_ds_snapshot_get_view_bottom_screen (_tmp4_);
	_tmp6_ = _tmp5_;
	games_nintendo_ds_runner_set_view_bottom_screen (self, _tmp6_);
	_g_object_unref0 (ds_snapshot);
}

static void
games_nintendo_ds_runner_real_reset_with_snapshot (GamesRetroRunner* base,
                                                   GamesSnapshot* last_snapshot,
                                                   GError** error)
{
	GamesNintendoDsRunner * self;
	GError* _inner_error0_ = NULL;
	self = (GamesNintendoDsRunner*) base;
	GAMES_RETRO_RUNNER_CLASS (games_nintendo_ds_runner_parent_class)->reset_with_snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner), last_snapshot, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	games_nintendo_ds_runner_set_screen_layout (self, GAMES_SCREEN_LAYOUT_TOP_BOTTOM);
	games_nintendo_ds_runner_set_view_bottom_screen (self, FALSE);
}

GamesScreenLayout
games_nintendo_ds_runner_get_screen_layout (GamesNintendoDsRunner* self)
{
	GamesScreenLayout result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_screen_layout;
	return result;
}

void
games_nintendo_ds_runner_set_screen_layout (GamesNintendoDsRunner* self,
                                            GamesScreenLayout value)
{
	g_return_if_fail (self != NULL);
	self->priv->_screen_layout = value;
	games_nintendo_ds_runner_update_screen_layout (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo_ds_runner_properties[GAMES_NINTENDO_DS_RUNNER_SCREEN_LAYOUT_PROPERTY]);
}

gboolean
games_nintendo_ds_runner_get_view_bottom_screen (GamesNintendoDsRunner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_view_bottom_screen;
	return result;
}

void
games_nintendo_ds_runner_set_view_bottom_screen (GamesNintendoDsRunner* self,
                                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_view_bottom_screen = value;
	games_nintendo_ds_runner_update_screen_layout (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo_ds_runner_properties[GAMES_NINTENDO_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY]);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
games_nintendo_ds_runner_class_init (GamesNintendoDsRunnerClass * klass,
                                     gpointer klass_data)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GamesScreenLayout _tmp4_;
	GamesScreenLayout* _tmp5_;
	GHashTable* _tmp6_;
	GamesScreenLayout _tmp7_;
	GamesScreenLayout* _tmp8_;
	GHashTable* _tmp9_;
	GamesScreenLayout _tmp10_;
	GamesScreenLayout* _tmp11_;
	GHashTable* _tmp12_;
	GamesScreenLayout _tmp13_;
	GamesScreenLayout* _tmp14_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	GError* _inner_error0_ = NULL;
	games_nintendo_ds_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesNintendoDsRunner_private_offset);
	((GamesRetroRunnerClass *) klass)->get_extra_widget = (GamesHeaderBarWidget* (*) (GamesRetroRunner*)) games_nintendo_ds_runner_real_get_extra_widget;
	((GamesRetroRunnerClass *) klass)->key_press_event = (gboolean (*) (GamesRetroRunner*, guint, GdkModifierType)) games_nintendo_ds_runner_real_key_press_event;
	((GamesRetroRunnerClass *) klass)->gamepad_button_press_event = (gboolean (*) (GamesRetroRunner*, guint16)) games_nintendo_ds_runner_real_gamepad_button_press_event;
	((GamesRetroRunnerClass *) klass)->save_to_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_nintendo_ds_runner_real_save_to_snapshot;
	((GamesRetroRunnerClass *) klass)->load_from_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_nintendo_ds_runner_real_load_from_snapshot;
	((GamesRetroRunnerClass *) klass)->reset_with_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_nintendo_ds_runner_real_reset_with_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_nintendo_ds_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_nintendo_ds_runner_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_nintendo_ds_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO_DS_RUNNER_SCREEN_LAYOUT_PROPERTY, games_nintendo_ds_runner_properties[GAMES_NINTENDO_DS_RUNNER_SCREEN_LAYOUT_PROPERTY] = g_param_spec_enum ("screen-layout", "screen-layout", "screen-layout", GAMES_TYPE_SCREEN_LAYOUT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY, games_nintendo_ds_runner_properties[GAMES_NINTENDO_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY] = g_param_spec_boolean ("view-bottom-screen", "view-bottom-screen", "view-bottom-screen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	_g_hash_table_unref0 (games_nintendo_ds_runner_layouts);
	games_nintendo_ds_runner_layouts = _tmp2_;
	_tmp3_ = games_nintendo_ds_runner_layouts;
	_tmp4_ = GAMES_SCREEN_LAYOUT_TOP_BOTTOM;
	_tmp5_ = __games_screen_layout_dup0 (&_tmp4_);
	g_hash_table_insert (_tmp3_, (gpointer) ((guintptr) GDK_KEY_1), (gpointer) ((gintptr) _tmp5_));
	_tmp6_ = games_nintendo_ds_runner_layouts;
	_tmp7_ = GAMES_SCREEN_LAYOUT_LEFT_RIGHT;
	_tmp8_ = __games_screen_layout_dup0 (&_tmp7_);
	g_hash_table_insert (_tmp6_, (gpointer) ((guintptr) GDK_KEY_2), (gpointer) ((gintptr) _tmp8_));
	_tmp9_ = games_nintendo_ds_runner_layouts;
	_tmp10_ = GAMES_SCREEN_LAYOUT_RIGHT_LEFT;
	_tmp11_ = __games_screen_layout_dup0 (&_tmp10_);
	g_hash_table_insert (_tmp9_, (gpointer) ((guintptr) GDK_KEY_3), (gpointer) ((gintptr) _tmp11_));
	_tmp12_ = games_nintendo_ds_runner_layouts;
	_tmp13_ = GAMES_SCREEN_LAYOUT_QUICK_SWITCH;
	_tmp14_ = __games_screen_layout_dup0 (&_tmp13_);
	g_hash_table_insert (_tmp12_, (gpointer) ((guintptr) GDK_KEY_4), (gpointer) ((gintptr) _tmp14_));
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (games_nintendo_ds_runner_gap_overrides);
	games_nintendo_ds_runner_gap_overrides = _tmp17_;
	{
		GBytes* bytes = NULL;
		GBytes* _tmp18_;
		gchar* text = NULL;
		GBytes* _tmp19_;
		gsize _tmp20_ = 0;
		guint8* _tmp21_;
		gchar* _tmp22_;
		gchar** lines = NULL;
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gint lines_length1;
		gint _lines_size_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		_tmp18_ = g_resources_lookup_data ("/org/gnome/Games/plugins/nintendo-ds/layout-overrides", G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		bytes = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = bytes;
		_tmp21_ = g_bytes_get_data (_tmp19_, &_tmp20_);
		_tmp22_ = g_strdup ((const gchar*) _tmp21_);
		text = _tmp22_;
		_tmp23_ = text;
		_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "\n", 0);
		lines = _tmp25_;
		lines_length1 = _vala_array_length (_tmp24_);
		_lines_size_ = lines_length1;
		_tmp26_ = lines;
		_tmp26__length1 = lines_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp26_;
			line_collection_length1 = _tmp26__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp27_;
				gchar* line = NULL;
				_tmp27_ = g_strdup (line_collection[line_it]);
				line = _tmp27_;
				{
					gchar** data = NULL;
					const gchar* _tmp28_;
					gchar** _tmp29_;
					gchar** _tmp30_;
					gint data_length1;
					gint _data_size_;
					gchar** _tmp31_;
					gint _tmp31__length1;
					gchar** fields = NULL;
					gchar** _tmp32_;
					gint _tmp32__length1;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar** _tmp36_;
					gchar** _tmp37_;
					gchar** _tmp38_;
					gint _tmp38__length1;
					gint fields_length1;
					gint _fields_size_;
					gchar** _tmp39_;
					gint _tmp39__length1;
					gchar* key = NULL;
					gchar** _tmp40_;
					gint _tmp40__length1;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* value = NULL;
					gchar** _tmp43_;
					gint _tmp43__length1;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					GHashTable* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_;
					_tmp28_ = line;
					_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, "#", 2);
					data = _tmp30_;
					data_length1 = _vala_array_length (_tmp29_);
					_data_size_ = data_length1;
					_tmp31_ = data;
					_tmp31__length1 = data_length1;
					if (_tmp31__length1 < 2) {
						data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						continue;
					}
					_tmp32_ = data;
					_tmp32__length1 = data_length1;
					_tmp33_ = _tmp32_[0];
					_tmp34_ = string_strip (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, " ", 2);
					_tmp38_ = _tmp37_;
					_tmp38__length1 = _vala_array_length (_tmp36_);
					_g_free0 (_tmp35_);
					fields = _tmp38_;
					fields_length1 = _tmp38__length1;
					_fields_size_ = fields_length1;
					_tmp39_ = fields;
					_tmp39__length1 = fields_length1;
					if (_tmp39__length1 < 2) {
						fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
						data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						continue;
					}
					_tmp40_ = fields;
					_tmp40__length1 = fields_length1;
					_tmp41_ = _tmp40_[0];
					_tmp42_ = g_strdup (_tmp41_);
					key = _tmp42_;
					_tmp43_ = fields;
					_tmp43__length1 = fields_length1;
					_tmp44_ = _tmp43_[1];
					_tmp45_ = g_strdup (_tmp44_);
					value = _tmp45_;
					_tmp46_ = games_nintendo_ds_runner_gap_overrides;
					_tmp47_ = key;
					_tmp48_ = g_strdup (_tmp47_);
					_tmp49_ = value;
					_tmp50_ = g_strdup (_tmp49_);
					g_hash_table_insert (_tmp46_, _tmp48_, _tmp50_);
					_g_free0 (value);
					_g_free0 (key);
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
				}
			}
		}
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (text);
		_g_bytes_unref0 (bytes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		g_critical ("nintendo-ds-runner.vala:64: Couldn't read layout overrides: %s", _tmp52_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
games_nintendo_ds_runner_instance_init (GamesNintendoDsRunner * self,
                                        gpointer klass)
{
	self->priv = games_nintendo_ds_runner_get_instance_private (self);
}

static void
games_nintendo_ds_runner_finalize (GObject * obj)
{
	GamesNintendoDsRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_NINTENDO_DS_RUNNER, GamesNintendoDsRunner);
	G_OBJECT_CLASS (games_nintendo_ds_runner_parent_class)->finalize (obj);
}

GType
games_nintendo_ds_runner_get_type (void)
{
	return games_nintendo_ds_runner_type_id;
}

GType
games_nintendo_ds_runner_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesNintendoDsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_nintendo_ds_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesNintendoDsRunner), 0, (GInstanceInitFunc) games_nintendo_ds_runner_instance_init, NULL };
	games_nintendo_ds_runner_type_id = g_type_module_register_type (module, GAMES_TYPE_RETRO_RUNNER, "GamesNintendoDsRunner", &g_define_type_info, 0);
	GamesNintendoDsRunner_private_offset = sizeof (GamesNintendoDsRunnerPrivate);
	return games_nintendo_ds_runner_type_id;
}

static void
_vala_games_nintendo_ds_runner_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GamesNintendoDsRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_NINTENDO_DS_RUNNER, GamesNintendoDsRunner);
	switch (property_id) {
		case GAMES_NINTENDO_DS_RUNNER_SCREEN_LAYOUT_PROPERTY:
		g_value_set_enum (value, games_nintendo_ds_runner_get_screen_layout (self));
		break;
		case GAMES_NINTENDO_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY:
		g_value_set_boolean (value, games_nintendo_ds_runner_get_view_bottom_screen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_nintendo_ds_runner_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GamesNintendoDsRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_NINTENDO_DS_RUNNER, GamesNintendoDsRunner);
	switch (property_id) {
		case GAMES_NINTENDO_DS_RUNNER_SCREEN_LAYOUT_PROPERTY:
		games_nintendo_ds_runner_set_screen_layout (self, g_value_get_enum (value));
		break;
		case GAMES_NINTENDO_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY:
		games_nintendo_ds_runner_set_view_bottom_screen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

