/* cue-sheet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from cue-sheet.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#define GAMES_CUE_SHEET_NEW_LINE "\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_CUE_SHEET_0_PROPERTY,
	GAMES_CUE_SHEET_FILE_PROPERTY,
	GAMES_CUE_SHEET_TRACKS_NUMBER_PROPERTY,
	GAMES_CUE_SHEET_NUM_PROPERTIES
};
static GParamSpec* games_cue_sheet_properties[GAMES_CUE_SHEET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_CUE_SHEET_ERROR (games_cue_sheet_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _GamesCueSheetPrivate {
	GFile* _file;
	GamesCueSheetTrackNode** tracks;
	gint tracks_length1;
	gint _tracks_size_;
};

typedef enum  {
	GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN,
	GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOL,
	GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOF,
	GAMES_CUE_SHEET_ERROR_INVALID_FILE_FORMAT,
	GAMES_CUE_SHEET_ERROR_INVALID_TRACK_NUMBER,
	GAMES_CUE_SHEET_ERROR_INVALID_TRACK_MODE,
	GAMES_CUE_SHEET_ERROR_NOT_A_TRACK
} GamesCueSheetError;
#define GAMES_CUE_SHEET_ERROR games_cue_sheet_error_quark ()

static gint GamesCueSheet_private_offset;
static gpointer games_cue_sheet_parent_class = NULL;
static GRegex* games_cue_sheet_token_regex;
static GRegex* games_cue_sheet_token_regex = NULL;

static void games_cue_sheet_parse (GamesCueSheet* self,
                            GError** error);
VALA_EXTERN GQuark games_cue_sheet_error_quark (void);
VALA_EXTERN GType games_cue_sheet_error_get_type (void) G_GNUC_CONST ;
static gchar** games_cue_sheet_tokenize (GamesCueSheet* self,
                                  gint* result_length1,
                                  GError** error);
static gchar** games_cue_sheet_tokenize_line (const gchar* line,
                                       gint* result_length1);
static void _vala_array_add42 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add43 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add44 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add45 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static GamesCueSheetFileNode* games_cue_sheet_parse_file_line (GamesCueSheet* self,
                                                        gchar*** tokens,
                                                        gint* tokens_length1,
                                                        gsize* i,
                                                        gsize line,
                                                        GError** error);
static GamesCueSheetTrackNode* games_cue_sheet_parse_track_line (GamesCueSheet* self,
                                                          gchar*** tokens,
                                                          gint* tokens_length1,
                                                          gsize* i,
                                                          gsize line,
                                                          GamesCueSheetFileNode* parent_file,
                                                          GError** error);
static void _vala_array_add46 (GamesCueSheetTrackNode** * array,
                        gint* length,
                        gint* size,
                        GamesCueSheetTrackNode* value);
static void games_cue_sheet_is_token (GamesCueSheet* self,
                               const gchar* expected_token,
                               gchar*** tokens,
                               gint* tokens_length1,
                               gsize* i,
                               gsize line,
                               GError** error);
static gchar* games_cue_sheet_get_token (GamesCueSheet* self,
                                  gchar*** tokens,
                                  gint* tokens_length1,
                                  gsize* i,
                                  gsize line,
                                  GError** error);
static gchar* games_cue_sheet_get_optional_token (GamesCueSheet* self,
                                           gchar*** tokens,
                                           gint* tokens_length1,
                                           gsize* i,
                                           gsize line);
static void games_cue_sheet_is_end_of_line (GamesCueSheet* self,
                                     gchar*** tokens,
                                     gint* tokens_length1,
                                     gsize* i,
                                     gsize line,
                                     GError** error);
static void games_cue_sheet_finalize (GObject * obj);
static GType games_cue_sheet_get_type_once (void);
static void _vala_games_cue_sheet_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
games_cue_sheet_get_instance_private (GamesCueSheet* self)
{
	return G_STRUCT_MEMBER_P (self, GamesCueSheet_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesCueSheet*
games_cue_sheet_construct (GType object_type,
                           GFile* file,
                           GError** error)
{
	GamesCueSheet * self = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesCueSheet*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
	games_cue_sheet_parse (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

GamesCueSheet*
games_cue_sheet_new (GFile* file,
                     GError** error)
{
	return games_cue_sheet_construct (GAMES_TYPE_CUE_SHEET, file, error);
}

GamesCueSheetTrackNode*
games_cue_sheet_get_track (GamesCueSheet* self,
                           guint i,
                           GError** error)
{
	GamesCueSheetTrackNode** _tmp0_;
	gint _tmp0__length1;
	GamesCueSheetTrackNode** _tmp7_;
	gint _tmp7__length1;
	GamesCueSheetTrackNode* _tmp8_;
	GamesCueSheetTrackNode* _tmp9_;
	GError* _inner_error0_ = NULL;
	GamesCueSheetTrackNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tracks;
	_tmp0__length1 = self->priv->tracks_length1;
	if (i >= ((guint) _tmp0__length1)) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp1_ = games_cue_sheet_get_file (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_NOT_A_TRACK, "“%s” doesn’t have a track for index %u.", _tmp4_, i);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = self->priv->tracks;
	_tmp7__length1 = self->priv->tracks_length1;
	_tmp8_ = _tmp7_[i];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	result = _tmp9_;
	return result;
}

static void
_vala_array_add42 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
games_cue_sheet_tokenize (GamesCueSheet* self,
                          gint* result_length1,
                          GError** error)
{
	GInputStream* stream = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GInputStream* _tmp2_;
	GDataInputStream* data_stream = NULL;
	GInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar** tokens = NULL;
	gchar** _tmp5_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar* line = NULL;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_cue_sheet_get_file (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_unicode_read (_tmp1_, GAMES_UNICODE_ENCODING_UTF_8, &_inner_error0_);
	stream = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = stream;
	_tmp4_ = g_data_input_stream_new (_tmp3_);
	data_stream = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	tokens = _tmp5_;
	tokens_length1 = 0;
	_tokens_size_ = tokens_length1;
	while (TRUE) {
		gchar* _tmp6_ = NULL;
		GDataInputStream* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		gchar** _tmp13_;
		_tmp7_ = data_stream;
		_tmp8_ = g_data_input_stream_read_line_utf8 (_tmp7_, NULL, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data_stream);
			_g_object_unref0 (stream);
			return NULL;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (line);
		line = _tmp9_;
		_tmp10_ = line;
		if (!(_tmp10_ != NULL)) {
			_g_free0 (_tmp6_);
			break;
		}
		_tmp11_ = line;
		_tmp13_ = games_cue_sheet_tokenize_line (_tmp11_, &_tmp12_);
		{
			gchar** token_collection = NULL;
			gint token_collection_length1 = 0;
			gint _token_collection_size_ = 0;
			gint token_it = 0;
			token_collection = _tmp13_;
			token_collection_length1 = _tmp12_;
			for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
				gchar* _tmp14_;
				gchar* token = NULL;
				_tmp14_ = g_strdup (token_collection[token_it]);
				token = _tmp14_;
				{
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = token;
					_tmp16_ = g_strdup (_tmp15_);
					_vala_array_add42 (&tokens, &tokens_length1, &_tokens_size_, _tmp16_);
					_g_free0 (token);
				}
			}
			token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (_tmp6_);
	}
	_tmp17_ = tokens;
	_tmp17__length1 = tokens_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_free0 (line);
	_g_object_unref0 (data_stream);
	_g_object_unref0 (stream);
	return result;
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
_vala_array_add43 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add44 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add45 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
games_cue_sheet_tokenize_line (const gchar* line,
                               gint* result_length1)
{
	GRegex* _tmp0_;
	gchar** tokens = NULL;
	gchar** _tmp2_;
	gint tokens_length1;
	gint _tokens_size_;
	GRegex* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gboolean _tmp14_ = FALSE;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** result;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = games_cue_sheet_token_regex;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\s*([^\"\\s]+)|(\".+?\")\\s*", 0));
		_g_regex_unref0 (games_cue_sheet_token_regex);
		games_cue_sheet_token_regex = _tmp1_;
	}
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	tokens = _tmp2_;
	tokens_length1 = 0;
	_tokens_size_ = tokens_length1;
	_tmp3_ = games_cue_sheet_token_regex;
	_tmp5_ = _tmp4_ = g_regex_split (_tmp3_, line, 0);
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp5_;
		token_collection_length1 = _vala_array_length (_tmp4_);
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp6_;
			gchar* token = NULL;
			_tmp6_ = g_strdup (token_collection[token_it]);
			token = _tmp6_;
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				static GQuark _tmp9_label2 = 0;
				static GQuark _tmp9_label3 = 0;
				_tmp7_ = token;
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if ((_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("\r")))) || (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("\r\n"))))) {
					switch (0) {
						default:
						{
							gchar* _tmp11_;
							_tmp11_ = g_strdup (GAMES_CUE_SHEET_NEW_LINE);
							_vala_array_add43 (&tokens, &tokens_length1, &_tokens_size_, _tmp11_);
							break;
						}
					}
				} else if ((_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("")))) || (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string (" "))))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp12_ = token;
							_tmp13_ = g_strdup (_tmp12_);
							_vala_array_add44 (&tokens, &tokens_length1, &_tokens_size_, _tmp13_);
							break;
						}
					}
				}
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp15_ = tokens;
	_tmp15__length1 = tokens_length1;
	if (_tmp15__length1 != 0) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		_tmp16_ = tokens;
		_tmp16__length1 = tokens_length1;
		_tmp17_ = tokens;
		_tmp17__length1 = tokens_length1;
		_tmp18_ = _tmp16_[_tmp17__length1 - 1];
		_tmp14_ = g_strcmp0 (_tmp18_, GAMES_CUE_SHEET_NEW_LINE) != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (GAMES_CUE_SHEET_NEW_LINE);
		_vala_array_add45 (&tokens, &tokens_length1, &_tokens_size_, _tmp19_);
	}
	_tmp20_ = tokens;
	_tmp20__length1 = tokens_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}

static void
_vala_array_add46 (GamesCueSheetTrackNode** * array,
                   gint* length,
                   gint* size,
                   GamesCueSheetTrackNode* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesCueSheetTrackNode*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
games_cue_sheet_parse (GamesCueSheet* self,
                       GError** error)
{
	gchar** tokens = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	GamesCueSheetFileNode* latest_file = NULL;
	gsize line = 0UL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = games_cue_sheet_tokenize (self, &_tmp0_, &_inner_error0_);
	tokens = _tmp1_;
	tokens_length1 = _tmp0_;
	_tokens_size_ = tokens_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	latest_file = NULL;
	line = (gsize) 1;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				if (!_tmp2_) {
					gsize _tmp3_;
					_tmp3_ = line;
					line = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = tokens;
				_tmp4__length1 = tokens_length1;
				if (!(i < ((gsize) _tmp4__length1))) {
					break;
				}
				_tmp5_ = tokens;
				_tmp5__length1 = tokens_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("FILE")))) {
					switch (0) {
						default:
						{
							GamesCueSheetFileNode* _tmp10_ = NULL;
							GamesCueSheetFileNode* _tmp11_;
							GamesCueSheetFileNode* _tmp12_;
							_tmp11_ = games_cue_sheet_parse_file_line (self, &tokens, (gint*) (&tokens_length1), &i, line, &_inner_error0_);
							_tokens_size_ = tokens_length1;
							_tmp10_ = _tmp11_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (latest_file);
								tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_tmp12_ = _tmp10_;
							_tmp10_ = NULL;
							_g_object_unref0 (latest_file);
							latest_file = _tmp12_;
							_g_object_unref0 (_tmp10_);
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("TRACK")))) {
					switch (0) {
						default:
						{
							GamesCueSheetTrackNode* _tmp13_ = NULL;
							GamesCueSheetFileNode* _tmp14_;
							GamesCueSheetTrackNode* _tmp15_;
							GamesCueSheetTrackNode* _tmp16_;
							_tmp14_ = latest_file;
							_tmp15_ = games_cue_sheet_parse_track_line (self, &tokens, (gint*) (&tokens_length1), &i, line, _tmp14_, &_inner_error0_);
							_tokens_size_ = tokens_length1;
							_tmp13_ = _tmp15_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (latest_file);
								tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_tmp16_ = _tmp13_;
							_tmp13_ = NULL;
							_vala_array_add46 (&self->priv->tracks, &self->priv->tracks_length1, &self->priv->_tracks_size_, _tmp16_);
							_g_object_unref0 (_tmp13_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gsize _tmp22_;
							while (TRUE) {
								gboolean _tmp17_ = FALSE;
								gchar** _tmp18_;
								gint _tmp18__length1;
								gsize _tmp21_;
								_tmp18_ = tokens;
								_tmp18__length1 = tokens_length1;
								if (i < ((gsize) _tmp18__length1)) {
									gchar** _tmp19_;
									gint _tmp19__length1;
									const gchar* _tmp20_;
									_tmp19_ = tokens;
									_tmp19__length1 = tokens_length1;
									_tmp20_ = _tmp19_[i];
									_tmp17_ = g_strcmp0 (_tmp20_, GAMES_CUE_SHEET_NEW_LINE) != 0;
								} else {
									_tmp17_ = FALSE;
								}
								if (!_tmp17_) {
									break;
								}
								_tmp21_ = i;
								i = _tmp21_ + 1;
							}
							_tmp22_ = i;
							i = _tmp22_ + 1;
							break;
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (latest_file);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static GamesCueSheetFileNode*
games_cue_sheet_parse_file_line (GamesCueSheet* self,
                                 gchar*** tokens,
                                 gint* tokens_length1,
                                 gsize* i,
                                 gsize line,
                                 GError** error)
{
	gchar* file_name = NULL;
	gchar* _tmp0_;
	gchar* file_format_string = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GFile* dir = NULL;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* child_file = NULL;
	GFile* _tmp17_;
	const gchar* _tmp18_;
	GFile* _tmp19_;
	GamesCueSheetFileFormat file_format = 0;
	const gchar* _tmp20_;
	GFile* _tmp28_;
	GamesCueSheetFileNode* _tmp29_;
	GError* _inner_error0_ = NULL;
	GamesCueSheetFileNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	games_cue_sheet_is_token (self, "FILE", tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = games_cue_sheet_get_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	file_name = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = games_cue_sheet_get_optional_token (self, tokens, (gint*) (tokens_length1), i, line);
	file_format_string = _tmp1_;
	games_cue_sheet_is_end_of_line (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			return NULL;
		} else {
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = file_name;
	if (g_str_has_prefix (_tmp4_, "\"")) {
		const gchar* _tmp5_;
		_tmp5_ = file_name;
		_tmp3_ = g_str_has_suffix (_tmp5_, "\"");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = file_name;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ > 1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = file_name;
		_tmp10_ = file_name;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_slice (_tmp9_, (glong) 1, (glong) (_tmp12_ - 1));
		_g_free0 (file_name);
		file_name = _tmp13_;
	}
	_tmp14_ = games_cue_sheet_get_file (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_file_get_parent (_tmp15_);
	dir = _tmp16_;
	_tmp17_ = dir;
	_tmp18_ = file_name;
	_tmp19_ = g_file_get_child (_tmp17_, _tmp18_);
	child_file = _tmp19_;
	_tmp20_ = file_format_string;
	file_format = games_cue_sheet_file_format_parse_string (_tmp20_);
	if (file_format == GAMES_CUE_SHEET_FILE_FORMAT_INVALID) {
		GFile* _tmp21_;
		GFile* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp21_ = games_cue_sheet_get_file (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_file_get_basename (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = file_format_string;
		_tmp26_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_INVALID_FILE_FORMAT, "%s:%lu: Invalid file format %s, expected a valid file format or none.", _tmp24_, (gulong) line, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp24_);
		_inner_error0_ = _tmp27_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			return NULL;
		} else {
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp28_ = child_file;
	_tmp29_ = games_cue_sheet_file_node_new (_tmp28_, file_format);
	result = _tmp29_;
	_g_object_unref0 (child_file);
	_g_object_unref0 (dir);
	_g_free0 (file_format_string);
	_g_free0 (file_name);
	return result;
}

static GamesCueSheetTrackNode*
games_cue_sheet_parse_track_line (GamesCueSheet* self,
                                  gchar*** tokens,
                                  gint* tokens_length1,
                                  gsize* i,
                                  gsize line,
                                  GamesCueSheetFileNode* parent_file,
                                  GError** error)
{
	gchar* track_number_string = NULL;
	gchar* _tmp6_;
	gchar* track_mode_string = NULL;
	gchar* _tmp7_;
	gint track_number = 0;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GamesCueSheetTrackMode track_mode = 0;
	const gchar* _tmp17_;
	GamesCueSheetTrackNode* _tmp25_;
	GError* _inner_error0_ = NULL;
	GamesCueSheetTrackNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (parent_file == NULL) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp0_ = games_cue_sheet_get_file (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_get_basename (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN, "%s:%lu: Unexpected token TRACK before a FILE token.", _tmp3_, (gulong) line);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	games_cue_sheet_is_token (self, "TRACK", tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = games_cue_sheet_get_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	track_number_string = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = games_cue_sheet_get_token (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	track_mode_string = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	games_cue_sheet_is_end_of_line (self, tokens, (gint*) (tokens_length1), i, line, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = track_number_string;
	track_number = atoi (_tmp8_);
	if (track_number < 1) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = track_number > 99;
	}
	if (_tmp9_) {
		GFile* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		GError* _tmp16_;
		_tmp10_ = games_cue_sheet_get_file (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_get_basename (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = track_number_string;
		_tmp15_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_INVALID_TRACK_NUMBER, "%s:%lu: Invalid track number %s, expected a number in the 1-99 range.", _tmp13_, (gulong) line, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp13_);
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp17_ = track_mode_string;
	track_mode = games_cue_sheet_track_mode_parse_string (_tmp17_);
	if (track_mode == GAMES_CUE_SHEET_TRACK_MODE_INVALID) {
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		GError* _tmp23_;
		GError* _tmp24_;
		_tmp18_ = games_cue_sheet_get_file (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_get_basename (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = track_mode_string;
		_tmp23_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_INVALID_TRACK_MODE, "%s:%lu: Invalid track mode %s, expected a valid track mode.", _tmp21_, (gulong) line, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp21_);
		_inner_error0_ = _tmp24_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp25_ = games_cue_sheet_track_node_new (parent_file, track_number, track_mode);
	result = _tmp25_;
	_g_free0 (track_mode_string);
	_g_free0 (track_number_string);
	return result;
}

static void
games_cue_sheet_is_token (GamesCueSheet* self,
                          const gchar* expected_token,
                          gchar*** tokens,
                          gint* tokens_length1,
                          gsize* i,
                          gsize line,
                          GError** error)
{
	const gchar* _tmp6_;
	gsize _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expected_token != NULL);
	if ((*i) >= ((gsize) (*tokens_length1))) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp0_ = games_cue_sheet_get_file (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_get_basename (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOF, "%s:%lu: Unexpected end of file, expected %s.", _tmp3_, (gulong) line, expected_token);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = (*tokens)[*i];
	if (g_strcmp0 (_tmp6_, GAMES_CUE_SHEET_NEW_LINE) == 0) {
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp7_ = games_cue_sheet_get_file (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_basename (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = (*tokens)[*i];
		_tmp12_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN, "%s:%lu: Unexpected token %s, expected %s.", _tmp10_, (gulong) line, _tmp11_, expected_token);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp10_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp14_ = *i;
	*i = _tmp14_ + 1;
}

static gchar*
games_cue_sheet_get_token (GamesCueSheet* self,
                           gchar*** tokens,
                           gint* tokens_length1,
                           gsize* i,
                           gsize line,
                           GError** error)
{
	const gchar* _tmp6_;
	gsize _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if ((*i) >= ((gsize) (*tokens_length1))) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp0_ = games_cue_sheet_get_file (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_get_basename (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOF, "%s:%lu: Unexpected end of file, expected a token.", _tmp3_, (gulong) line);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = (*tokens)[*i];
	if (g_strcmp0 (_tmp6_, GAMES_CUE_SHEET_NEW_LINE) == 0) {
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp7_ = games_cue_sheet_get_file (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_basename (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOL, "%s:%lu: Unexpected end of line, expected a token.", _tmp10_, (gulong) line);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error0_ = _tmp12_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = *i;
	*i = _tmp13_ + 1;
	_tmp14_ = (*tokens)[_tmp13_];
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	return result;
}

static gchar*
games_cue_sheet_get_optional_token (GamesCueSheet* self,
                                    gchar*** tokens,
                                    gint* tokens_length1,
                                    gsize* i,
                                    gsize line)
{
	const gchar* _tmp0_;
	gsize _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if ((*i) >= ((gsize) (*tokens_length1))) {
		result = NULL;
		return result;
	}
	_tmp0_ = (*tokens)[*i];
	if (g_strcmp0 (_tmp0_, GAMES_CUE_SHEET_NEW_LINE) == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = *i;
	*i = _tmp1_ + 1;
	_tmp2_ = (*tokens)[_tmp1_];
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
games_cue_sheet_is_end_of_line (GamesCueSheet* self,
                                gchar*** tokens,
                                gint* tokens_length1,
                                gsize* i,
                                gsize line,
                                GError** error)
{
	gboolean _tmp0_ = FALSE;
	gsize _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if ((*i) < ((gsize) (*tokens_length1))) {
		const gchar* _tmp1_;
		_tmp1_ = (*tokens)[*i];
		_tmp0_ = g_strcmp0 (_tmp1_, GAMES_CUE_SHEET_NEW_LINE) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp2_ = games_cue_sheet_get_file (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_basename (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = (*tokens)[*i];
		_tmp7_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN, "%s:%lu: Unexpected token %s, expected end of line.", _tmp5_, (gulong) line, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = *i;
	*i = _tmp9_ + 1;
}

GFile*
games_cue_sheet_get_file (GamesCueSheet* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

guint
games_cue_sheet_get_tracks_number (GamesCueSheet* self)
{
	guint result;
	GamesCueSheetTrackNode** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->tracks;
	_tmp0__length1 = self->priv->tracks_length1;
	result = (guint) _tmp0__length1;
	return result;
}

static void
games_cue_sheet_class_init (GamesCueSheetClass * klass,
                            gpointer klass_data)
{
	games_cue_sheet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesCueSheet_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_cue_sheet_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_cue_sheet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_CUE_SHEET_FILE_PROPERTY, games_cue_sheet_properties[GAMES_CUE_SHEET_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_CUE_SHEET_TRACKS_NUMBER_PROPERTY, games_cue_sheet_properties[GAMES_CUE_SHEET_TRACKS_NUMBER_PROPERTY] = g_param_spec_uint ("tracks-number", "tracks-number", "tracks-number", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
games_cue_sheet_instance_init (GamesCueSheet * self,
                               gpointer klass)
{
	self->priv = games_cue_sheet_get_instance_private (self);
}

static void
games_cue_sheet_finalize (GObject * obj)
{
	GamesCueSheet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_CUE_SHEET, GamesCueSheet);
	_g_object_unref0 (self->priv->_file);
	self->priv->tracks = (_vala_array_free (self->priv->tracks, self->priv->tracks_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (games_cue_sheet_parent_class)->finalize (obj);
}

static GType
games_cue_sheet_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesCueSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_cue_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesCueSheet), 0, (GInstanceInitFunc) games_cue_sheet_instance_init, NULL };
	GType games_cue_sheet_type_id;
	games_cue_sheet_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesCueSheet", &g_define_type_info, 0);
	GamesCueSheet_private_offset = g_type_add_instance_private (games_cue_sheet_type_id, sizeof (GamesCueSheetPrivate));
	return games_cue_sheet_type_id;
}

GType
games_cue_sheet_get_type (void)
{
	static volatile gsize games_cue_sheet_type_id__once = 0;
	if (g_once_init_enter (&games_cue_sheet_type_id__once)) {
		GType games_cue_sheet_type_id;
		games_cue_sheet_type_id = games_cue_sheet_get_type_once ();
		g_once_init_leave (&games_cue_sheet_type_id__once, games_cue_sheet_type_id);
	}
	return games_cue_sheet_type_id__once;
}

static void
_vala_games_cue_sheet_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GamesCueSheet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_CUE_SHEET, GamesCueSheet);
	switch (property_id) {
		case GAMES_CUE_SHEET_FILE_PROPERTY:
		g_value_set_object (value, games_cue_sheet_get_file (self));
		break;
		case GAMES_CUE_SHEET_TRACKS_NUMBER_PROPERTY:
		g_value_set_uint (value, games_cue_sheet_get_tracks_number (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

